/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.util;

import org.gvsig.fmap.dal.coverage.util.MathUtils;

public class DefaultMathUtils
implements MathUtils {
    public double clipDecimals(double num, int n) {
        long m = (long)Math.pow(10.0, n);
        long aux = Math.round(num * (double)m);
        return (double)aux / (double)m;
    }

    public double convertPixelsToMms(double pixels, int ppp) {
        return this.convertPixelsToInches(pixels, ppp) * 25.4;
    }

    public double convertPixelsToCms(double pixels, int ppp) {
        return this.convertPixelsToInches(pixels, ppp) * 2.54;
    }

    public double convertPixelsToMts(double pixels, int ppp) {
        return this.convertPixelsToInches(pixels, ppp) * 0.0254;
    }

    public double convertPixelsToInches(double pixels, int ppp) {
        return pixels / (double)ppp;
    }

    public int convertMtsToPixels(double mts, int ppp) {
        return (int)(mts * 39.73007874 * (double)ppp);
    }

    public int convertInchesToPixels(double inches, int ppp) {
        return (int)(inches * (double)ppp);
    }

    public int convertCmsToPixels(double cms, int ppp) {
        return (int)(cms * 0.3973007874 * (double)ppp);
    }

    public int convertMmsToPixels(double mms, int ppp) {
        return (int)(mms * 0.03973007874 * (double)ppp);
    }

    public double format(double num, int n) {
        long m = (long)Math.pow(10.0, n);
        long aux = (long)(num *= (double)m);
        num = (double)aux / (double)m;
        return num;
    }

    public double[] convertDoubleList(Double[] list) {
        if (list == null) {
            return null;
        }
        double[] result = new double[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = list[i];
        }
        return result;
    }

    public int[] convertIntList(Integer[] list) {
        if (list == null) {
            return null;
        }
        int[] result = new int[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = list[i];
        }
        return result;
    }

    public double adjustDouble(double d) {
        if (d >= 1.0) {
            double a = d - (double)((int)d);
            a = a > 0.95 || a < 0.05 ? (double)Math.round(d) : d;
            a = (double)Math.round(a * 10000.0) / 10000.0;
            return a;
        }
        return d;
    }

    public String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }
}

