/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.resource.spi;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.exception.CopyParametersException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.resource.ResourceParameters;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.resource.exception.PrepareResourceException;
import org.gvsig.fmap.dal.resource.exception.ResourceException;
import org.gvsig.fmap.dal.resource.exception.ResourceExecuteException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyChangesException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyCloseException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyDisposeException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyOpenException;
import org.gvsig.fmap.dal.resource.impl.DefaultResourceNotification;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.WeakReferencingObservable;
import org.gvsig.tools.observer.impl.BaseWeakReferencingObservable;
import org.gvsig.tools.observer.impl.DelegateWeakReferencingObservable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResource
implements ResourceProvider,
WeakReferencingObservable {
    private static Logger logger = LoggerFactory.getLogger(AbstractResource.class);
    private DelegateWeakReferencingObservable delegateObservable;
    private List consumers = new ArrayList();
    private long lastTimeOpen;
    private long lastTimeUsed = this.lastTimeOpen = System.currentTimeMillis();
    private ResourceParameters parameters = null;
    private ResourceParameters preparedParameters = null;
    private Object data;
    private int openCount = 0;
    private int executeCount = 0;
    protected final Object lock;
    protected Object multiResourcelock;

    protected AbstractResource(ResourceParameters parameters) throws InitializeException {
        this.delegateObservable = new DelegateWeakReferencingObservable((WeakReferencingObservable)this);
        this.lock = new Object();
        this.multiResourcelock = new Object();
        if (parameters != null) {
            try {
                this.parameters = (ResourceParameters)parameters.getCopy();
            }
            catch (CopyParametersException e) {
                throw new InitializeException((Throwable)e);
            }
        }
    }

    protected final void updateLastTimeUsed() {
        this.lastTimeUsed = System.currentTimeMillis();
    }

    protected final void updateLastTimeOpen() {
        this.lastTimeUsed = this.lastTimeOpen = System.currentTimeMillis();
    }

    public final long getLastTimeOpen() {
        return this.lastTimeOpen;
    }

    public final long getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    public ResourceParameters getParameters() {
        if (this.preparedParameters != null) {
            return this.preparedParameters;
        }
        return this.parameters;
    }

    public void prepare(ResourceParameters params) throws PrepareResourceException {
        DefaultResourceNotification notification = new DefaultResourceNotification((Resource)this, "Prepare_Resource", params);
        this.delegateObservable.notifyObservers((Object)notification);
    }

    public void prepare() throws PrepareResourceException {
        if (this.preparedParameters == null && this.parameters != null) {
            try {
                ResourceParameters params = (ResourceParameters)this.parameters.getCopy();
                this.prepare(params);
                this.preparedParameters = params;
            }
            catch (CopyParametersException e) {
                throw new PrepareResourceException((Resource)this, (Throwable)e);
            }
        }
    }

    public void notifyOpen() throws ResourceNotifyOpenException {
        this.notifyObserver("Begin_Open_Resource");
        this.updateLastTimeOpen();
        ++this.openCount;
    }

    public void notifyClose() throws ResourceNotifyCloseException {
        if (this.openCount <= 0) {
            try {
                throw new IllegalStateException();
            }
            catch (IllegalStateException ex) {
                logger.warn("notify close in a resource already closed (" + this.parameters == null ? "null" : this.parameters.toString() + ").", (Throwable)ex);
                this.notifyObserver("Begin_Close_Resource");
            }
        } else {
            this.notifyObserver("Begin_Close_Resource");
            --this.openCount;
        }
    }

    public void notifyChanges() throws ResourceNotifyChangesException {
        this.notifyObserver("Changed_Resource");
        Iterator it = this.consumers.iterator();
        while (it.hasNext()) {
            try {
                ResourceConsumer consumer = (ResourceConsumer)((WeakReference)it.next()).get();
                if (consumer == null) {
                    it.remove();
                    continue;
                }
                consumer.resourceChanged((ResourceProvider)this);
            }
            catch (Throwable th) {
                logger.warn("Can't notify changes to consumers", th);
            }
        }
    }

    public boolean isOpen() {
        return this.openCount > 0;
    }

    public int openCount() {
        return this.openCount;
    }

    public void addObserver(Observer o) {
        this.delegateObservable.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.delegateObservable.deleteObserver(o);
    }

    public void deleteObservers() {
        this.delegateObservable.deleteObservers();
    }

    public final void addObservers(BaseWeakReferencingObservable observers) {
        this.delegateObservable.addObservers(observers);
    }

    public final void addConsumer(ResourceConsumer consumer) {
        this.updateConsumersList();
        this.consumers.add(new WeakReference<ResourceConsumer>(consumer));
    }

    public final void removeConsumer(ResourceConsumer consumer) {
        Iterator it = this.consumers.iterator();
        while (it.hasNext()) {
            ResourceConsumer cur = (ResourceConsumer)((WeakReference)it.next()).get();
            if (cur != null && cur != consumer) continue;
            it.remove();
        }
    }

    public int getConsumersCount() {
        this.updateConsumersList();
        return this.consumers.size();
    }

    public ResourceConsumer getConsumerAt(int i) {
        this.updateConsumersList();
        if (this.consumers == null) {
            return null;
        }
        return (ResourceConsumer)this.consumers.get(i);
    }

    private synchronized void updateConsumersList() {
        Iterator it = this.consumers.iterator();
        while (it.hasNext()) {
            WeakReference ref = (WeakReference)it.next();
            if (ref.get() != null) continue;
            it.remove();
        }
    }

    public void closeRequest() throws ResourceException {
        if (this.inUse()) {
            return;
        }
        if (this.consumers != null) {
            Iterator it = this.consumers.iterator();
            while (it.hasNext()) {
                ResourceConsumer consumer = (ResourceConsumer)((WeakReference)it.next()).get();
                if (consumer != null) {
                    consumer.closeResourceRequested((ResourceProvider)this);
                    continue;
                }
                it.remove();
            }
        }
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    protected void notifyObserver(String type) {
        if (this.delegateObservable != null) {
            this.delegateObservable.notifyObservers((Object)new DefaultResourceNotification((Resource)this, type));
        }
    }

    public void notifyDispose() throws ResourceNotifyDisposeException {
        this.notifyObserver("Begin_Dispose_Resource");
        if (this.consumers != null) {
            this.consumers.clear();
        }
        this.lastTimeOpen = 0L;
        this.lastTimeUsed = 0L;
        this.data = null;
        if (this.delegateObservable != null) {
            this.delegateObservable.deleteObservers();
        }
    }

    public final boolean inUse() {
        return this.executeCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ResourceAction action) throws ResourceExecuteException {
        Object value = null;
        Object object = this.lock;
        synchronized (object) {
            Object object2 = this.multiResourcelock;
            synchronized (object2) {
                this.executeBegins();
                try {
                    value = this.performExecution(action);
                }
                catch (Exception e) {
                    throw new ResourceExecuteException((Resource)this, (Throwable)e);
                }
                finally {
                    this.executeEnds();
                }
            }
        }
        return value;
    }

    protected Object performExecution(ResourceAction action) throws Exception {
        return action.run();
    }

    protected final void executeBegins() {
        ++this.executeCount;
    }

    protected final void executeEnds() {
        this.updateLastTimeUsed();
        --this.executeCount;
    }

    public abstract String getName() throws AccessResourceException;

    public abstract Object get() throws AccessResourceException;
}

