/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.json.JsonObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.exception.CopyParametersException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectEncoder;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.dynobject.exception.DynObjectValidateException;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.persistence.xml.XMLPersistenceManager;
import org.gvsig.tools.persistence.xml.exception.PersistenceInvalidValueException;
import org.gvsig.tools.persistence.xml.exception.PersistenceMissingAttributeException;
import org.gvsig.tools.persistence.xml.exception.PersistenceUnknowTypeException;
import org.gvsig.tools.util.Invocable;
import org.gvsig.tools.util.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataParameters
implements DataParameters,
Validator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataParameters.class);
    private Exception validateException;

    public Object getDynValue(String name) {
        return this.getDelegatedDynObject().getDynValue(name);
    }

    public String getProviderName() {
        try {
            return (String)this.getDynValue("ProviderName");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getDataStoreName() {
        return (String)this.getDynValue("ProviderName");
    }

    public String getDescription() {
        return this.getDynClass().getDescription();
    }

    public String toString() {
        DynObjectEncoder encoder = ToolsLocator.getDynObjectManager().createSimpleDynObjectEncoder();
        return encoder.encode((DynObject)this);
    }

    public String toString(Invocable transform) {
        DynObjectEncoder encoder = ToolsLocator.getDynObjectManager().createSimpleDynObjectEncoder();
        return encoder.encode((DynObject)this, "UTF-8", transform);
    }

    public void setDynValue(String name, Object value) {
        DelegatedDynObject delegated = this.getDelegatedDynObject();
        if (delegated.getDynClass().getDynField(name) != null) {
            delegated.setDynValue(name, value);
        } else {
            try {
                throw new IllegalArgumentException(name);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("Attribute '" + name + "' is not defined in " + delegated.getDynClass().getFullName() + " definition", (Throwable)ex);
            }
        }
    }

    public void clear() {
        DynObjectManager manager = ToolsLocator.getDynObjectManager();
        manager.clear((DynObject)this);
    }

    protected void copyValuesTo(DataParameters target) {
        DynObjectManager manager = ToolsLocator.getDynObjectManager();
        manager.copy((DynObject)this, (DynObject)target);
    }

    public DataParameters getCopy() {
        DataParameters copy;
        try {
            if (this instanceof Cloneable) {
                copy = (DataParameters)this.clone();
            } else {
                copy = (DataParameters)this.getClass().newInstance();
                this.copyValuesTo(copy);
            }
        }
        catch (Exception e) {
            throw new CopyParametersException("data parameters", (Throwable)e);
        }
        return copy;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        DynField[] fields;
        for (DynField field : fields = this.getDelegatedDynObject().getDynClass().getDynFields()) {
            if (!field.isPersistent()) continue;
            String name = field.getName();
            Object value = this.getDynValue(name);
            state.set(name, value);
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        Iterator it = state.getNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            try {
                Object value = state.get(name);
                this.setDynValue(name, value);
            }
            catch (Throwable t) {
                LOGGER.warn("Can't load '" + name + "' property", t);
            }
        }
    }

    public void delegate(DynObject dynObject) {
        this.getDelegatedDynObject().delegate(dynObject);
    }

    public DynClass getDynClass() {
        return this.getDelegatedDynObject().getDynClass();
    }

    public boolean hasDynValue(String name) {
        return this.getDelegatedDynObject().hasDynValue(name);
    }

    public void implement(DynClass dynClass) {
        this.getDelegatedDynObject().implement(dynClass);
    }

    public Object invokeDynMethod(String name, Object[] args) throws DynMethodException {
        return this.getDelegatedDynObject().invokeDynMethod((Object)this, name, args);
    }

    public Object invokeDynMethod(int code, Object[] args) throws DynMethodException {
        return this.getDelegatedDynObject().invokeDynMethod((Object)this, code, args);
    }

    public void validate() throws ValidateDataParametersException {
        try {
            this.getDynClass().validate((DynObject)this);
        }
        catch (DynObjectValidateException e) {
            throw new ValidateDataParametersException((Throwable)e);
        }
    }

    protected void loadPRJ(File file, String parameterName) {
        File prjFile = new File(FilenameUtils.removeExtension((String)file.getAbsolutePath()) + ".prj");
        if (prjFile.exists()) {
            try {
                String contentFile = FileUtils.readFileToString((File)prjFile);
                if (StringUtils.isNotEmpty((CharSequence)contentFile)) {
                    IProjection crs = CRSFactory.getCRSFactory().get("wkt_esri", contentFile);
                    this.setDynValue(parameterName, crs);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Couldn't read prj file ''{}''", (Object)prjFile.getAbsolutePath());
            }
        }
    }

    protected void loadWLD(File file, String parameterName) {
        File wldFile = new File(FilenameUtils.removeExtension((String)file.getAbsolutePath()) + ".wld");
        if (wldFile.exists()) {
            try {
                List lines = FileUtils.readLines((File)wldFile);
                if (lines != null && lines.size() == 6) {
                    this.setDynValue(parameterName, lines);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Couldn't read wld file ''{}''", (Object)wldFile.getAbsolutePath());
            }
        }
    }

    public byte[] toByteArray() {
        try {
            XMLPersistenceManager persistenceManager = new XMLPersistenceManager(ToolsLocator.getPersistenceManager().getFactories());
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            PersistentState state = persistenceManager.getState((Object)this, false, new MutableInt(1));
            persistenceManager.saveState(state, (OutputStream)stream);
            return stream.toByteArray();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get byte[] from parameters.", (Throwable)ex);
            return null;
        }
    }

    public static DataParameters fromByteArray(byte[] data) {
        PersistenceManager defaultPersistenceManager = ToolsLocator.getPersistenceManager();
        try {
            XMLPersistenceManager xmlPersistenceManager = new XMLPersistenceManager();
            for (PersistenceFactory factory : defaultPersistenceManager.getFactories()) {
                xmlPersistenceManager.registerFactory(factory);
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            Object x = xmlPersistenceManager.getObject((InputStream)stream);
            DataParameters parameters = (DataParameters)x;
            return parameters;
        }
        catch (PersistenceInvalidValueException | PersistenceMissingAttributeException | PersistenceUnknowTypeException ex) {
            LOGGER.warn("Can't get parameters from byte[].", ex);
            return null;
        }
        catch (Exception ex) {
            LOGGER.debug("Can't get parameters from byte[] with XMLPersistenceManager.", (Throwable)ex);
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(data);
                DataParameters parameters = (DataParameters)defaultPersistenceManager.getObject((InputStream)stream);
                return parameters;
            }
            catch (Exception ex2) {
                LOGGER.warn("Can't get parameters from byte[].", (Throwable)ex2);
                return null;
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DynObject)) {
            return false;
        }
        DynObjectManager manager = ToolsLocator.getDynObjectManager();
        return manager.equals((DynObject)this, (DynObject)obj);
    }

    public int hashCode() {
        DynObjectManager manager = ToolsLocator.getDynObjectManager();
        return manager.hashCode((DynObject)this);
    }

    public JsonObject toJson() {
        JsonObjectBuilder builder = this.toJsonBuilder();
        return builder.build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add_class((Object)this);
        builder.addAll((DynObject)this);
        return builder;
    }

    public void fromJson(JsonObject json) {
        Json.addAll((DynObject)this, (JsonObject)json);
    }

    protected abstract DelegatedDynObject getDelegatedDynObject();

    public boolean isValid(Object data, Object ... args) {
        try {
            this.validate();
            return true;
        }
        catch (Exception e) {
            this.validateException = e;
            return false;
        }
    }

    public String getMessage() {
        if (this.validateException == null) {
            return null;
        }
        return this.validateException.getMessage();
    }

    public Throwable getCause() {
        return this.validateException;
    }
}

