/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.spi;

import org.gvsig.fmap.dal.BaseStoresRepository;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.util.UnmodifiableBasicMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataStore
extends AbstractDisposable
implements DataStore {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataStore.class);
    protected boolean ignoreDALResource = false;

    protected AbstractDataStore() {
    }

    protected abstract DataManager getDataManager();

    public ResourcesStorage getResourcesStorage() {
        try {
            return this.getExplorer().getResourcesStorage((DataStore)this);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't create resources storage", (Throwable)ex);
            return null;
        }
    }

    public StoresRepository getStoresRepository() {
        final StoresRepository mainRepository = this.getDataManager().getStoresRepository();
        BaseStoresRepository repository = new BaseStoresRepository(this.getName()){

            protected DataStoreParameters getMyParameters(String name) {
                DataStore store = (DataStore)AbstractDataStore.this.getChildren().get((Object)name);
                if (store == null) {
                    return null;
                }
                return store.getParameters();
            }

            protected boolean isEmptyMyRepository() {
                UnmodifiableBasicMap<String, DataStore> children = AbstractDataStore.this.getChildren();
                return children == null || children.isEmpty();
            }

            protected int getMySize() {
                UnmodifiableBasicMap<String, DataStore> children = AbstractDataStore.this.getChildren();
                if (children == null) {
                    return 0;
                }
                return children.size();
            }

            public void add(String name, DataStoreParameters parameters) {
                mainRepository.add(name, parameters);
            }

            public void remove(String name) {
                mainRepository.remove(name);
            }
        };
        return repository;
    }

    public UnmodifiableBasicMap<String, DataStore> getChildren() {
        return UnmodifiableBasicMap.EMPTY_UNMODIFIABLEBASICMAP;
    }

    public void setIgnoreDALResource(boolean ignoreDALResource) {
        this.ignoreDALResource = ignoreDALResource;
    }
}

