/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataServerExplorerPool;
import org.gvsig.fmap.dal.DataServerExplorerPoolEntry;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.spi.DataServerExplorerPoolAdapterToStoresRepository;
import org.gvsig.fmap.dal.spi.DataServerExplorerPoolEntryImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DataServerExplorerPoolImpl
implements DataServerExplorerPool {
    private static final String PERSISTENCE_DEFINITION_NAME = "DataServerExplorerPool";
    private List<DataServerExplorerPoolEntry> pool = new ArrayList<DataServerExplorerPoolEntry>();

    public boolean contains(String name) {
        DataServerExplorerPoolEntry entry = this.get(name);
        return entry != null;
    }

    public boolean contains(DataServerExplorerPoolEntry entry) {
        return this.contains(entry.getName());
    }

    public boolean isEmpty() {
        return this.pool.isEmpty();
    }

    public DataServerExplorerPoolEntry createEntry(String name, String description, DataServerExplorerParameters explorer) {
        DataServerExplorerPoolEntryImpl entry = new DataServerExplorerPoolEntryImpl(name, description, explorer);
        return entry;
    }

    public void add(String name, DataServerExplorerParameters explorer) {
        this.add(name, null, explorer);
    }

    public void add(String name, String description, DataServerExplorerParameters explorer) {
        DataServerExplorerPoolEntry newexplorer = this.createEntry(name, description, explorer);
        DataServerExplorerPoolEntry existent = this.get(name);
        if (existent != null) {
            newexplorer.copyTo(existent);
        } else {
            this.pool.add(newexplorer);
        }
    }

    public void remove(DataServerExplorerPoolEntry entry) {
        this.remove(entry.getName());
    }

    public void remove(int explorerIndex) {
        this.pool.remove(explorerIndex);
    }

    public void remove(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return;
        }
        for (int i = 0; i < this.pool.size(); ++i) {
            DataServerExplorerPoolEntry entry = this.pool.get(i);
            if (!name.equalsIgnoreCase(entry.getName())) continue;
            this.remove(i);
        }
    }

    public int size() {
        return this.pool.size();
    }

    public DataServerExplorerPoolEntry get(int index) {
        return this.pool.get(index);
    }

    public DataServerExplorerPoolEntry get(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        for (int i = 0; i < this.pool.size(); ++i) {
            DataServerExplorerPoolEntry entry = this.pool.get(i);
            if (!name.equalsIgnoreCase(entry.getName())) continue;
            return entry;
        }
        return null;
    }

    public Iterator iterator() {
        ArrayList<DataServerExplorerPoolEntry> x = new ArrayList<DataServerExplorerPoolEntry>(this.pool);
        Collections.sort(x, new Comparator<DataServerExplorerPoolEntry>(){

            @Override
            public int compare(DataServerExplorerPoolEntry o1, DataServerExplorerPoolEntry o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return StringUtils.compare((String)o1.getName(), (String)o2.getName());
            }
        });
        return x.iterator();
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("pool", this.pool);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        List l = state.getList("pool");
        this.pool = new ArrayList<DataServerExplorerPoolEntry>();
        this.pool.addAll(l);
        Iterator<DataServerExplorerPoolEntry> it = this.pool.iterator();
        while (it.hasNext()) {
            DataServerExplorerPoolEntry next = it.next();
            if (!StringUtils.isBlank((CharSequence)next.getName())) continue;
            it.remove();
        }
    }

    public static void registerPersistenceDefinition() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(DataServerExplorerPoolImpl.class, PERSISTENCE_DEFINITION_NAME, "DataServerExplorerPool Persistent definition", null, null);
            definition.addDynFieldList("pool").setClassOfItems(DataServerExplorerPoolEntryImpl.class).setMandatory(true).setPersistent(true);
        }
    }

    public StoresRepository getStoresRepository() {
        return new DataServerExplorerPoolAdapterToStoresRepository(this);
    }
}

