/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gdal.prov.gml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gdal.gdal.gdal;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Driver;
import org.gdal.ogr.Feature;
import org.gdal.ogr.FeatureDefn;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.GeomFieldDefn;
import org.gdal.ogr.Layer;
import org.gdal.ogr.ogr;
import org.gdal.osr.SpatialReference;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.CopyException;
import org.gvsig.fmap.dal.exception.CreateException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.WriteException;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.gdal.prov.gml.GMLDataStoreParameters;
import org.gvsig.gdal.prov.ogr.OGRConverter;
import org.gvsig.gdal.prov.ogr.OGRDataStoreProvider;
import org.gvsig.gdal.prov.ogr.OGRUnsupportedFormatException;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMLDataStoreProvider
extends OGRDataStoreProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GMLDataStoreProvider.class);
    public static final String NAME = "GMLDataStoreProvider";
    public static final String DESCRIPTION = "GML provider to open vectorial resources";

    protected GMLDataStoreProvider(DataStoreParameters dataParameters, DataStoreProviderServices storeServices, DynObject metadata) throws InitializeException {
        super(dataParameters, storeServices, metadata);
    }

    protected GMLDataStoreProvider(DataStoreParameters dataParameters, DataStoreProviderServices storeServices) throws InitializeException {
        super(dataParameters, storeServices);
    }

    protected synchronized DataSource getDataSource() throws OGRUnsupportedFormatException {
        try {
            if (this.dataSource == null) {
                if (this.getGMLParameters().getXsdSchema() != null && StringUtils.isBlank((CharSequence)this.getGMLParameters().getConnectionString())) {
                    StringBuilder stb = new StringBuilder();
                    if (StringUtils.isBlank((CharSequence)this.getGMLParameters().getConnectionString()) && this.getGMLParameters().getFile() != null) {
                        stb.append(this.getGMLParameters().getFile().getAbsolutePath());
                    } else if (StringUtils.isNotBlank((CharSequence)this.getGMLParameters().getConnectionString())) {
                        stb.append(this.getGMLParameters().getConnectionString());
                    }
                    stb.append(",xsd=");
                    stb.append(this.getGMLParameters().getXsdSchema());
                    this.getGMLParameters().setConnectionString(stb.toString());
                }
                if (this.getGMLParameters().getGfsSchema() != null) {
                    gdal.SetConfigOption((String)"GML_GFS_TEMPLATE", (String)this.getGMLParameters().getGfsSchema().getAbsolutePath());
                }
            }
            DataSource dataSource = super.getDataSource();
            return dataSource;
        }
        finally {
            gdal.SetConfigOption((String)"GML_GFS_TEMPLATE", null);
        }
    }

    private GMLDataStoreParameters getGMLParameters() {
        return (GMLDataStoreParameters)this.getParameters();
    }

    public boolean allowWrite() {
        return true;
    }

    public void performChanges(Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator featureTypesChanged) throws DataException {
        IProjection projection;
        FeatureStore store = this.getStoreServices().getFeatureStore();
        FeatureType defaultFeatureType = store.getDefaultFeatureType();
        String baseName = FilenameUtils.getBaseName((String)this.getGMLParameters().getFile().getName());
        File newFile = null;
        File newSchemaFile = null;
        try {
            newFile = File.createTempFile(baseName, null);
            newSchemaFile = this.getSchemaFile(newFile);
        }
        catch (IOException e) {
            String msg = String.format("Temp %1s file", baseName);
            throw new CreateException(msg, (Throwable)e);
        }
        Driver driver = ogr.GetDriverByName((String)"GML");
        Vector<String> options = new Vector<String>(1);
        options.add("FORMAT=GML3.2");
        DataSource newDataSource = driver.CreateDataSource(newFile.getAbsolutePath(), options);
        OGRConverter converter = new OGRConverter();
        for (int i = 0; i < this.getDataSource().GetLayerCount(); ++i) {
            Layer tmpLayer = this.getDataSource().GetLayerByIndex(i);
            if (tmpLayer.GetName().equals(this.getGMLParameters().getLayerName())) continue;
            SpatialReference srs = tmpLayer.GetSpatialRef();
            int ogrGeomType = tmpLayer.GetGeomType();
            ArrayList<FieldDefn> fields = new ArrayList<FieldDefn>();
            FeatureDefn layerDefn = tmpLayer.GetLayerDefn();
            for (int j = 0; j < layerDefn.GetFieldCount(); ++j) {
                fields.add(layerDefn.GetFieldDefn(j));
            }
            ArrayList<GeomFieldDefn> geomFields = new ArrayList<GeomFieldDefn>();
            for (int j = 0; j < layerDefn.GetGeomFieldCount(); ++j) {
                geomFields.add(layerDefn.GetGeomFieldDefn(j));
            }
            ArrayList<Feature> ogrFeatures = new ArrayList<Feature>();
            Feature feature = tmpLayer.GetNextFeature();
            while (feature != null) {
                ogrFeatures.add(feature);
            }
            this.createLayer(newDataSource, tmpLayer.GetName(), srs, ogrGeomType, fields, geomFields, ogrFeatures);
        }
        SpatialReference srs = this.getLayer().GetSpatialRef();
        if (srs == null && (projection = defaultFeatureType.getDefaultSRS()) == null && (projection = (IProjection)this.getDynValue("CRS")) != null) {
            srs = new SpatialReference(projection.export("wkt"));
        }
        int ogrGeomType = -1;
        GeometryType geomType = defaultFeatureType.getDefaultGeometryAttribute().getGeomType();
        if (geomType != null) {
            ogrGeomType = converter.convertToOGRGeomType(geomType.getType());
        }
        List fields = converter.convertFields(defaultFeatureType);
        List geomFields = converter.convertGeometryFields(defaultFeatureType, true);
        FeatureSet featureSet = this.getFeatureStore().getFeatureSet();
        this.createLayer(newDataSource, this.getLayer().GetName(), srs, ogrGeomType, (List<FieldDefn>)fields, (List<GeomFieldDefn>)geomFields, featureSet);
        newDataSource.delete();
        this.getResource().removeConsumer((ResourceConsumer)this);
        this.getResource().closeRequest();
        if (this.getGMLParameters().getFile().delete()) {
            try {
                FileUtils.copyFile((File)newFile, (File)this.getGMLParameters().getFile());
                FileUtils.copyFile((File)newSchemaFile, (File)this.getSchemaFile(this.getGMLParameters().getFile()));
            }
            catch (IOException e) {
                throw new CopyException(newFile.getName(), (Throwable)e);
            }
        }
        this.resourceProvider = null;
        this.getResource().addConsumer((ResourceConsumer)this);
        this.getResource().notifyChanges();
    }

    private Layer createLayer(DataSource dataSource, String layerName, SpatialReference srs, int ogrGeomType, List<FieldDefn> fields, List<GeomFieldDefn> geomFields, FeatureSet featureSet) throws DataException {
        Layer newLayer = this.createLayer(dataSource, layerName, srs, ogrGeomType, fields, geomFields);
        OGRConverter converter = new OGRConverter();
        DisposableIterator iterator = featureSet.fastIterator();
        try {
            while (iterator.hasNext()) {
                org.gvsig.fmap.dal.feature.Feature feature = (org.gvsig.fmap.dal.feature.Feature)iterator.next();
                FeatureProvider featureProvider = this.getStoreServices().getFeatureProviderFromFeature(feature);
                Feature orgFeature = converter.convert(featureProvider);
                newLayer.CreateFeature(orgFeature);
            }
        }
        catch (BaseException e) {
            LOG.error("Can not convert featureProvider to OGR Feature", (Throwable)e);
            throw new WriteException(newLayer.GetName(), (Throwable)e);
        }
        finally {
            iterator.dispose();
        }
        return newLayer;
    }

    private Layer createLayer(DataSource dataSource, String layerName, SpatialReference srs, int ogrGeomType, List<FieldDefn> fields, List<GeomFieldDefn> geomFields, List<Feature> ogrFeatures) throws DataException {
        Layer newLayer = this.createLayer(dataSource, layerName, srs, ogrGeomType, fields, geomFields);
        OGRConverter converter = new OGRConverter();
        for (Feature feature : ogrFeatures) {
            Feature fixedFeature = converter.convert(newLayer.GetLayerDefn(), feature);
            newLayer.CreateFeature(fixedFeature);
        }
        return newLayer;
    }

    private Layer createLayer(DataSource dataSource, String layerName, SpatialReference srs, int ogrGeomType, List<FieldDefn> fields, List<GeomFieldDefn> geomFields) {
        Layer newLayer = null;
        newLayer = srs == null ? dataSource.CreateLayer(layerName) : (ogrGeomType == -1 ? dataSource.CreateLayer(layerName, srs) : dataSource.CreateLayer(layerName, srs, ogrGeomType));
        if (newLayer.TestCapability("CreateField")) {
            for (FieldDefn fieldDefn : fields) {
                newLayer.CreateField(fieldDefn);
            }
        } else {
            LOG.warn("{} driver does not support creation of fields", (Object)dataSource.GetDriver().getName());
        }
        if (newLayer.TestCapability("CreateGeomField")) {
            for (GeomFieldDefn geomFieldDefn : geomFields) {
                newLayer.CreateGeomField(geomFieldDefn);
            }
        } else {
            LOG.warn("{} driver does not support creation of geometry fields, only default OGR geometry field has been created", (Object)dataSource.GetDriver().getName());
        }
        return newLayer;
    }

    private File getSchemaFile(File newFile) {
        String baseName = FilenameUtils.getBaseName((String)newFile.getName());
        File xsdFiel = new File(newFile.getParentFile(), baseName + ".xsd");
        return xsdFiel;
    }

    public void resourceChanged(ResourceProvider resource) {
        if (this.getGMLParameters().getXsdSchema() == null) {
            File schemaFile = this.getSchemaFile(this.getGMLParameters().getFile());
            if (schemaFile.exists()) {
                this.getGMLParameters().setXsdSchema(schemaFile);
            } else {
                this.getGMLParameters().setXsdSchema(null);
            }
        }
        FeatureStore store = this.getStoreServices().getFeatureStore();
        FeatureType defaultFeatureType = null;
        try {
            defaultFeatureType = store.getDefaultFeatureType();
            this.getGMLParameters().setDefaultGeometryField(defaultFeatureType.getDefaultGeometryAttributeName());
        }
        catch (DataException e) {
            LOG.error("Can not default featury type of {}", (Object)this.getName());
            return;
        }
        super.resourceChanged(resource);
    }
}

