/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.exportto.generic.util;

import java.io.IOException;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.gpe.lib.api.parser.ICoordinateIterator;
import org.gvsig.gpe.lib.api.writer.ICoordinateSequence;

public class CoordinatesSequencePoint
implements ICoordinateSequence,
ICoordinateIterator {
    double[] points = null;
    int index = 0;

    public CoordinatesSequencePoint(Point point) {
        if (point.getDimension() == 3) {
            this.points = new double[3];
            this.points[0] = point.getX();
            this.points[1] = point.getY();
            this.points[2] = point.getCoordinateAt(2);
            this.index = 3;
        } else {
            this.points = new double[2];
            this.points[0] = point.getX();
            this.points[1] = point.getY();
            this.index = 2;
        }
    }

    public int getSize() {
        return 1;
    }

    public ICoordinateIterator iterator() {
        return this;
    }

    public int getDimension() {
        return this.points.length;
    }

    public boolean hasNext() throws IOException {
        return this.index > 0;
    }

    public void next(double[] buffer) throws IOException {
        buffer[0] = this.points[0];
        buffer[1] = this.points[1];
        if (buffer.length == 3 && this.points.length == 3) {
            buffer[2] = this.points[2];
        }
        --this.index;
    }
}

