/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.app.gui.styling.PatternEditor;
import org.gvsig.gui.beans.DefaultBean;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.i18n.Messages;

public class LineProperties
extends DefaultBean
implements ActionListener {
    private static final long serialVersionUID = 6356385079456043011L;
    private JRadioButton joinBevel;
    private JRadioButton joinMiter;
    private JRadioButton joinRound;
    private JRadioButton capBut;
    private JRadioButton capRound;
    private JRadioButton capSquare;
    private PatternEditor pe;
    private JButton clearButton;
    private float width;
    private ActionListener patternChange = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            LineProperties.this.callValueChanged(LineProperties.this.getLinePropertiesStyle());
        }
    };
    private ActionListener clear = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            LineProperties.this.pe.clear_Dash();
            LineProperties.this.callValueChanged(LineProperties.this.getLinePropertiesStyle());
        }
    };

    public LineProperties(float lineWidth) {
        this.width = lineWidth;
        this.initialize();
    }

    private void initialize() {
        this.setName(Messages.getText((String)"line_properties"));
        this.setLayout(new BorderLayout(10, 10));
        JPanel aux2 = new JPanel();
        JPanel pnlJoin = new JPanel(new FlowLayout(0, 15, 0));
        pnlJoin.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.getText((String)"join_style") + ":"));
        JPanel d = new JPanel();
        d.setLayout(new BoxLayout(d, 1));
        this.joinBevel = new JRadioButton(IconThemeHelper.getImageIcon((String)"line-properties-join-bevel"));
        this.joinBevel.setSelectedIcon(IconThemeHelper.getImageIcon((String)"line-properties-join-bevel-selected"));
        FlowLayout flowCenteredLayout = new FlowLayout(1, 0, 0);
        JPanel toCenter = new JPanel(flowCenteredLayout);
        toCenter.add(this.joinBevel);
        d.add(toCenter);
        toCenter = new JPanel(flowCenteredLayout);
        toCenter.add(new JLabel(Messages.getText((String)"join_bevel")));
        d.add(toCenter);
        pnlJoin.add(d);
        d = new JPanel();
        d.setLayout(new BoxLayout(d, 1));
        this.joinMiter = new JRadioButton(IconThemeHelper.getImageIcon((String)"line-properties-join-miter"));
        this.joinMiter.setSelectedIcon(IconThemeHelper.getImageIcon((String)"line-properties-join-miter-selected"));
        toCenter = new JPanel(flowCenteredLayout);
        toCenter.add(this.joinMiter);
        d.add(toCenter);
        toCenter = new JPanel(flowCenteredLayout);
        toCenter.add(new JLabel(Messages.getText((String)"join_miter")));
        d.add(toCenter);
        pnlJoin.add(d);
        d = new JPanel();
        d.setLayout(new BoxLayout(d, 1));
        this.joinRound = new JRadioButton(IconThemeHelper.getImageIcon((String)"line-properties-join-round"));
        this.joinRound.setSelectedIcon(IconThemeHelper.getImageIcon((String)"line-properties-join-round-selected"));
        toCenter = new JPanel(flowCenteredLayout);
        toCenter.add(this.joinRound);
        d.add(toCenter);
        toCenter = new JPanel(flowCenteredLayout);
        toCenter.add(new JLabel(Messages.getText((String)"join_round")));
        d.add(toCenter);
        pnlJoin.add(d);
        ButtonGroup groupJoin = new ButtonGroup();
        groupJoin.add(this.joinBevel);
        groupJoin.add(this.joinMiter);
        groupJoin.add(this.joinRound);
        aux2.add(pnlJoin);
        JPanel aux3 = new JPanel();
        JPanel pnlCap = new JPanel(new FlowLayout(0, 30, 0));
        pnlCap.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.getText((String)"end_style") + ":"));
        JPanel c = new JPanel();
        c.setLayout(new BoxLayout(c, 1));
        this.capBut = new JRadioButton(IconThemeHelper.getImageIcon((String)"line-properties-cap-butt"));
        this.capBut.setSelectedIcon(IconThemeHelper.getImageIcon((String)"line-properties-cap-butt-selected"));
        toCenter = new JPanel(flowCenteredLayout);
        toCenter.add(this.capBut);
        c.add(toCenter);
        toCenter = new JPanel(flowCenteredLayout);
        toCenter.add(new JLabel(Messages.getText((String)"cap_butt")));
        c.add(toCenter);
        pnlCap.add(c);
        JPanel a = new JPanel();
        a.setLayout(new BoxLayout(a, 1));
        this.capRound = new JRadioButton(IconThemeHelper.getImageIcon((String)"line-properties-cap-round"));
        this.capRound.setSelectedIcon(IconThemeHelper.getImageIcon((String)"line-properties-cap-round-selected"));
        toCenter = new JPanel(flowCenteredLayout);
        toCenter.add(this.capRound);
        a.add(toCenter);
        toCenter = new JPanel(flowCenteredLayout);
        toCenter.add(new JLabel(Messages.getText((String)"cap_round")));
        a.add(toCenter);
        pnlCap.add(a);
        JPanel b = new JPanel();
        b.setLayout(new BoxLayout(b, 1));
        this.capSquare = new JRadioButton(IconThemeHelper.getImageIcon((String)"line-properties-cap-square"));
        this.capSquare.setSelectedIcon(IconThemeHelper.getImageIcon((String)"line-properties-cap-square-selected"));
        toCenter = new JPanel(flowCenteredLayout);
        toCenter.add(this.capSquare);
        b.add(toCenter);
        toCenter = new JPanel(flowCenteredLayout);
        toCenter.add(new JLabel(Messages.getText((String)"cap_square")));
        b.add(toCenter);
        pnlCap.add(b);
        ButtonGroup groupCap = new ButtonGroup();
        groupCap.add(this.capBut);
        groupCap.add(this.capRound);
        groupCap.add(this.capSquare);
        aux3.add(pnlCap);
        JPanel aux4 = new JPanel(new FlowLayout(0, 0, 0));
        aux4.add((Component)new JBlank(5, 40));
        this.pe = new PatternEditor();
        this.pe.setPreferredSize(new Dimension(440, 40));
        aux4.add(this.pe);
        aux4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.getText((String)"fill_pattern") + ":"));
        JPanel aux5 = new JPanel(new FlowLayout(0, 15, 0));
        this.clearButton = new JButton(Messages.getText((String)"clear"));
        aux5.add(this.clearButton);
        this.joinBevel.addActionListener(this);
        this.joinMiter.addActionListener(this);
        this.joinRound.addActionListener(this);
        this.capBut.addActionListener(this);
        this.capRound.addActionListener(this);
        this.capSquare.addActionListener(this);
        this.clearButton.addActionListener(this.clear);
        this.pe.addActionListener(this.patternChange);
        JPanel aux = new JPanel(new FlowLayout(0));
        aux.add((Component)aux2, "Center");
        aux.add((Component)aux3, "Center");
        aux.add((Component)aux4, "Center");
        aux.add((Component)aux5, "West");
        this.add(aux, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.callValueChanged(this.getLinePropertiesStyle());
    }

    public void setLinePropertiesStyle(BasicStroke str) {
        if (str == null) {
            str = new BasicStroke();
        }
        switch (str.getLineJoin()) {
            case 0: {
                this.joinMiter.setSelected(true);
                break;
            }
            case 1: {
                this.joinRound.setSelected(true);
                break;
            }
            case 2: {
                this.joinBevel.setSelected(true);
            }
        }
        switch (str.getEndCap()) {
            case 0: {
                this.capBut.setSelected(true);
                break;
            }
            case 1: {
                this.capRound.setSelected(true);
                break;
            }
            case 2: {
                this.capSquare.setSelected(true);
            }
        }
        this.pe.setDash(str.getDashArray());
        this.pe.repaint();
    }

    public BasicStroke getLinePropertiesStyle() {
        int capType = 0;
        int joinType = 0;
        if (this.capBut.isSelected()) {
            capType = 0;
        } else if (this.capRound.isSelected()) {
            capType = 1;
        } else if (this.capSquare.isSelected()) {
            capType = 2;
        }
        if (this.joinMiter.isSelected()) {
            joinType = 0;
        } else if (this.joinRound.isSelected()) {
            joinType = 1;
        } else if (this.joinBevel.isSelected()) {
            joinType = 2;
        }
        float[] dash = this.pe.getDash();
        BasicStroke str = new BasicStroke(this.width, capType, joinType, 10.0f, this.pe.getDash(), 0.0f);
        this.pe.setDash(dash);
        return str;
    }
}

