/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.gui.panels.ColorChooserPanel;
import org.gvsig.app.gui.styling.AbstractTypeSymbolEditor;
import org.gvsig.app.gui.styling.ArrowDecorator;
import org.gvsig.app.gui.styling.EditorTool;
import org.gvsig.app.gui.styling.LineProperties;
import org.gvsig.app.gui.styling.SymbolEditor;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.beans.listeners.BeanListener;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JNumberSpinner;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ISimpleLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IArrowDecoratorStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.ILineStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.ISimpleLineStyle;

public class SimpleLine
extends AbstractTypeSymbolEditor
implements ActionListener {
    private ColorChooserPanel jccColor;
    private JNumberSpinner txtWidth;
    private ArrayList<JPanel> tabs = new ArrayList();
    private ArrowDecorator arrowDecorator;
    private LineProperties lineProperties;
    private JNumberSpinner txtOffset;

    public SimpleLine(SymbolEditor owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        JPanel myTab = new JPanel(new FlowLayout(3, 5, 5));
        myTab.setName(Messages.getText((String)"simple_line"));
        GridBagLayoutPanel aux = new GridBagLayoutPanel();
        this.jccColor = new ColorChooserPanel(true);
        this.jccColor.setAlpha(255);
        aux.addComponent(Messages.getText((String)"color"), (Component)this.jccColor);
        this.txtWidth = new JNumberSpinner(3.0, 25, 0.0, Double.POSITIVE_INFINITY, 1.0);
        aux.addComponent(Messages.getText((String)"width") + ":", (Component)this.txtWidth);
        this.txtOffset = new JNumberSpinner(0.0, 25, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        aux.addComponent(Messages.getText((String)"offset") + ":", (Component)this.txtOffset);
        aux.setPreferredSize(new Dimension(300, 300));
        myTab.add((Component)aux);
        this.jccColor.setColor(Color.BLACK);
        this.txtWidth.setDouble(1.0);
        this.jccColor.addActionListener((ActionListener)this);
        this.txtWidth.addActionListener((ActionListener)this);
        this.txtOffset.addActionListener((ActionListener)this);
        this.tabs.add(myTab);
        this.arrowDecorator = new ArrowDecorator();
        this.arrowDecorator.addListener(new BeanListener(){

            public void beanValueChanged(Object value) {
                SimpleLine.this.fireSymbolChangedEvent();
            }
        });
        this.tabs.add((JPanel)((Object)this.arrowDecorator));
        this.lineProperties = new LineProperties((float)this.txtWidth.getDouble());
        this.lineProperties.addListener(new BeanListener(){

            public void beanValueChanged(Object value) {
                SimpleLine.this.fireSymbolChangedEvent();
            }
        });
        this.tabs.add((JPanel)((Object)this.lineProperties));
    }

    @Override
    public ISymbol getLayer() {
        ISimpleLineSymbol layer = SymbologyLocator.getSymbologyManager().createSimpleLineSymbol();
        layer.setLineColor(this.jccColor.getColor());
        ISimpleLineStyle simplLine = SymbologyLocator.getSymbologyManager().createSimpleLineStyle();
        simplLine.setStroke((Stroke)this.lineProperties.getLinePropertiesStyle());
        simplLine.setOffset(-this.txtOffset.getDouble());
        IArrowDecoratorStyle ads = this.arrowDecorator.getArrowDecoratorStyle();
        if (ads != null) {
            ads.getMarker().setColor(this.jccColor.getColor());
        }
        simplLine.setArrowDecorator(this.arrowDecorator.getArrowDecoratorStyle());
        layer.setLineStyle((ILineStyle)simplLine);
        layer.setLineWidth((double)((float)this.txtWidth.getDouble()));
        return layer;
    }

    @Override
    public String getName() {
        return Messages.getText((String)"simple_line");
    }

    @Override
    public JPanel[] getTabs() {
        return this.tabs.toArray(new JPanel[0]);
    }

    @Override
    public void refreshControls(ISymbol layer) {
        try {
            if (layer == null) {
                System.err.println(this.getClass().getName() + ":: should be unreachable code");
                this.jccColor.setColor(Color.BLACK);
                this.txtWidth.setDouble(1.0);
                this.txtOffset.setDouble(0.0);
            } else {
                ISimpleLineSymbol sym = (ISimpleLineSymbol)layer;
                this.jccColor.setColor(sym.getColor());
                this.txtWidth.setDouble((double)sym.getLineStyle().getLineWidth());
                this.txtOffset.setDouble(sym.getLineStyle().getOffset() == 0.0 ? 0.0 : -sym.getLineStyle().getOffset());
                this.arrowDecorator.setArrowDecoratorStyle(sym.getLineStyle().getArrowDecorator());
                ILineStyle tempLineStyle = (ILineStyle)sym.getLineStyle().clone();
                this.lineProperties.setLinePropertiesStyle((BasicStroke)tempLineStyle.getStroke());
            }
        }
        catch (IndexOutOfBoundsException ioEx) {
            NotificationManager.addWarning((String)"Symbol layer index out of bounds", (Throwable)ioEx);
        }
        catch (ClassCastException ccEx) {
            NotificationManager.addWarning((String)("Illegal casting from " + layer.getClass().getName() + " to ISimpleLineSymbol."), (Throwable)ccEx);
        }
        catch (CloneNotSupportedException e) {
            NotificationManager.addWarning((String)"Symbol line style does not support cloning", (Throwable)e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireSymbolChangedEvent();
    }

    @Override
    public EditorTool[] getEditorTools() {
        return null;
    }

    @Override
    public boolean canManageSymbol(ISymbol symbol) {
        return symbol instanceof ISimpleLineSymbol;
    }
}

