/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.gui.styling.EditorTool;
import org.gvsig.app.gui.styling.StylePreviewer;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.IStyle;
import org.gvsig.gui.beans.AcceptCancelPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class StyleEditor
extends JPanel
implements IWindow,
ActionListener {
    private static final long serialVersionUID = -4002620456610864510L;
    private JPanel pnlNorth = null;
    private JPanel jPanel = null;
    private JPanel pnlCenter = null;
    private AcceptCancelPanel pnlButtons = null;
    private JLabel lblTitle;
    private StylePreviewer preview;
    private JPanel pnlTools;
    private JTextField txtDesc;
    private Hashtable<AbstractButton, EditorTool> tools = new Hashtable();
    private static ArrayList<Class> installedTools = new ArrayList();
    private EditorTool prevTool;
    private ActionListener okAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PluginServices.getMDIManager().closeWindow((IWindow)StyleEditor.this);
        }
    };
    private ActionListener cancelAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            StyleEditor.this.getStylePreviewer().setStyle(null);
            PluginServices.getMDIManager().closeWindow((IWindow)StyleEditor.this);
        }
    };

    public StyleEditor(IStyle style) {
        if (style != null) {
            IStyle sty = null;
            try {
                sty = (IStyle)style.clone();
            }
            catch (CloneNotSupportedException e) {
                NotificationManager.addWarning((String)"Symbol layer", (Throwable)e);
            }
            this.getStylePreviewer().setStyle(sty);
            String desc = sty.getDescription();
            this.getTxtDesc().setText(desc);
        } else {
            this.getTxtDesc().setText(Messages.getText((String)"new_style"));
        }
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(550, 295);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add((Component)this.getPnlNorth(), "North");
        this.add((Component)this.getPnlCenter(), "Center");
        this.add((Component)this.getPnlButtons(), "South");
    }

    public void setStyle(IStyle sty) {
        this.preview.setStyle(sty);
    }

    private JPanel getPnlNorth() {
        if (this.pnlNorth == null) {
            this.lblTitle = new JLabel(Messages.getText((String)"Nombre").concat(":"));
            this.pnlNorth = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.insets = new Insets(3, 3, 3, 3);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            this.pnlNorth.add((Component)this.lblTitle, c);
            c.gridy = 1;
            this.pnlNorth.add((Component)this.getTxtDesc(), c);
        }
        return this.pnlNorth;
    }

    private JTextField getTxtDesc() {
        if (this.txtDesc == null) {
            this.txtDesc = new JTextField(30);
            this.txtDesc.addActionListener(this);
        }
        return this.txtDesc;
    }

    private JPanel getPnlCenter() {
        if (this.pnlCenter == null) {
            this.pnlCenter = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            JPanel aux = new JPanel();
            aux.add(this.getStylePreviewer());
            c.fill = 1;
            c.insets = new Insets(15, 5, 5, 5);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.9;
            c.weighty = 1.0;
            this.pnlCenter.add((Component)this.getStylePreviewer(), c);
            c.fill = 2;
            c.anchor = 17;
            c.gridx = 1;
            c.weightx = 0.1;
            c.gridwidth = 0;
            this.pnlCenter.add((Component)this.getPnlTools(), c);
        }
        return this.pnlCenter;
    }

    public StylePreviewer getStylePreviewer() {
        if (this.preview == null) {
            this.preview = new StylePreviewer();
            this.preview.setShowOutline(true);
        }
        return this.preview;
    }

    private JPanel getPnlButtons() {
        if (this.pnlButtons == null) {
            this.pnlButtons = new AcceptCancelPanel(this.okAction, this.cancelAction);
        }
        return this.pnlButtons;
    }

    public WindowInfo getWindowInfo() {
        WindowInfo wi = new WindowInfo(9);
        wi.setTitle(Messages.getText((String)"edit_style"));
        wi.setWidth(this.getWidth());
        wi.setHeight(this.getHeight());
        return wi;
    }

    public IStyle getStyle() {
        IStyle style = this.getStylePreviewer().getStyle();
        if (style != null) {
            style.setDescription(this.txtDesc.getText());
        }
        return style;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton srcButton = (AbstractButton)e.getSource();
        EditorTool currTool = this.tools.get(srcButton);
        if (currTool != null) {
            this.prevTool = this.preview.setEditorTool(currTool);
        }
    }

    private JPanel getPnlTools() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        if (this.pnlTools == null) {
            this.pnlTools = new JPanel();
            this.pnlTools.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"tools")));
            this.pnlTools.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.insets = new Insets(5, 5, 5, 5);
            c.gridx = 0;
            c.gridy = 0;
            ArrayList<EditorTool> availableTools = new ArrayList<EditorTool>();
            IStyle sty = this.preview.getStyle();
            Class editorClazz2 = null;
            Class[] constrLocator = new Class[]{JComponent.class};
            Object[] constrInitargs = new Object[]{this};
            try {
                for (Class editorClazz2 : installedTools) {
                    Constructor constructor = editorClazz2.getConstructor(constrLocator);
                    EditorTool editorTool = (EditorTool)constructor.newInstance(constrInitargs);
                    if (!editorTool.isSuitableFor(sty)) continue;
                    editorTool.setModel(sty);
                    availableTools.add(editorTool);
                }
                ButtonGroup group = new ButtonGroup();
                for (EditorTool editorTool : availableTools) {
                    AbstractButton button = editorTool.getButton();
                    JLabel lbl = new JLabel("");
                    lbl.setText(button.getToolTipText());
                    button.addActionListener(this);
                    c.gridx = 0;
                    ++c.gridy;
                    this.pnlTools.add((Component)button, c);
                    group.add(button);
                    c.gridx = 1;
                    this.pnlTools.add((Component)lbl, c);
                    this.tools.put(button, editorTool);
                }
            }
            catch (Exception e) {
                NotificationManager.addWarning((String)(Messages.getText((String)"could_not_initialize_editor_") + "'" + editorClazz2 + "'" + " [" + new Date(System.currentTimeMillis()).toString() + "]"));
            }
        }
        return this.pnlTools;
    }

    public void restorePreviousTool() {
        this.preview.setEditorTool(this.prevTool);
    }

    public static void addEditorTool(Class styleEditorClass) {
        installedTools.add(styleEditorClass);
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }
}

