/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.gui.JComboBoxUnits;
import org.gvsig.app.gui.styling.AbstractTypeSymbolEditor;
import org.gvsig.app.gui.styling.JComboBoxUnitsReferenceSystem;
import org.gvsig.app.gui.styling.SymbolLayerManager;
import org.gvsig.app.gui.styling.SymbolPreviewer;
import org.gvsig.app.gui.styling.TypeSymbolEditor;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.beans.AcceptCancelPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.swing.SymbologySwingLocator;
import org.gvsig.symbology.swing.SymbologySwingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolEditor
extends JPanel
implements IWindow {
    private static final long serialVersionUID = 9209260593958625497L;
    private static final GeometryManager GEOMETRY_MANAGER = GeometryLocator.getGeometryManager();
    private static final Logger LOG = LoggerFactory.getLogger(SymbolEditor.class);
    private WindowInfo wi;
    private JPanel pnlWest = null;
    private JPanel pnlCenter = null;
    private JPanel pnlPreview = null;
    private JPanel pnlLayers = null;
    private AcceptCancelPanel okCancelPanel;
    private ISymbol symbol;
    private SymbolPreviewer symbolPreview = null;
    private JPanel pnlTypeAndUnits = null;
    private JComboBox cmbType;
    private JComboBoxUnits cmbUnits;
    private JTabbedPane tabbedPane = null;
    private GeometryType shapeType;
    private ActionListener cmbTypeActionListener;
    private AbstractTypeSymbolEditor[] tabs;
    private SymbolLayerManager layerManager;
    private boolean replacing = false;
    private JComboBoxUnitsReferenceSystem cmbUnitsReferenceSystem;
    private ISymbol oldSymbol;
    private MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
    private transient FeatureStore featureStore;
    private transient MutableObject<Feature> sampleFeature;

    public SymbolEditor(ISymbol symbol, GeometryType geometryType) {
        this.initialize(symbol, geometryType);
    }

    public SymbolEditor(ISymbol symbol, int shapeType) {
        try {
            GeometryType geometryType = GEOMETRY_MANAGER.getGeometryType(shapeType, 0);
            this.initialize(symbol, geometryType);
        }
        catch (Exception e1) {
            LOG.error("Impossible to get the geometry type", (Throwable)e1);
        }
    }

    private void initialize(ISymbol symbol, GeometryType shapeType) {
        if (!(symbol instanceof IMultiLayerSymbol)) {
            IMultiLayerSymbol nSym = this.mapContextManager.getSymbolManager().createMultiLayerSymbol(shapeType.getType());
            nSym.addLayer(symbol);
            if (symbol instanceof CartographicSupport) {
                CartographicSupport cs = (CartographicSupport)symbol;
                CartographicSupport nCs = (CartographicSupport)nSym;
                nCs.setReferenceSystem(cs.getReferenceSystem());
                nCs.setUnit(cs.getUnit());
            }
            this.symbol = nSym;
        } else {
            this.symbol = symbol;
        }
        if (this.symbol instanceof CartographicSupport) {
            CartographicSupport cs = (CartographicSupport)this.symbol;
            this.getCmbUnits().setSelectedUnitIndex(cs.getUnit());
            this.getCmbUnitsReferenceSystem().setSelectedIndex(cs.getReferenceSystem());
        }
        try {
            this.oldSymbol = (ISymbol)this.symbol.clone();
        }
        catch (CloneNotSupportedException e) {
            NotificationManager.addWarning((String)"Symbol layer", (Throwable)e);
        }
        this.shapeType = shapeType;
        this.initialize();
    }

    private void initialize() {
        SymbologySwingManager symbologySwingManager = SymbologySwingLocator.getSwingManager();
        this.cmbTypeActionListener = new ActionListener(){
            int prevIndex = -2;

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = SymbolEditor.this.getCmbType().getSelectedIndex();
                if (this.prevIndex != index) {
                    this.prevIndex = index;
                    AbstractTypeSymbolEditor options = (AbstractTypeSymbolEditor)SymbolEditor.this.getCmbType().getSelectedItem();
                    if (SymbolEditor.this.layerManager != null) {
                        ISymbol l = SymbolEditor.this.layerManager.getSelectedLayer();
                        if (l != null && options.canManageSymbol(l)) {
                            if (l instanceof CartographicSupport) {
                                CartographicSupport cs = (CartographicSupport)l;
                                SymbolEditor.this.getCmbUnits().setSelectedUnitIndex(cs.getUnit());
                                SymbolEditor.this.getCmbUnitsReferenceSystem().setSelectedIndex(cs.getReferenceSystem());
                            }
                            options.refreshControls(l);
                        }
                        SymbolEditor.this.replaceOptions(options);
                        options.refreshControls(l);
                    } else {
                        SymbolEditor.this.replaceOptions(options);
                    }
                }
            }
        };
        Comparator tabComparator = (o1, o2) -> {
            AbstractTypeSymbolEditor pnl1 = (AbstractTypeSymbolEditor)o1;
            AbstractTypeSymbolEditor pnl2 = (AbstractTypeSymbolEditor)o2;
            int result = pnl1.getName().compareTo(pnl2.getName());
            return result;
        };
        TreeSet<AbstractTypeSymbolEditor> set = new TreeSet<AbstractTypeSymbolEditor>(tabComparator);
        List<Class<? extends TypeSymbolEditor>> editors = symbologySwingManager.getSymbolEditorClassesByGeometryType(this.shapeType);
        Class[] constrLocator = new Class[]{SymbolEditor.class};
        Object[] constrInitargs = new Object[]{this};
        for (int i = 0; i < editors.size(); ++i) {
            Class<? extends TypeSymbolEditor> editorClass = editors.get(i);
            try {
                Constructor<? extends TypeSymbolEditor> c = editorClass.getConstructor(constrLocator);
                AbstractTypeSymbolEditor instance = (AbstractTypeSymbolEditor)c.newInstance(constrInitargs);
                instance.setFeatureStore(this.featureStore);
                set.add(instance);
                continue;
            }
            catch (Exception e) {
                NotificationManager.addError((String)(Messages.getText((String)"failed_installing_symbol_editor") + " " + editorClass.getName()), (Throwable)e);
            }
        }
        this.tabs = set.toArray(new AbstractTypeSymbolEditor[0]);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPnlWest(), "West");
        this.add((Component)this.getPnlCenter(), "Center");
        this.add((Component)this.getOkCancelPanel(), "South");
        this.cmbTypeActionListener.actionPerformed(null);
        this.refresh();
    }

    private AbstractTypeSymbolEditor getOptionsForSymbol(ISymbol sym) {
        if (sym == null) {
            return this.tabs[0];
        }
        for (AbstractTypeSymbolEditor tab : this.tabs) {
            if (!tab.canManageSymbol(sym)) continue;
            return tab;
        }
        return this.tabs[0];
    }

    private AcceptCancelPanel getOkCancelPanel() {
        if (this.okCancelPanel == null) {
            ActionListener action = e -> {
                if ("CANCEL".equals(e.getActionCommand())) {
                    this.symbol = this.oldSymbol;
                }
                PluginServices.getMDIManager().closeWindow((IWindow)this);
            };
            this.okCancelPanel = new AcceptCancelPanel(action, action);
        }
        return this.okCancelPanel;
    }

    public WindowInfo getWindowInfo() {
        if (this.wi == null) {
            this.wi = new WindowInfo(9);
            this.wi.setWidth(750);
            this.wi.setHeight(500);
            this.wi.setTitle(Messages.getText((String)"symbol_property_editor"));
        }
        return this.wi;
    }

    public ISymbol getSymbol() {
        if (this.symbol instanceof CartographicSupport) {
            CartographicSupport cs = (CartographicSupport)this.symbol;
            cs.setUnit(this.getUnit());
            cs.setReferenceSystem(this.getReferenceSystem());
        }
        return this.symbol;
    }

    private JPanel getPnlWest() {
        if (this.pnlWest == null) {
            this.pnlWest = new JPanel();
            this.pnlWest.setLayout(new BorderLayout());
            this.pnlWest.add((Component)this.getPnlPreview(), "North");
            if (this.symbol instanceof IMultiLayerSymbol) {
                this.pnlWest.add((Component)this.getPnlLayers(), "South");
            }
        }
        return this.pnlWest;
    }

    private JPanel getPnlCenter() {
        if (this.pnlCenter == null) {
            this.pnlCenter = new JPanel(new BorderLayout());
            this.pnlCenter.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"properties")));
            this.pnlCenter.add((Component)this.getPnlTypeAndUnits(), "North");
        }
        return this.pnlCenter;
    }

    private JPanel getPnlPreview() {
        if (this.pnlPreview == null) {
            this.pnlPreview = new JPanel(new FlowLayout(1, 5, 5));
            this.pnlPreview.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"preview")));
            this.pnlPreview.add(this.getSymbolPreviewer());
        }
        return this.pnlPreview;
    }

    private JPanel getPnlLayers() {
        if (this.pnlLayers == null) {
            this.pnlLayers = new JPanel(new FlowLayout(1, 5, 5));
            this.pnlLayers.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"layers")));
            this.pnlLayers.add(this.getLayerManager());
        }
        return this.pnlLayers;
    }

    private SymbolLayerManager getLayerManager() {
        if (this.layerManager == null) {
            this.layerManager = new SymbolLayerManager(this);
        }
        return this.layerManager;
    }

    private SymbolPreviewer getSymbolPreviewer() {
        if (this.symbolPreview == null) {
            this.symbolPreview = new SymbolPreviewer(this.getSampleFeature());
            this.symbolPreview.setPreferredSize(new Dimension(150, 100));
        }
        return this.symbolPreview;
    }

    private JPanel getPnlTypeAndUnits() {
        if (this.pnlTypeAndUnits == null) {
            this.pnlTypeAndUnits = new JPanel();
            this.pnlTypeAndUnits.setLayout(new BorderLayout());
            JPanel aux = new JPanel(new FlowLayout(3));
            aux.add(new JLabel(Messages.getText((String)"type")));
            aux.add(this.getCmbType());
            this.pnlTypeAndUnits.add((Component)aux, "West");
            aux = new JPanel(new FlowLayout(3));
            aux.add(new JLabel(Messages.getText((String)"units")));
            aux.add((Component)this.getCmbUnits());
            aux.add(this.getCmbUnitsReferenceSystem());
            this.pnlTypeAndUnits.add((Component)aux, "East");
        }
        return this.pnlTypeAndUnits;
    }

    private JComboBoxUnitsReferenceSystem getCmbUnitsReferenceSystem() {
        if (this.cmbUnitsReferenceSystem == null) {
            this.cmbUnitsReferenceSystem = new JComboBoxUnitsReferenceSystem();
        }
        return this.cmbUnitsReferenceSystem;
    }

    private JComboBoxUnits getCmbUnits() {
        if (this.cmbUnits == null) {
            this.cmbUnits = new JComboBoxUnits();
        }
        return this.cmbUnits;
    }

    public int getUnit() {
        return this.getCmbUnits().getSelectedUnitIndex();
    }

    public int getReferenceSystem() {
        return this.getCmbUnitsReferenceSystem().getSelectedIndex();
    }

    private JComboBox getCmbType() {
        if (this.cmbType == null) {
            this.cmbType = new JComboBox<AbstractTypeSymbolEditor>(this.tabs);
            this.cmbType.addActionListener(this.cmbTypeActionListener);
        }
        return this.cmbType;
    }

    protected void setLayerToSymbol(ISymbol layer) {
        int i = this.getLayerManager().getSelectedLayerIndex();
        IMultiLayerSymbol s = (IMultiLayerSymbol)this.symbol;
        if (i >= 0 && i < s.getLayerCount()) {
            s.setLayer(s.getLayerCount() - 1 - i, layer);
        }
        this.refresh();
    }

    public void refresh() {
        this.getSymbolPreviewer().setSymbol(this.symbol);
        this.doLayout();
        this.repaint();
    }

    public int getShapeType() {
        return this.shapeType.getType();
    }

    public ISymbol getNewLayer() {
        ISymbol sym = ((AbstractTypeSymbolEditor)this.getCmbType().getSelectedItem()).getLayer();
        return sym;
    }

    private void replaceOptions(AbstractTypeSymbolEditor options) {
        if (!this.replacing) {
            this.replacing = true;
            if (this.tabbedPane != null) {
                this.getPnlCenter().remove(this.tabbedPane);
            }
            JPanel[] theTabs = options.getTabs();
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setPreferredSize(new Dimension(300, 300));
            for (JPanel theTab : theTabs) {
                this.tabbedPane.addTab(theTab.getName(), theTab);
            }
            this.getPnlCenter().add((Component)this.tabbedPane, "Center");
            this.getPnlCenter().doLayout();
            this.replacing = false;
        }
    }

    public void setOptionsPageFor(ISymbol symbol) {
        AbstractTypeSymbolEditor options = this.getOptionsForSymbol(symbol);
        options.refreshControls(symbol);
        this.getCmbType().setSelectedItem(options);
    }

    public int getUnitsReferenceSystem() {
        return this.cmbUnitsReferenceSystem.getSelectedIndex();
    }

    public static void addSymbolEditorPanel(Class<? extends TypeSymbolEditor> symbolEditor, int shapeType) {
        SymbologySwingManager manager = SymbologySwingLocator.getSwingManager();
        manager.registerSymbolEditor(symbolEditor, shapeType);
    }

    private static List getSymbolsByType(GeometryType geometryType) {
        SymbologySwingManager manager = SymbologySwingLocator.getSwingManager();
        return manager.getSymbolEditorClassesByGeometryType(geometryType);
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    public void setFeatureStore(FeatureStore store) {
        this.featureStore = store;
        if (this.featureStore != null) {
            this.sampleFeature.setValue((Object)this.featureStore.getSampleFeature());
            for (AbstractTypeSymbolEditor editor : this.tabs) {
                editor.setFeatureStore(this.featureStore);
            }
        }
    }

    public MutableObject<Feature> getSampleFeature() {
        if (this.sampleFeature == null) {
            this.sampleFeature = new MutableObject();
            if (this.featureStore != null) {
                this.sampleFeature.setValue((Object)this.featureStore.getSampleFeature());
            }
        }
        return this.sampleFeature;
    }
}

