/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.styling.SymbolEditor;
import org.gvsig.app.gui.styling.SymbolPreviewer;
import org.gvsig.app.gui.styling.SymbolSelector;
import org.gvsig.app.project.documents.view.legend.gui.ISymbolSelector;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.beans.swing.JButton;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;

public class SymbolLayerManager
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -1939951243066481691L;
    private static final Dimension LIST_CELL_SIZE = new Dimension(150, 37);
    private SymbolEditor owner;
    private JList jListLayers;
    private ISymbol activeLayer;
    private IMultiLayerSymbol symbol;
    private JButton btnAddLayer = null;
    private JPanel pnlButtons = null;
    private JButton btnRemoveLayer = null;
    private JButton btnMoveUpLayer = null;
    private JButton btnMoveDownLayer = null;
    private final Dimension btnDimension = new Dimension(24, 24);
    private JScrollPane scroll;
    private Color cellSelectedBGColor = Color.BLUE;

    public SymbolLayerManager(SymbolEditor owner) {
        this.owner = owner;
        this.symbol = (IMultiLayerSymbol)owner.getSymbol();
        if (this.symbol.getLayerCount() == 0) {
            int shapeType = -1;
            if (this.symbol instanceof IMarkerSymbol) {
                shapeType = 1;
            } else if (this.symbol instanceof ILineSymbol) {
                shapeType = 2;
            } else if (this.symbol instanceof IFillSymbol) {
                shapeType = 3;
            }
            if (shapeType != -1) {
                this.symbol.addLayer(MapContextLocator.getSymbolManager().createSymbol(shapeType));
            }
        }
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJScrollPane(), "Center");
        this.add((Component)this.getPnlButtons(), "South");
        this.getJListLayers().setSelectedIndex(0);
    }

    private JScrollPane getJScrollPane() {
        if (this.scroll == null) {
            this.scroll = new JScrollPane();
            this.scroll.setPreferredSize(new Dimension(150, 160));
            this.scroll.setViewportView(this.getJListLayers());
        }
        return this.scroll;
    }

    private JList getJListLayers() {
        if (this.jListLayers == null) {
            this.jListLayers = new JList();
            this.jListLayers.setSelectionMode(0);
            this.jListLayers.setLayoutOrientation(2);
            this.jListLayers.setVisibleRowCount(-1);
            this.jListLayers.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SymbolLayerManager.this.setLayer((ISymbol)SymbolLayerManager.this.jListLayers.getSelectedValue());
                }
            });
            this.jListLayers.setModel(new SymbolLayerListModel());
            this.jListLayers.setCellRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = -2551357351239544039L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    return new SymbolLayerComponent((ISymbol)value, index, isSelected);
                }
            });
            this.jListLayers.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        ISymbolSelector symSel = SymbolSelector.createSymbolSelector(SymbolLayerManager.this.activeLayer, SymbolLayerManager.this.owner.getShapeType());
                        PluginServices.getMDIManager().addWindow((IWindow)symSel);
                        ISymbol new_sym = (ISymbol)symSel.getSelectedObject();
                        SymbolLayerManager.this.updateSymbol(new_sym);
                        SymbolLayerManager.this.setLayer(new_sym);
                    }
                }
            });
        }
        return this.jListLayers;
    }

    private void updateSymbol(ISymbol layer) {
        if (layer != null) {
            JList layers = this.getJListLayers();
            int index = layers.getSelectedIndex();
            int size = layers.getModel().getSize();
            this.symbol.setLayer(size - index - 1, layer);
            this.owner.refresh();
            this.validate();
        }
    }

    private void setLayer(ISymbol symbol) {
        if (symbol != null) {
            this.activeLayer = symbol;
            this.owner.setOptionsPageFor(symbol);
        }
    }

    private JButton getBtnAddLayer() {
        if (this.btnAddLayer == null) {
            this.btnAddLayer = new JButton((Icon)PluginServices.getIconTheme().get("symbol-layer-add"));
            this.btnAddLayer.setActionCommand("ADD");
            this.btnAddLayer.setSize(this.btnDimension);
            this.btnAddLayer.setPreferredSize(this.btnDimension);
            this.btnAddLayer.addActionListener((ActionListener)this);
        }
        return this.btnAddLayer;
    }

    private JPanel getPnlButtons() {
        if (this.pnlButtons == null) {
            this.pnlButtons = new JPanel();
            this.pnlButtons.add((Component)this.getBtnAddLayer(), null);
            this.pnlButtons.add((Component)this.getBtnRemoveLayer(), null);
            this.pnlButtons.add((Component)this.getBtnMoveUpLayer(), null);
            this.pnlButtons.add((Component)this.getBtnMoveDown(), null);
        }
        return this.pnlButtons;
    }

    private JButton getBtnRemoveLayer() {
        if (this.btnRemoveLayer == null) {
            this.btnRemoveLayer = new JButton((Icon)PluginServices.getIconTheme().get("symbol-layer-remove"));
            this.btnRemoveLayer.setActionCommand("REMOVE");
            this.btnRemoveLayer.setSize(this.btnDimension);
            this.btnRemoveLayer.setPreferredSize(this.btnDimension);
            this.btnRemoveLayer.addActionListener((ActionListener)this);
        }
        return this.btnRemoveLayer;
    }

    private JButton getBtnMoveUpLayer() {
        if (this.btnMoveUpLayer == null) {
            this.btnMoveUpLayer = new JButton((Icon)PluginServices.getIconTheme().get("symbol-layer-move-up"));
            this.btnMoveUpLayer.setActionCommand("MOVE_UP");
            this.btnMoveUpLayer.setSize(this.btnDimension);
            this.btnMoveUpLayer.setPreferredSize(this.btnDimension);
            this.btnMoveUpLayer.addActionListener((ActionListener)this);
        }
        return this.btnMoveUpLayer;
    }

    private JButton getBtnMoveDown() {
        if (this.btnMoveDownLayer == null) {
            this.btnMoveDownLayer = new JButton((Icon)PluginServices.getIconTheme().get("symbol-layer-move-down"));
            this.btnMoveDownLayer.setActionCommand("MOVE_DOWN");
            this.btnMoveDownLayer.setSize(this.btnDimension);
            this.btnMoveDownLayer.setPreferredSize(this.btnDimension);
            this.btnMoveDownLayer.addActionListener((ActionListener)this);
        }
        return this.btnMoveDownLayer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        int jlistIndex = this.getJListLayers().getSelectedIndex();
        int index = this.symbol.getLayerCount() - 1 - jlistIndex;
        if (command.equals("ADD")) {
            this.symbol.addLayer(this.owner.getNewLayer());
            index = this.symbol.getLayerCount();
        } else if (command.equals("REMOVE")) {
            int layerCount = this.symbol.getLayerCount();
            if (layerCount > 1 && index < layerCount) {
                this.symbol.removeLayer(this.symbol.getLayer(index));
            }
        } else if (command.equals("MOVE_UP")) {
            if (index < this.symbol.getLayerCount() - 1) {
                this.symbol.swapLayers(index, index + 1);
                --jlistIndex;
            }
        } else if (command.equals("MOVE_DOWN")) {
            if (index > 0) {
                this.symbol.swapLayers(index, index - 1);
                ++jlistIndex;
            }
        } else if (command.equals("LOCK")) {
            // empty if block
        }
        this.owner.refresh();
        this.validate();
        this.getJListLayers().setSelectedIndex(jlistIndex);
    }

    public ISymbol getSelectedLayer() {
        return (ISymbol)this.getJListLayers().getSelectedValue();
    }

    public int getSelectedLayerIndex() {
        return this.getJListLayers().getSelectedIndex();
    }

    @Override
    public void validate() {
        this.jListLayers = null;
        this.getJScrollPane().setViewportView(this.getJListLayers());
        super.validate();
    }

    private class SymbolLayerComponent
    extends JPanel {
        private static final long serialVersionUID = -3706313315505454031L;

        public SymbolLayerComponent(ISymbol sym, int index, boolean isSelected) {
            FlowLayout layout = new FlowLayout(0, 3, 3);
            this.setLayout(layout);
            Color bgColor = isSelected ? SymbolLayerManager.this.cellSelectedBGColor : Color.WHITE;
            this.setBackground(bgColor);
            JCheckBox chkVisible = new JCheckBox("", false);
            ISymbol symbolLayer = SymbolLayerManager.this.symbol.getLayer(index);
            if (symbolLayer != null) {
                chkVisible.setSelected(symbolLayer.isShapeVisible());
            }
            chkVisible.setBackground(bgColor);
            this.add(chkVisible);
            SymbolPreviewer sp = new SymbolPreviewer(SymbolLayerManager.this.owner.getSampleFeature());
            sp.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            sp.setAlignmentX(0.0f);
            sp.setPreferredSize(new Dimension(80, 30));
            sp.setSize(new Dimension(80, 30));
            sp.setSymbol(sym);
            sp.setBackground(Color.WHITE);
            this.add(sp);
            JButton btnLock = new JButton((Icon)IconThemeHelper.getImageIcon((String)"symbol-layer-unlock"));
            btnLock.setSize(SymbolLayerManager.this.btnDimension);
            btnLock.setPreferredSize(SymbolLayerManager.this.btnDimension);
            btnLock.setActionCommand("LOCK");
            btnLock.setBackground(bgColor);
            btnLock.setAlignmentX(0.5f);
            this.add((Component)btnLock);
            this.setPreferredSize(LIST_CELL_SIZE);
        }
    }

    private class SymbolLayerListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 4197818146836802855L;
        private ArrayList listeners = new ArrayList();

        private SymbolLayerListModel() {
        }

        @Override
        public int getSize() {
            return SymbolLayerManager.this.symbol.getLayerCount();
        }

        @Override
        public Object getElementAt(int index) {
            return SymbolLayerManager.this.symbol.getLayer(SymbolLayerManager.this.symbol.getLayerCount() - 1 - index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }
    }
}

