/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.gui.styling.SymbolPreviewer;
import org.gvsig.app.project.documents.gui.TableSymbolCellRenderer;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.legend.ZSort;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.gui.beans.AcceptCancelPanel;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.gui.beans.swing.celleditors.BooleanTableCellEditor;
import org.gvsig.gui.beans.swing.celleditors.IntegerTableCellEditor;
import org.gvsig.gui.beans.swing.cellrenderers.BooleanTableCellRenderer;
import org.gvsig.gui.beans.swing.cellrenderers.NumberTableCellRenderer;
import org.gvsig.i18n.Messages;

public final class SymbolLevelsWindow
extends JPanel
implements IWindow,
ActionListener {
    private static final long serialVersionUID = 3241898997869313055L;
    private static final int DESCRIPTION_COLUMN_INDEX = 1;
    private static final int SYMBOL_COLUMN_INDEX = 0;
    private static final int MERGE_COLUMN_INDEX = 3;
    private static final int JOIN_COLUMN_INDEX = 2;
    private static final int FIRST_LEVEL_COLUMN_INDEX = 2;
    private static final String[] defaultHeaders = new String[]{Messages.getText((String)"symbol"), Messages.getText((String)"description"), Messages.getText((String)"join"), Messages.getText((String)"merge")};
    private static final int DEFAULT_VIEW = 0;
    private static final int ADVANCED_VIEW = 1;
    private static int viewMode = 1;
    private JCheckBox chkSpecifyDrawOrder = null;
    private JPanel pnlNorth;
    private JPanel pnlCenter = null;
    private JScrollPane srclLevels = null;
    private JTable tblLevels = null;
    private JButton btnUp = null;
    private JButton btnDown;
    private JPanel pnlSouth = null;
    private String[] advancedHeaders;
    private JButton btnSwitchView;
    private ZSort zSort;
    private final SymbolSummary summary = new SymbolSummary();
    private final ActionListener action = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if ("OK".equals(actionCommand)) {
                SymbolLevelsWindow.this.tblLevels.editingStopped(new ChangeEvent(SymbolLevelsWindow.this.tblLevels));
                SymbolLevelsWindow.this.applyValues();
            }
            PluginServices.getMDIManager().closeWindow((IWindow)SymbolLevelsWindow.this);
        }
    };

    public SymbolLevelsWindow(ZSort zSort) {
        this.initialize();
        this.setModel(zSort);
        this.quitaEsteMetodo();
        this.tblLevels.setRowHeight(23);
    }

    private void quitaEsteMetodo() {
        this.getBtnSwitchView().setEnabled(false);
        this.getBtnDown().setEnabled(false);
        this.getBtnUp().setEnabled(false);
    }

    public WindowInfo getWindowInfo() {
        WindowInfo wi = new WindowInfo(9);
        wi.setTitle(Messages.getText((String)"symbol_levels"));
        wi.setWidth(this.getWidth() + 10);
        wi.setHeight(this.getHeight());
        return wi;
    }

    private void applyValues() {
        TableModel model = this.tblLevels.getModel();
        HashMap<ISymbol, int[]> aTable = new HashMap<ISymbol, int[]>();
        ISymbol[] symbols = new ISymbol[model.getRowCount()];
        for (int i = 0; i < symbols.length; ++i) {
            symbols[i] = (ISymbol)model.getValueAt(i, 0);
            int length = 1;
            if (symbols[i] instanceof IMultiLayerSymbol) {
                IMultiLayerSymbol mlSym = (IMultiLayerSymbol)symbols[i];
                length = mlSym.getLayerCount();
            }
            int[] symbolLevels = new int[length];
            if (viewMode == 0) {
                if (symbols[i] instanceof IMultiLayerSymbol) {
                    int j;
                    boolean join = (Boolean)model.getValueAt(i, 2);
                    boolean merge = (Boolean)model.getValueAt(i, 3);
                    boolean needToJoin = true;
                    if (merge && i > 0) {
                        try {
                            int[] prevSymbolLevels = (int[])aTable.get(symbols[i - 1]);
                            for (j = 0; j < symbolLevels.length; ++j) {
                                symbolLevels[j] = prevSymbolLevels[j];
                            }
                        }
                        catch (IndexOutOfBoundsException ex) {
                            for (j = 0; j < symbolLevels.length; ++j) {
                                symbolLevels[j] = symbolLevels[j - 1] + 1;
                            }
                        }
                        needToJoin = false;
                    }
                    if (join && needToJoin) {
                        for (j = 0; j < symbolLevels.length; ++j) {
                            symbolLevels[j] = this.zSort.getLevelCount() + j + 1;
                        }
                    }
                    if (!join && !merge) {
                        for (j = 0; j < symbolLevels.length; ++j) {
                            symbolLevels[j] = this.zSort.getLevelCount();
                        }
                    }
                } else {
                    symbolLevels[0] = this.zSort.getLevelCount();
                }
            } else {
                for (int j = 0; j < symbolLevels.length; ++j) {
                    symbolLevels[j] = (Integer)model.getValueAt(i, j + 2);
                }
            }
            aTable.put(symbols[i], symbolLevels);
        }
        for (ISymbol sym : aTable.keySet()) {
            this.zSort.setLevels(sym, (int[])aTable.get(sym));
        }
        this.zSort.setUsingZSort(this.getChkSpecifyDrawOrder().isSelected());
    }

    public void setModel(ZSort plan) {
        this.advancedHeaders = new String[2 + plan.getTopLevelIndexAllowed()];
        this.advancedHeaders[0] = defaultHeaders[0];
        this.advancedHeaders[1] = defaultHeaders[1];
        if (this.advancedHeaders.length == 3) {
            this.advancedHeaders[2] = Messages.getText((String)"level");
        } else {
            for (int i = 2; i < this.advancedHeaders.length; ++i) {
                this.advancedHeaders[i] = StringUtils.replace((String)Messages.getText((String)"symbol_level"), (String)"%(level)", (String)String.valueOf(i - 1));
            }
        }
        this.zSort = plan;
        this.getChkSpecifyDrawOrder().setSelected(plan.isUsingZSort());
        this.initTableContents(this.getTblLevels(), plan, viewMode);
    }

    private void initTableContents(JTable table, ZSort zSort, int mode) {
        DefaultTableModel model = new DefaultTableModel();
        ISymbol[] syms = zSort.getSymbols();
        String[] labels = zSort.getDescriptions();
        if (mode == 0) {
            Object[][] dataVector = new Object[syms.length][syms.length];
            for (int i = 0; i < syms.length; ++i) {
                dataVector[i] = new Object[defaultHeaders.length];
                dataVector[i][0] = syms[i];
                dataVector[i][1] = labels[i];
                if (!(syms[i] instanceof IMultiLayerSymbol)) continue;
                boolean joined = true;
                int[] levels = zSort.getLevels(syms[i]);
                if (levels != null) {
                    for (int j = 0; j < levels.length; ++j) {
                        if (!joined) continue;
                        joined = levels[j] != levels[j + 1];
                    }
                }
                boolean merged = true;
                if (i < syms.length - 1) {
                    for (int j = 0; joined && j < levels.length; ++j) {
                        ISymbol nextSymbol = syms[i + 1];
                        int[] nextLevels = zSort.getLevels(nextSymbol);
                        if (nextLevels == null) continue;
                        if (nextSymbol instanceof IMultiLayerSymbol) {
                            if (j >= nextLevels.length) continue;
                            merged = levels[j] == nextLevels[j];
                            continue;
                        }
                        merged = levels[0] == nextLevels[0];
                    }
                    if (!merged) break;
                }
                if (!joined) {
                    merged = false;
                }
                dataVector[i][2] = joined;
                dataVector[i][3] = merged;
            }
            model.setDataVector(dataVector, defaultHeaders);
            table.setModel(model);
            TableColumn col = table.getColumnModel().getColumn(2);
            col.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer(true));
            col.setCellEditor((TableCellEditor)new BooleanTableCellEditor(table));
            col = table.getColumnModel().getColumn(3);
            col.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer(true));
            col.setCellEditor((TableCellEditor)new BooleanTableCellEditor(table));
        } else {
            Object[][] dataVector = new Object[syms.length][2 + zSort.getTopLevelIndexAllowed() + 1];
            for (int i = 0; i < syms.length; ++i) {
                dataVector[i][0] = syms[i];
                dataVector[i][1] = labels[i];
                if (syms[i] instanceof IMultiLayerSymbol) {
                    int[] levels = zSort.getLevels(syms[i]);
                    for (int j = 0; j < levels.length; ++j) {
                        dataVector[i][j + 2] = levels[j];
                    }
                    continue;
                }
                dataVector[i][2] = zSort.getLevels(syms[i])[0];
            }
            model.setDataVector(dataVector, this.advancedHeaders);
            table.setModel(model);
            for (int j = 2; j < model.getColumnCount(); ++j) {
                table.getColumnModel().getColumn(j).setCellRenderer((TableCellRenderer)new NumberTableCellRenderer(true, false));
                table.getColumnModel().getColumn(j).setCellEditor((TableCellEditor)new IntegerTableCellEditor());
            }
        }
        TableSymbolCellRenderer symbolCellRenderer = new TableSymbolCellRenderer(true){
            private static final long serialVersionUID = 5603529641148869112L;
            {
                this.preview = new SymbolPreviewer(null){
                    private static final long serialVersionUID = 7262380340075167043L;
                    private final Icon downIcon;
                    {
                        this.downIcon = new Icon(){

                            @Override
                            public int getIconHeight() {
                                return 7;
                            }

                            @Override
                            public int getIconWidth() {
                                return 7;
                            }

                            @Override
                            public void paintIcon(Component c, Graphics g, int x, int y) {
                                Graphics2D g2 = (Graphics2D)g;
                                g2.setColor(Color.GRAY);
                                g2.translate(x + c.getWidth() - this.getIconWidth() * 2, y + c.getHeight() - this.getIconHeight() * 2);
                                GeneralPath gp = new GeneralPath();
                                gp.moveTo(0.0f, 0.0f);
                                gp.lineTo(this.getIconWidth() / 2, this.getIconHeight() - 1);
                                gp.lineTo(this.getIconWidth() - 1, 0.0f);
                                g2.fill(gp);
                                g2.translate(-(x + c.getWidth() - this.getIconWidth() * 2), -(y + c.getHeight() - this.getIconHeight() * 2));
                            }
                        };
                    }

                    @Override
                    public void paint(Graphics g) {
                        super.paint(g);
                        if (this.getSymbol() instanceof IMultiLayerSymbol) {
                            this.downIcon.paintIcon(this, g, 0, 0);
                        }
                    }
                };
            }
        };
        TableColumn col = table.getColumnModel().getColumn(0);
        col.setCellRenderer(symbolCellRenderer);
    }

    private void initialize() {
        this.setLayout(new BorderLayout(15, 15));
        this.setSize(564, 344);
        this.add((Component)this.getNorthPanel(), "North");
        this.add((Component)this.getPnlCenter(), "Center");
        this.add((Component)this.getPnlSouth(), "South");
        this.tblLevels.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ((SymbolLevelsWindow)SymbolLevelsWindow.this).summary.sym = null;
                SymbolLevelsWindow.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point where = e.getPoint();
                int whereX = where.x;
                int whereY = where.y;
                Rectangle bounds = SymbolLevelsWindow.this.tblLevels.getBounds();
                int rightEdge = 0;
                for (int i = 0; i <= 0; ++i) {
                    rightEdge += SymbolLevelsWindow.this.tblLevels.getColumnModel().getColumn(i).getWidth();
                }
                if (whereX >= bounds.x && whereX <= rightEdge + bounds.x && whereY >= bounds.y && whereY <= bounds.height + bounds.y) {
                    int rowHeight = SymbolLevelsWindow.this.tblLevels.getRowHeight();
                    int rowClicked = (whereY - bounds.y) / rowHeight;
                    ISymbol sym = (ISymbol)SymbolLevelsWindow.this.tblLevels.getModel().getValueAt(rowClicked, 0);
                    if (sym instanceof IMultiLayerSymbol) {
                        ((SymbolLevelsWindow)SymbolLevelsWindow.this).summary.sym = (IMultiLayerSymbol)sym;
                        ((SymbolLevelsWindow)SymbolLevelsWindow.this).summary.rowIndex = rowClicked;
                    } else {
                        ((SymbolLevelsWindow)SymbolLevelsWindow.this).summary.sym = null;
                    }
                    SymbolLevelsWindow.this.repaint();
                }
            }
        });
    }

    private JPanel getNorthPanel() {
        if (this.pnlNorth == null) {
            this.pnlNorth = new JPanel();
            this.pnlNorth.setLayout(new BorderLayout());
            this.pnlNorth.add((Component)new JBlank(15, 15), "North");
            this.pnlNorth.add((Component)this.getChkSpecifyDrawOrder(), "Center");
            this.pnlNorth.add((Component)new JBlank(15, 0), "West");
        }
        return this.pnlNorth;
    }

    private JCheckBox getChkSpecifyDrawOrder() {
        if (this.chkSpecifyDrawOrder == null) {
            this.chkSpecifyDrawOrder = new JCheckBox("<html><b>" + Messages.getText((String)"draw_symbols_in_specified_order") + "</b></html>");
            this.chkSpecifyDrawOrder.addActionListener(this);
        }
        return this.chkSpecifyDrawOrder;
    }

    private JPanel getPnlCenter() {
        if (this.pnlCenter == null) {
            this.pnlCenter = new JPanel();
            this.pnlCenter.setLayout(new BorderLayout(0, 15));
            this.pnlCenter.add((Component)this.getSrclLevels(), "Center");
            this.pnlCenter.setBorder(BorderFactory.createEtchedBorder(1));
        }
        this.pnlCenter.setEnabled(this.getChkSpecifyDrawOrder().isSelected());
        return this.pnlCenter;
    }

    private JScrollPane getSrclLevels() {
        if (this.srclLevels == null) {
            this.srclLevels = new JScrollPane();
            this.srclLevels.setViewportView(this.getTblLevels());
        }
        this.srclLevels.setEnabled(this.getChkSpecifyDrawOrder().isSelected());
        return this.srclLevels;
    }

    private JTable getTblLevels() {
        if (this.tblLevels == null) {
            this.tblLevels = new JTable(){
                private static final long serialVersionUID = -1545710722048183232L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    SymbolLevelsWindow.this.summary.paint((Graphics2D)g);
                }
            };
            this.summary.rowHeight = this.tblLevels.getRowHeight();
        }
        this.tblLevels.setEnabled(this.getChkSpecifyDrawOrder().isSelected());
        return this.tblLevels;
    }

    private JButton getBtnUp() {
        if (this.btnUp == null) {
            this.btnUp = new JButton(PluginServices.getIconTheme().get("arrow-up-icono"));
            this.btnUp.setActionCommand("MOVE_UP");
        }
        return this.btnUp;
    }

    private JButton getBtnDown() {
        if (this.btnDown == null) {
            this.btnDown = new JButton(PluginServices.getIconTheme().get("arrow-down-icono"));
            this.btnDown.setActionCommand("MOVE_DOWN");
        }
        return this.btnDown;
    }

    private JPanel getPnlSouth() {
        if (this.pnlSouth == null) {
            this.pnlSouth = new JPanel(new BorderLayout());
            JPanel aux = new JPanel();
            aux.setLayout(new FlowLayout(2));
            this.pnlSouth.add((Component)new AcceptCancelPanel(this.action, this.action));
        }
        return this.pnlSouth;
    }

    private JButton getBtnSwitchView() {
        if (this.btnSwitchView == null) {
            this.btnSwitchView = new JButton(viewMode != 0 ? Messages.getText((String)"default_view") : Messages.getText((String)"advanced_view"));
            this.btnSwitchView.addActionListener(this);
            this.btnSwitchView.setVisible(false);
        }
        return this.btnSwitchView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent c = (JComponent)e.getSource();
        if (c.equals(this.getChkSpecifyDrawOrder())) {
            this.getPnlCenter().setEnabled(this.getChkSpecifyDrawOrder().isSelected());
            this.getSrclLevels().setEnabled(this.getChkSpecifyDrawOrder().isSelected());
            TableCellEditor tce = this.getTblLevels().getCellEditor();
            if (tce != null) {
                tce.stopCellEditing();
            }
            this.getTblLevels().setEnabled(this.getChkSpecifyDrawOrder().isSelected());
        } else if (c.equals(this.getBtnSwitchView())) {
            viewMode = viewMode == 1 ? 0 : 1;
            this.initTableContents(this.getTblLevels(), this.zSort, viewMode);
            this.btnSwitchView.setText(viewMode != 0 ? Messages.getText((String)"default_view") : Messages.getText((String)"advanced_view"));
        }
    }

    public ZSort getZSort() {
        return this.zSort;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    private class SymbolSummary {
        int witdh;
        int rowHeight = 10;
        int rowIndex;
        IMultiLayerSymbol sym;

        private SymbolSummary() {
        }

        void paint(Graphics2D g) {
            if (this.sym != null) {
                int whereY = this.rowHeight * (this.rowIndex - 1) + (int)((double)this.rowHeight / 0.6);
                int whereX = 0;
                for (int i = 0; i <= 0; ++i) {
                    whereX += SymbolLevelsWindow.this.tblLevels.getColumnModel().getColumn(i).getWidth();
                }
                int width = 150;
                int height = Math.max(this.rowHeight * this.sym.getLayerCount(), this.rowHeight);
                Rectangle bounds = new Rectangle(whereX -= 40, whereY, width, height);
                g.setColor(new Color(255, 255, 220));
                g.fill(bounds);
                g.setColor(new Color(255, 230, 20));
                g.draw(bounds);
                g.setFont(new Font("Arial", 1, 10));
                for (int i = 0; i < this.sym.getLayerCount(); ++i) {
                    g.setColor(Color.black);
                    g.drawString(i + 1 + ":", whereX + 5, height + whereY - (i * this.rowHeight + 5));
                    Rectangle rect = new Rectangle(whereX + 20, height + whereY - (i + 1) * this.rowHeight + 3, width - 20, this.rowHeight - 6);
                    try {
                        this.sym.getLayer(i).drawInsideRectangle(g, null, rect);
                        continue;
                    }
                    catch (SymbolDrawingException e) {
                        if (e.getType() == 0) {
                            try {
                                MapContextLocator.getSymbolManager().getWarningSymbol(SymbolDrawingException.STR_UNSUPPORTED_SET_OF_SETTINGS, "", 0).drawInsideRectangle(g, null, rect);
                            }
                            catch (SymbolDrawingException symbolDrawingException) {}
                            continue;
                        }
                        throw new Error(Messages.getText((String)"symbol_shapetype_mismatch"));
                    }
                }
            }
        }
    }
}

