/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.z3950.server;

import java.io.IOException;
import java.math.BigInteger;
import java.net.Socket;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jzkit.a2j.codec.util.OIDRegister;
import org.jzkit.a2j.codec.util.OIDRegisterEntry;
import org.jzkit.a2j.gen.AsnUseful.EXTERNAL_type;
import org.jzkit.a2j.gen.AsnUseful.encoding_inline0_type;
import org.jzkit.search.util.RecordModel.ArchetypeRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.DOMTree;
import org.jzkit.search.util.RecordModel.DiagnosticFragment;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.HTMLRecord;
import org.jzkit.search.util.RecordModel.InformationFragment;
import org.jzkit.search.util.RecordModel.RecordFormatSpecification;
import org.jzkit.search.util.RecordModel.SGMLRecord;
import org.jzkit.search.util.RecordModel.SUTRS;
import org.jzkit.search.util.RecordModel.SurrogateDiagnostic;
import org.jzkit.search.util.RecordModel.TextFragment;
import org.jzkit.search.util.RecordModel.UnknownBlob;
import org.jzkit.search.util.RecordModel.XMLRecord;
import org.jzkit.search.util.RecordModel.iso2709;
import org.jzkit.z3950.RecordModel.Z3950RetrievalRecord;
import org.jzkit.z3950.gen.v3.NegotiationRecordDefinition_charSetandLanguageNegotiation_3.CharSetandLanguageNegotiation_type;
import org.jzkit.z3950.gen.v3.NegotiationRecordDefinition_charSetandLanguageNegotiation_3.Iso10646_type;
import org.jzkit.z3950.gen.v3.NegotiationRecordDefinition_charSetandLanguageNegotiation_3.OriginProposal_type;
import org.jzkit.z3950.gen.v3.NegotiationRecordDefinition_charSetandLanguageNegotiation_3.proposedCharSets_inline0_choice1_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DefaultDiagFormat_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DeleteResultSetRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DeleteResultSetResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ElementSetNames_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.InitializeRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.NamePlusRecord_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.OtherInformationItem43_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PDU_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PresentRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PresentResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Records_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ScanRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.SearchRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.SearchResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.addinfo_inline14_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.record_inline13_type;
import org.jzkit.z3950.server.BackendDeleteResult;
import org.jzkit.z3950.server.BackendPresentResult;
import org.jzkit.z3950.server.BackendSearchResult;
import org.jzkit.z3950.server.Z3950NonBlockingBackend;
import org.jzkit.z3950.util.APDUEvent;
import org.jzkit.z3950.util.GenericEventToTargetListenerAdapter;
import org.jzkit.z3950.util.TargetAPDUListener;
import org.jzkit.z3950.util.Z3950Constants;
import org.jzkit.z3950.util.ZTargetEndpoint;
import org.springframework.context.ApplicationContext;

public class ZServerAssociation
implements TargetAPDUListener {
    private Logger logger = Logger.getLogger((class$org$jzkit$z3950$server$ZServerAssociation == null ? (class$org$jzkit$z3950$server$ZServerAssociation = ZServerAssociation.class$("org.jzkit.z3950.server.ZServerAssociation")) : class$org$jzkit$z3950$server$ZServerAssociation).getName());
    private ZTargetEndpoint assoc = null;
    private OIDRegister reg = null;
    private int dbg_counter = 0;
    private GenericEventToTargetListenerAdapter event_adapter = null;
    private Z3950NonBlockingBackend backend;
    private ApplicationContext ctx = null;
    static /* synthetic */ Class class$org$jzkit$z3950$server$ZServerAssociation;

    public ZServerAssociation(Socket s, Z3950NonBlockingBackend backend, ApplicationContext ctx) {
        this.logger.fine("New ZServerAssociation" + this.dbg_counter++);
        this.backend = backend;
        this.reg = (OIDRegister)ctx.getBean("OIDRegister");
        this.assoc = new ZTargetEndpoint(s, this.reg);
        this.event_adapter = new GenericEventToTargetListenerAdapter(this);
        this.assoc.getPDUAnnouncer().addObserver(this.event_adapter);
        if (this.reg == null) {
            throw new RuntimeException("Unable to locate OID Register in Application Context");
        }
        this.assoc.start();
        this.logger.fine("New thread should have started");
    }

    protected void finalize() throws Throwable {
        --this.dbg_counter;
        this.logger.fine("ZServerAssociation::finalize() - " + this.dbg_counter + " remaining");
    }

    public void incomingInitRequest(APDUEvent e) {
        this.logger.fine("Incoming initRequest....");
        InitializeRequest_type init_request = (InitializeRequest_type)e.getPDU().o;
        for (int i = 0; i < Z3950Constants.z3950_option_names.length; ++i) {
            if (!init_request.options.isSet(i)) continue;
            this.logger.info("Origin requested service: " + Z3950Constants.z3950_option_names[i]);
        }
        if (init_request.options.isSet(7)) {
            // empty if block
        }
        if (init_request.userInformationField != null) {
            OIDRegisterEntry ent = this.reg.lookupByOID(init_request.userInformationField.direct_reference);
            if (ent != null) {
                this.logger.fine("Init Request contains userInformationField oid=" + ent.getName());
            } else {
                this.logger.fine("Unkown external in userInformationField");
            }
        }
        if (init_request.otherInfo != null) {
            this.logger.fine("Init Request contains otherInfo entries");
            Iterator other_info_enum = ((AbstractList)init_request.otherInfo).iterator();
            block6: while (other_info_enum.hasNext()) {
                this.logger.fine("Processing otherInfo entry...");
                OtherInformationItem43_type oit = (OtherInformationItem43_type)other_info_enum.next();
                this.logger.fine("Processing OtherInformationItem43_type");
                switch (oit.information.which) {
                    case 2: {
                        EXTERNAL_type et = (EXTERNAL_type)oit.information.o;
                        if (et.direct_reference == null) continue block6;
                        OIDRegisterEntry ent = this.reg.lookupByOID(et.direct_reference);
                        this.logger.fine("External with direct reference, oid=" + ent.getName());
                        if (!ent.getName().equals("z_charset_neg_3")) continue block6;
                        this.handleNLSNegotiation((CharSetandLanguageNegotiation_type)et.encoding.o);
                        break;
                    }
                    default: {
                        this.logger.fine("Currently unhandled OtherInformationType");
                    }
                }
            }
        }
        try {
            this.logger.fine("sendInitResponse");
            this.assoc.sendInitResponse(init_request.referenceId, init_request.protocolVersion, init_request.options, init_request.preferredMessageSize.longValue(), init_request.exceptionalRecordSize.longValue(), true, "174", "Knowledge Integration Ltd Generic Z Server", "2.0.1", null, null);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void handleNLSNegotiation(CharSetandLanguageNegotiation_type neg) {
        this.logger.fine("Handle Character Set and Language Negotiation");
        if (neg.which == 0) {
            OriginProposal_type op = (OriginProposal_type)neg.o;
            if (op.proposedCharSets != null) {
                Iterator prop_charsets = ((AbstractList)op.proposedCharSets).iterator();
                block3: while (prop_charsets.hasNext()) {
                    proposedCharSets_inline0_choice1_type c = (proposedCharSets_inline0_choice1_type)prop_charsets.next();
                    switch (c.which) {
                        case 1: {
                            Iso10646_type iso_type = (Iso10646_type)c.o;
                            OIDRegisterEntry ent = this.reg.lookupByOID(iso_type.encodingLevel);
                            this.logger.fine("Client proposes iso10646 charset: " + ent.getName());
                            continue block3;
                        }
                    }
                    this.logger.log(Level.SEVERE, "Unhandled character set encoding");
                }
            }
        }
    }

    public void incomingSearchRequest(APDUEvent e) {
        this.logger.fine("Processing incomingSearchRequest");
        SearchRequest_type search_request = (SearchRequest_type)e.getPDU().o;
        int ssub = search_request.smallSetUpperBound.intValue();
        int lslb = search_request.largeSetLowerBound.intValue();
        int mspn = search_request.mediumSetPresentNumber.intValue();
        String pref_recsyn = null;
        if (search_request.preferredRecordSyntax != null) {
            OIDRegisterEntry ent = this.reg.lookupByOID(search_request.preferredRecordSyntax);
            pref_recsyn = ent != null ? ent.getName() : null;
        }
        this.backend.search(new BackendSearchResult(this, search_request.query, search_request.databaseNames, pref_recsyn, this.extractSetname(search_request.smallSetElementSetNames), this.extractSetname(search_request.mediumSetElementSetNames), search_request.resultSetName != null ? search_request.resultSetName : "Default", search_request.replaceIndicator, search_request.referenceId));
    }

    public void notifySearchResult(BackendSearchResult bsr) {
        PDU_type pdu = new PDU_type();
        pdu.which = 3;
        SearchResponse_type response = new SearchResponse_type();
        pdu.o = response;
        response.searchStatus = bsr.search_status;
        response.resultCount = BigInteger.valueOf(bsr.result_count);
        if (bsr.refid != null) {
            response.referenceId = bsr.refid;
        }
        if (bsr.search_status) {
            if (bsr.piggyback_records != null) {
                response.presentStatus = BigInteger.valueOf(0L);
                response.numberOfRecordsReturned = BigInteger.valueOf(bsr.piggyback_records.length);
                response.nextResultSetPosition = BigInteger.valueOf(bsr.piggyback_records.length + 1);
            } else {
                response.presentStatus = BigInteger.valueOf(0L);
                response.numberOfRecordsReturned = BigInteger.valueOf(0L);
                response.nextResultSetPosition = BigInteger.valueOf(1L);
            }
        } else {
            response.presentStatus = BigInteger.valueOf(5L);
            response.numberOfRecordsReturned = BigInteger.valueOf(0L);
            response.nextResultSetPosition = BigInteger.valueOf(0L);
            response.resultSetStatus = BigInteger.valueOf(3L);
        }
        this.logger.fine("Send search response : ");
        try {
            this.assoc.encodeAndSend(pdu);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private String extractSetname(ElementSetNames_type esn_type) {
        String result = esn_type != null && esn_type.which == 0 ? esn_type.o.toString() : "f";
        return result;
    }

    public void incomingPresentRequest(APDUEvent e) {
        this.logger.fine("Incoming presentRequest");
        PresentRequest_type present_request = (PresentRequest_type)e.getPDU().o;
        int start = present_request.resultSetStartPoint.intValue();
        int count = present_request.numberOfRecordsRequested.intValue();
        String element_set_name = null;
        String schema = null;
        String result_set_name = present_request.resultSetId;
        String record_syntax = null;
        OIDRegisterEntry ent = this.reg.lookupByOID(present_request.preferredRecordSyntax);
        if (ent != null) {
            record_syntax = ent.getName();
        }
        element_set_name = present_request.recordComposition != null && present_request.recordComposition.which == 0 ? this.extractSetname((ElementSetNames_type)present_request.recordComposition.o) : "f";
        ArchetypeRecordFormatSpecification archetype = new ArchetypeRecordFormatSpecification(element_set_name);
        ExplicitRecordFormatSpecification explicit = new ExplicitRecordFormatSpecification(record_syntax, schema, element_set_name);
        this.backend.present(new BackendPresentResult(this, result_set_name != null ? result_set_name : "Default", start, count, record_syntax, element_set_name, present_request.recordComposition, present_request.referenceId, archetype, explicit));
    }

    public void notifyPresentResult(BackendPresentResult bpr) {
        PDU_type pdu = new PDU_type();
        pdu.which = 5;
        PresentResponse_type response = new PresentResponse_type();
        pdu.o = response;
        response.referenceId = bpr.refid;
        response.otherInfo = null;
        response.records = this.createRecordsFor(bpr.result_records, (RecordFormatSpecification)bpr.explicit);
        response.nextResultSetPosition = BigInteger.valueOf(bpr.next_result_set_position);
        if (response.records.which == 0) {
            response.numberOfRecordsReturned = BigInteger.valueOf(((List)response.records.o).size());
            response.presentStatus = BigInteger.valueOf(0L);
        } else {
            response.numberOfRecordsReturned = BigInteger.valueOf(0L);
            response.presentStatus = BigInteger.valueOf(5L);
        }
        try {
            this.assoc.encodeAndSend(pdu);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void incomingDeleteResultSetRequest(APDUEvent e) {
        this.logger.fine("Incoming deleteResultSetRequest");
        DeleteResultSetRequest_type delete_request = (DeleteResultSetRequest_type)e.getPDU().o;
        PDU_type pdu = new PDU_type();
        pdu.which = 7;
        DeleteResultSetResponse_type response = new DeleteResultSetResponse_type();
        pdu.o = response;
        response.referenceId = delete_request.referenceId;
        if (delete_request.deleteFunction.intValue() == 0) {
            Iterator task_list = ((AbstractList)delete_request.resultSetList).iterator();
            while (task_list.hasNext()) {
                String next_rs = (String)task_list.next();
            }
        }
        response.deleteOperationStatus = BigInteger.valueOf(0L);
        try {
            this.assoc.encodeAndSend(pdu);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void notifyDeleteResult(BackendDeleteResult bdr) {
    }

    public void incomingAccessControlRequest(APDUEvent e) {
        this.logger.info("Incoming accessControlRequest");
    }

    public void incomingAccessControlResponse(APDUEvent e) {
        this.logger.info("Incoming AccessControlResponse");
    }

    public void incomingResourceControlRequest(APDUEvent e) {
        this.logger.info("Incoming resourceControlRequest");
    }

    public void incomingTriggerResourceControlRequest(APDUEvent e) {
        this.logger.info("Incoming triggetResourceControlRequest");
    }

    public void incomingResourceReportRequest(APDUEvent e) {
        this.logger.info("Incoming resourceReportRequest");
    }

    public void incomingScanRequest(APDUEvent e) {
        ScanRequest_type scan_request = (ScanRequest_type)e.getPDU().o;
        boolean step_size = false;
        boolean scan_status = false;
        boolean number_of_entries_returned = false;
        boolean position_of_term = false;
    }

    public void incomingSortRequest(APDUEvent e) {
        this.logger.info("Incoming sortRequest");
    }

    public void incomingSegmentRequest(APDUEvent e) {
        this.logger.info("Incoming segmentRequest");
    }

    public void incomingExtendedServicesRequest(APDUEvent e) {
        this.logger.info("Incoming extendedServicesRequest");
    }

    public void incomingClose(APDUEvent e) {
        this.logger.fine("Close...");
        this.assoc.getPDUAnnouncer().deleteObserver(this.event_adapter);
        this.assoc.getPDUAnnouncer().deleteObservers();
        this.event_adapter = null;
        this.assoc.shutdown();
        try {
            this.assoc.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.logger.fine("Done joining with assoc thread");
        this.logger.fine("Deleting tasks...");
        this.assoc = null;
    }

    Records_type createRecordsFor(InformationFragment[] raw_records, RecordFormatSpecification spec) {
        Records_type retval = new Records_type();
        try {
            ArrayList<NamePlusRecord_type> v = new ArrayList<NamePlusRecord_type>();
            retval.which = 0;
            retval.o = v;
            for (int i = 0; i < raw_records.length; ++i) {
                this.logger.fine("Adding record " + i + " to result");
                NamePlusRecord_type npr = new NamePlusRecord_type();
                npr.name = raw_records[i].getSourceCollectionName();
                npr.record = new record_inline13_type();
                npr.record.which = 0;
                npr.record.o = this.encodeRecordForZ3950(raw_records[i]);
                v.add(npr);
            }
        }
        catch (Exception pe) {
            retval.which = 1;
            DefaultDiagFormat_type default_diag = new DefaultDiagFormat_type();
            retval.o = default_diag;
            default_diag.diagnosticSetId = this.reg.oidByName("diag-1");
            default_diag.condition = BigInteger.valueOf(0L);
            default_diag.addinfo = new addinfo_inline14_type();
            default_diag.addinfo.which = 0;
            default_diag.addinfo.o = pe.toString();
        }
        return retval;
    }

    private EXTERNAL_type encodeRecordForZ3950(InformationFragment fragment) {
        EXTERNAL_type rec = null;
        if (fragment instanceof DOMTree) {
            rec = new EXTERNAL_type();
            rec.direct_reference = this.reg.oidByName("xml");
            rec.encoding = new encoding_inline0_type();
            rec.encoding.which = 1;
            rec.encoding.o = ((DOMTree)fragment).toString().getBytes();
        } else if (fragment instanceof HTMLRecord) {
            rec = new EXTERNAL_type();
            rec.direct_reference = this.reg.oidByName("html");
            rec.encoding = new encoding_inline0_type();
            rec.encoding.which = 1;
            rec.encoding.o = fragment.toString().getBytes();
        } else if (fragment instanceof iso2709) {
            rec = new EXTERNAL_type();
            rec.direct_reference = this.reg.oidByName("marc21");
            rec.encoding = new encoding_inline0_type();
            rec.encoding.which = 1;
            rec.encoding.o = (byte[])fragment.getOriginalObject();
        } else if (fragment instanceof SGMLRecord) {
            rec = new EXTERNAL_type();
            rec.direct_reference = this.reg.oidByName("sgml");
            rec.encoding = new encoding_inline0_type();
            rec.encoding.which = 1;
            rec.encoding.o = fragment.toString().getBytes();
        } else if (fragment instanceof SurrogateDiagnostic) {
            rec = new EXTERNAL_type();
            rec.direct_reference = this.reg.oidByName("sgml");
            rec.encoding = new encoding_inline0_type();
            rec.encoding.which = 1;
            rec.encoding.o = fragment.toString().getBytes();
        } else if (fragment instanceof SUTRS) {
            rec = new EXTERNAL_type();
            rec.direct_reference = this.reg.oidByName("sutrs");
            rec.encoding = new encoding_inline0_type();
            rec.encoding.which = 0;
            rec.encoding.o = fragment.toString();
        } else if (fragment instanceof TextFragment) {
            rec = new EXTERNAL_type();
            rec.direct_reference = this.reg.oidByName("sutrs");
            rec.encoding = new encoding_inline0_type();
            rec.encoding.which = 0;
            rec.encoding.o = fragment.toString();
        } else if (!(fragment instanceof UnknownBlob)) {
            if (fragment instanceof XMLRecord) {
                rec = new EXTERNAL_type();
                rec.direct_reference = this.reg.oidByName("xml");
                rec.encoding = new encoding_inline0_type();
                rec.encoding.which = 1;
                rec.encoding.o = fragment.toString().getBytes();
            } else if (fragment instanceof Z3950RetrievalRecord) {
                rec = ((Z3950RetrievalRecord)fragment).getRecordEncoding();
            } else if (fragment instanceof DiagnosticFragment) {
                rec = new EXTERNAL_type();
                rec.direct_reference = this.reg.oidByName("sgml");
                rec.encoding = new encoding_inline0_type();
                rec.encoding.which = 1;
                rec.encoding.o = fragment.toString().getBytes();
            }
        }
        return rec;
    }

    private Records_type createNSD(String diag_code, String additional) {
        Records_type retval = new Records_type();
        retval.which = 1;
        DefaultDiagFormat_type default_diag = new DefaultDiagFormat_type();
        retval.o = default_diag;
        default_diag.diagnosticSetId = this.reg.oidByName("diag-1");
        default_diag.condition = diag_code != null ? BigInteger.valueOf(Long.parseLong(diag_code)) : BigInteger.valueOf(0L);
        default_diag.addinfo = new addinfo_inline14_type();
        default_diag.addinfo.which = 0;
        default_diag.addinfo.o = additional;
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

