/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.z3950.util;

import org.jzkit.z3950.util.MarcLeader;
import org.jzkit.z3950.util.MarcRecord;

class MarcDirectoryEntry {
    byte[] entry;
    int fieldlen;
    int localDataSize = 0;
    int offset;
    int recordOffset;
    int tag;

    MarcDirectoryEntry(MarcLeader leader) {
        this.localDataSize = leader.localdatalen;
    }

    MarcDirectoryEntry(int tag, int fieldlen, int offset) {
        StringBuffer sb = new StringBuffer();
        this.tag = tag;
        this.fieldlen = fieldlen;
        this.offset = offset;
        this.recordOffset = 0;
        sb.append(MarcRecord.intToString(tag, 3)).append(MarcRecord.intToString(fieldlen, 4)).append(MarcRecord.intToString(offset, 5));
        this.entry = sb.toString().getBytes();
    }

    void reset(byte[] buffer, int bufferOffset) {
        this.recordOffset = bufferOffset;
        this.tag = MarcRecord.bytesToInt(buffer, bufferOffset, 3);
        this.fieldlen = MarcRecord.bytesToInt(buffer, bufferOffset + 3, 4);
        this.offset = MarcRecord.bytesToInt(buffer, bufferOffset + 7, 5);
    }

    int SizeOf() {
        return 12 + this.localDataSize;
    }

    static int SizeOf(int localDataSize) {
        return 12 + localDataSize;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("DirectoryEntry at record offset ").append(this.recordOffset).append(": tag=").append(this.tag).append(", fieldlen=").append(this.fieldlen).append(", offset=").append(this.offset);
        return str.toString();
    }
}

