/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.z3950.util;

import java.text.DecimalFormat;
import java.util.Vector;
import java.util.logging.Level;
import org.jzkit.z3950.util.Header;
import org.jzkit.z3950.util.ISO2709Builder;
import org.jzkit.z3950.util.MarcDirectoryEntry;
import org.jzkit.z3950.util.MarcField;

class MarcRecord {
    String leaderData = null;
    Vector fields = new Vector();
    byte FieldTerminator = (byte)30;
    byte RecordTerminator = (byte)29;
    byte SubFieldDelimiter = (byte)31;
    static DecimalFormat df = new DecimalFormat();

    MarcRecord(String type) throws IllegalArgumentException {
        if (!type.equalsIgnoreCase("usmarc") && !type.equalsIgnoreCase("marc21")) {
            throw new IllegalArgumentException("Unsupported MARC record type: " + type);
        }
        this.RecordTerminator = (byte)29;
        this.FieldTerminator = (byte)30;
        this.SubFieldDelimiter = (byte)31;
    }

    void add(MarcField field) {
        this.fields.addElement(field);
    }

    static final int bytesToInt(byte[] buf, int offset, int len) {
        int val = 0;
        for (int i = offset; i < offset + len; ++i) {
            int b = buf[i] - 48;
            if (b < 0 || b > 9) {
                return -1;
            }
            val = val * 10 + b;
        }
        return val;
    }

    MarcField findField(int tag) {
        for (int i = 0; i < this.fields.size(); ++i) {
            MarcField field = (MarcField)this.fields.elementAt(i);
            if (field.tag != tag) continue;
            return field;
        }
        return null;
    }

    static final String intToString(int val, int len) {
        switch (len) {
            case 1: {
                df.applyLocalizedPattern("0");
                break;
            }
            case 2: {
                df.applyLocalizedPattern("00");
                break;
            }
            case 3: {
                df.applyLocalizedPattern("000");
                break;
            }
            case 4: {
                df.applyLocalizedPattern("0000");
                break;
            }
            case 5: {
                df.applyLocalizedPattern("00000");
            }
        }
        return df.format(val);
    }

    byte[] getBytes() {
        byte[] dataBuffer = new byte[99999];
        int offset = 0;
        MarcDirectoryEntry[] entries = new MarcDirectoryEntry[this.fields.size()];
        for (int i = 0; i < this.fields.size(); ++i) {
            MarcField mf = (MarcField)this.fields.elementAt(i);
            byte[] bytes = mf.getBytes();
            if (bytes == null) {
                ISO2709Builder.log.log(Level.SEVERE, "mf.getBytes returns null");
            }
            System.arraycopy(bytes, 0, dataBuffer, offset, bytes.length);
            entries[i] = new MarcDirectoryEntry(mf.tag, bytes.length, offset);
            offset += bytes.length;
        }
        dataBuffer[offset++] = this.RecordTerminator;
        try {
            Header header = new Header(this, entries, this.leaderData, offset);
            byte[] headerBytes = header.getBytes();
            byte[] record = new byte[headerBytes.length + offset];
            System.arraycopy(headerBytes, 0, record, 0, headerBytes.length);
            System.arraycopy(dataBuffer, 0, record, headerBytes.length, offset);
            return record;
        }
        catch (Exception e) {
            e.printStackTrace();
            ISO2709Builder.log.log(Level.SEVERE, "Problem", e);
            return null;
        }
    }
}

