/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.mainplugin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Param;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.util.ProviderServices;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.gui.beans.propertiespanel.PropertiesComponent;
import org.gvsig.gui.beans.propertiespanel.PropertyStruct;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.gvsig.raster.util.RasterNotLoadException;

public class RasterMainPluginUtils {
    public static ArrayList<FLayer> getRasterLayerList(FLayers srcLyrs, ArrayList<FLayer> destLyrs) {
        if (destLyrs == null) {
            destLyrs = new ArrayList();
        }
        for (int i = 0; i < srcLyrs.getLayersCount(); ++i) {
            if (srcLyrs.getLayer(i) instanceof DefaultFLyrRaster) {
                destLyrs.add(srcLyrs.getLayer(i));
            }
            if (!(srcLyrs.getLayer(i) instanceof FLayers)) continue;
            destLyrs = RasterMainPluginUtils.getLayerList((FLayers)srcLyrs.getLayer(i), destLyrs);
        }
        return destLyrs;
    }

    public static ArrayList<FLayer> getLayerList(FLayers srcLyrs, ArrayList<FLayer> destLyrs) {
        if (srcLyrs == null) {
            return null;
        }
        if (destLyrs == null) {
            destLyrs = new ArrayList();
        }
        for (int i = 0; i < srcLyrs.getLayersCount(); ++i) {
            if (srcLyrs.getLayer(i) instanceof FLayers) {
                destLyrs = RasterMainPluginUtils.getLayerList((FLayers)srcLyrs.getLayer(i), destLyrs);
                continue;
            }
            destLyrs.add(srcLyrs.getLayer(i));
        }
        return destLyrs;
    }

    public static String getView(FLayer layer) {
        Project p = ProjectManager.getInstance().getCurrentProject();
        return p.getViewName(layer);
    }

    public static void addWindow(IWindow window) {
        PluginServices.getMDIManager().addWindow(window);
    }

    public static void closeWindow(IWindow window) {
        PluginServices.getMDIManager().closeWindow(window);
    }

    public static void loadPropertiesFromWriterParams(PropertiesComponent pComp, Params params, String[] notTakeIntoAccount) {
        block5: for (int i = 0; i < params.getNumParams(); ++i) {
            Param p = params.getParam(i);
            String name = Messages.getText((String)p.getId());
            String key = p.getId();
            if (notTakeIntoAccount != null && notTakeIntoAccount.length > 0) {
                boolean jump = false;
                for (int j = 0; j < notTakeIntoAccount.length; ++j) {
                    if (!key.equals(notTakeIntoAccount[j])) continue;
                    jump = true;
                }
                if (jump) continue;
            }
            Object[] types = null;
            int selectedValue = 0;
            switch (p.getType()) {
                case 1: {
                    pComp.addValue(name, key, p.getDefaultValue(), types);
                    continue block5;
                }
                case 2: {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int j = 0; j < p.getList().length; ++j) {
                        list.add(p.getList()[j]);
                        if (!(p.getDefaultValue() instanceof Integer) || (Integer)p.getDefaultValue() != j) continue;
                        selectedValue = j;
                    }
                    types = new Object[]{new Integer(3), list};
                    pComp.addValue(name, key, (Object)new Integer(selectedValue), types);
                    continue block5;
                }
                case 3: {
                    types = new Object[]{new Integer(2), new Integer(p.getList()[0]), new Integer(p.getList()[1])};
                    pComp.addValue(name, key, p.getDefaultValue(), types);
                    continue block5;
                }
                default: {
                    pComp.addValue(Messages.getText((String)params.getParam(i).getId()), params.getParam(i).getId(), params.getParam(i).getDefaultValue(), null);
                }
            }
        }
    }

    public static void loadWriterParamsFromPropertiesPanel(PropertiesComponent pComp, Params params) {
        ArrayList values = pComp.getValues();
        block7: for (int iParam = 0; iParam < params.getNumParams(); ++iParam) {
            Param p = params.getParam(iParam);
            for (int iValue = 0; iValue < values.size(); ++iValue) {
                PropertyStruct prop = (PropertyStruct)values.get(iValue);
                if (p.getId().compareTo(prop.getKey()) != 0) continue;
                switch (p.getType()) {
                    case 1: {
                        p.setDefaultValue((Object)((Boolean)prop.getNewValue()));
                        break;
                    }
                    case 2: {
                        p.setDefaultValue((Object)((Integer)prop.getNewValue()));
                        break;
                    }
                    case 3: {
                        try {
                            p.setDefaultValue((Object)((Integer)prop.getNewValue()));
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                continue block7;
            }
        }
    }

    public static boolean canWrite(String path, Object pluginObject) {
        File f = new File(path);
        if (f.exists() && f.canWrite()) {
            return true;
        }
        if (pluginObject != null) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)pluginObject, (String)"error_escritura"));
        }
        return false;
    }

    public static FLayer loadLayer(String viewName, String fileName, String layerName) throws RasterNotLoadException {
        if (fileName == null) {
            return null;
        }
        AbstractViewPanel theView = null;
        try {
            IWindow[] allViews = PluginServices.getMDIManager().getAllWindows();
            if (viewName != null) {
                for (int i = 0; i < allViews.length; ++i) {
                    if (!(allViews[i] instanceof AbstractViewPanel) || !((AbstractViewPanel)allViews[i]).getDocument().getName().equals(viewName) && !PluginServices.getMDIManager().getWindowInfo((IWindow)((AbstractViewPanel)allViews[i])).getTitle().equals(viewName)) continue;
                    theView = (AbstractViewPanel)allViews[i];
                }
            } else {
                int i;
                IWindow activeWindow = PluginServices.getMDIManager().getActiveWindow();
                for (i = 0; i < allViews.length; ++i) {
                    if (!(allViews[i] instanceof AbstractViewPanel) || (AbstractViewPanel)allViews[i] != activeWindow) continue;
                    theView = (AbstractViewPanel)allViews[i];
                }
                if (theView == null) {
                    for (i = 0; i < allViews.length; ++i) {
                        if (!(allViews[i] instanceof AbstractViewPanel)) continue;
                        theView = (AbstractViewPanel)allViews[i];
                    }
                }
            }
            if (theView == null) {
                throw new RasterNotLoadException("Imposible cargar la capa.");
            }
        }
        catch (ClassCastException ex) {
            throw new RasterNotLoadException("No se puede hacer un casting de esa IWindow a View.");
        }
        theView.getMapControl().getMapContext().beginAtomicEvent();
        DefaultFLyrRaster lyr = null;
        try {
            ProviderServices provServ = RasterLocator.getManager().getProviderServices();
            RasterDataParameters storeParameters = provServ.createNotTiledParameters(fileName);
            storeParameters.setSRS(theView.getProjection());
            MapContextManager mcm = MapContextLocator.getMapContextManager();
            DataManager dataManager = DALLocator.getDataManager();
            DataStore dataStore = null;
            try {
                dataStore = dataManager.createStore((DataStoreParameters)storeParameters);
            }
            catch (ValidateDataParametersException e) {
                throw new RasterNotLoadException("Error al cargar la capa.");
            }
            catch (InitializeException e) {
                throw new RasterNotLoadException("Error al cargar la capa.");
            }
            catch (ProviderNotRegisteredException e) {
                throw new RasterNotLoadException("Error al cargar la capa.");
            }
            lyr = new DefaultFLyrRaster();
            if (layerName == null) {
                int endIndex = fileName.lastIndexOf(".");
                if (endIndex < 0) {
                    endIndex = fileName.length();
                }
                layerName = fileName.substring(fileName.lastIndexOf(File.separator) + 1, endIndex);
            }
            lyr = (DefaultFLyrRaster)mcm.createLayer(layerName, dataStore);
        }
        catch (LoadLayerException e) {
            throw new RasterNotLoadException("Error al cargar la capa.");
        }
        catch (InitializeException e) {
            throw new RasterNotLoadException("Error creating parameters.");
        }
        catch (ProviderNotRegisteredException e) {
            throw new RasterNotLoadException("Error creating parameters.");
        }
        theView.getMapControl().getMapContext().getLayers().addLayer((FLayer)lyr);
        theView.getMapControl().getMapContext().invalidate();
        theView.getMapControl().getMapContext().endAtomicEvent();
        return lyr;
    }

    public static FLayer loadLayer(String viewName, FLayer lyr) throws RasterNotLoadException {
        if (lyr == null) {
            return null;
        }
        AbstractViewPanel theView = null;
        try {
            IWindow[] allViews = PluginServices.getMDIManager().getAllWindows();
            if (viewName != null) {
                for (int i = 0; i < allViews.length; ++i) {
                    if (!(allViews[i] instanceof AbstractViewPanel) || !PluginServices.getMDIManager().getWindowInfo((IWindow)((AbstractViewPanel)allViews[i])).getTitle().equals(viewName)) continue;
                    theView = (AbstractViewPanel)allViews[i];
                }
            } else {
                int i;
                IWindow activeWindow = PluginServices.getMDIManager().getActiveWindow();
                for (i = 0; i < allViews.length; ++i) {
                    if (!(allViews[i] instanceof AbstractViewPanel) || (AbstractViewPanel)allViews[i] != activeWindow) continue;
                    theView = (AbstractViewPanel)allViews[i];
                }
                if (theView == null) {
                    for (i = 0; i < allViews.length; ++i) {
                        if (!(allViews[i] instanceof AbstractViewPanel)) continue;
                        theView = (AbstractViewPanel)allViews[i];
                    }
                }
            }
            if (theView == null) {
                throw new RasterNotLoadException("Imposible cargar la capa.");
            }
        }
        catch (ClassCastException ex) {
            throw new RasterNotLoadException("No se puede hacer un casting de esa IWindow a View.");
        }
        theView.getMapControl().getMapContext().beginAtomicEvent();
        theView.getMapControl().getMapContext().getLayers().addLayer(lyr);
        theView.getMapControl().getMapContext().invalidate();
        theView.getMapControl().getMapContext().endAtomicEvent();
        return lyr;
    }

    public static Point iwindowPosition(int widthWindow, int heightWindow) {
        int posWindowX = 0;
        int posWindowY = 0;
        Dimension dim = null;
        Point pos = null;
        if (PluginServices.getMainFrame() instanceof Component) {
            dim = ((Component)PluginServices.getMainFrame()).getSize();
            pos = ((Component)PluginServices.getMainFrame()).getLocation();
            if (dim != null && pos != null) {
                posWindowX = (dim.width >> 1) - (widthWindow >> 1);
                posWindowY = (dim.height >> 1) - (heightWindow >> 1) - 70;
                return new Point(posWindowX, posWindowY);
            }
        }
        return null;
    }
}

