/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.featureform.swing.CreateJFeatureFormException;
import org.gvsig.featureform.swing.JFeaturesForm;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class ShowTableAsForm
extends Extension {
    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"table-show-form", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        ApplicationManager application = ApplicationLocator.getManager();
        if ("table-show-form".equalsIgnoreCase(actionCommand)) {
            TableDocument doc = (TableDocument)application.getActiveDocument(TableManager.TYPENAME);
            if (doc == null) {
                return;
            }
            FeatureTableDocumentPanel tablePanel = (FeatureTableDocumentPanel)((Object)doc.getMainComponent());
            FeatureStore store = tablePanel.getFeatureStore();
            try {
                JFeaturesForm form = this.createform(store);
                form.showForm(application.makeTitle("_Form", doc.getName(), store.getName()), WindowManager.MODE.WINDOW);
            }
            catch (Exception ex) {
                String msg = "Can't show form for table '" + doc.getName() + "'.";
                logger.warn(msg, (Throwable)ex);
                application.messageDialog(msg + "\n\n(See the error log for more information)", "Warning", 2);
            }
        }
    }

    private JFeaturesForm createform(FeatureStore featureStore) throws CreateJFeatureFormException, ServiceException, DataException {
        DataSwingManager swingManager = DALSwingLocator.getSwingManager();
        JFeaturesForm form = swingManager.createJFeaturesForm(featureStore);
        form.getFormset().setAllowDelete(true);
        form.getFormset().setAllowNew(true);
        form.setTerminateEditingOnClose(false);
        return form;
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        TableDocument doc = (TableDocument)application.getActiveDocument(TableManager.TYPENAME);
        return doc != null;
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        Document doc = application.getActiveDocument(TableManager.TYPENAME);
        return doc != null;
    }
}

