/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.configurableactions.ConfigurableActionsMamager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.featuretype.FeatureTypeAttributePanel;
import org.gvsig.fmap.dal.swing.featuretype.FeatureTypePanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.xml.XMLPersistenceManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.util.ToolsUtilLocator;

public class TableEditAttributes
extends Extension {
    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"table-column-manager", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"table-add-column", (Object)((Object)this));
    }

    public void postInitialize() {
        ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
        cfgActionsManager.addConfigurableAction("FeatureTypePanel", (Action)new ShowAsTableAction());
        cfgActionsManager.addConfigurableAction("FeatureTypePanel", (Action)new WriteToDALFileAction());
        cfgActionsManager.addConfigurableAction("FeatureTypePanel", (Action)new WriteToDALFileHexAction());
    }

    public boolean canQueryByAction() {
        return true;
    }

    public void execute(String s) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
        DataManager dataMamager = DALLocator.getDataManager();
        ApplicationManager application = ApplicationLocator.getManager();
        TableDocument tabledoc = (TableDocument)application.getActiveDocument(TableManager.TYPENAME);
        if (tabledoc == null) {
            return;
        }
        FeatureTableDocumentPanel tablePanel = (FeatureTableDocumentPanel)((Object)tabledoc.getMainComponent());
        final FeatureStore featureStore = tablePanel.getFeatureStore();
        if ("table-column-manager".equalsIgnoreCase(s)) {
            try {
                String extraMsg;
                FeatureStoreProviderFactory ffactory;
                ApplicationManager aplication = ApplicationLocator.getManager();
                FeatureType featureType = featureStore.getDefaultFeatureType();
                EditableFeatureType editableFeatureType = featureType.getEditable();
                FeatureTypePanel panel = dataSwingManager.createFeatureTypePanel();
                ViewDocument viewdoc = (ViewDocument)application.getCurrentProject().getFirstDocument(ViewDocument.class);
                if (viewdoc != null) {
                    panel.setDefaultProjection(viewdoc.getProjection());
                }
                ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
                ConfigurableActionsMamager.ActionsController actionController = cfgActionsManager.getConfigurableActionsController("FeatureTypePanel");
                actionController.addAction((Action)new WriteOpenDataStoreParametersToFileHex(featureStore.getParameters()));
                actionController.addAction((Action)new WriteOpenDataStoreParametersToFileXML(featureStore.getParameters()));
                panel.put((FeatureType)editableFeatureType);
                int mode = featureStore.isEditing() ? 1 : 0;
                DataStoreProviderFactory factory = featureStore.getProviderFactory();
                if (factory instanceof FeatureStoreProviderFactory && (ffactory = (FeatureStoreProviderFactory)factory).allowEditableFeatureType() == 2) {
                    mode = 0;
                }
                extraMsg = StringUtils.isNotBlank((CharSequence)(extraMsg = Objects.toString(featureStore.getProperty("DAL.featureTypeEditMode.msg"), null))) ? "\n" + i18n.getTranslation(extraMsg) : "";
                switch (mode) {
                    case 2: {
                        break;
                    }
                    case 0: {
                        int newmode = NumberUtils.toInt((String)Objects.toString(featureStore.getProperty("DAL.featureTypeEditMode")), (int)mode);
                        switch (newmode) {
                            case 2: {
                                mode = newmode;
                                break;
                            }
                            case 0: {
                                break;
                            }
                            case 1: {
                                mode = 0;
                            }
                        }
                        break;
                    }
                    case 1: {
                        mode = NumberUtils.toInt((String)Objects.toString(featureStore.getProperty("DAL.featureTypeEditMode")), (int)mode);
                    }
                }
                switch (mode) {
                    case 2: {
                        aplication.messageDialog(i18n.getTranslation("_The_table_dont_allow_edit_columns") + extraMsg, i18n.getTranslation("_Warning"), 1);
                        break;
                    }
                    case 0: {
                        if (featureStore.isEditing()) {
                            aplication.messageDialog(i18n.getTranslation("_The_table_is_not_in_edit_mode") + "\n" + i18n.getTranslation("_You_can_only_add_virtual_fields_and_modify_some_table_data_metadata") + extraMsg, i18n.getTranslation("_Warning"), 1);
                            break;
                        }
                        aplication.messageDialog(i18n.getTranslation("_The_table_only_allow_edit_metadata_of_columns") + "\n" + i18n.getTranslation("_You_can_only_add_virtual_fields_and_modify_some_table_data_metadata") + extraMsg, i18n.getTranslation("_Warning"), 1);
                        break;
                    }
                    case 1: {
                        if (!StringUtils.isNotBlank((CharSequence)extraMsg)) break;
                        aplication.messageDialog(extraMsg, i18n.getTranslation("_Warning"), 1);
                    }
                }
                panel.setMode(mode);
                String title = application.makeTitle("_Column_manager", tabledoc.getName(), featureStore.getName());
                Dialog dialog = winManager.createDialog(panel.asJComponent(), title, null, 3);
                if (mode == 2) {
                    dialog.setButtonEnabled(1, false);
                }
                panel.addChangeListener(e -> {
                    if (panel.isEditing()) {
                        dialog.setButtonEnabled(1, false);
                    } else {
                        dialog.setButtonEnabled(1, true);
                    }
                });
                dialog.addActionListener(e -> {
                    if (dialog.getAction() != 1) {
                        return;
                    }
                    try {
                        FeatureQueryOrder order;
                        panel.fetch(editableFeatureType);
                        FeatureQuery query = tablePanel.getTablePanel().getFeatureQuery();
                        if (query != null && (order = query.getOrder()) != null) {
                            Iterator it = order.iterator();
                            while (it.hasNext()) {
                                FeatureQueryOrder.FeatureQueryOrderMember orderMember = (FeatureQueryOrder.FeatureQueryOrderMember)it.next();
                                String attrName = orderMember.getAttributeName();
                                if (editableFeatureType.getAttributeDescriptor(attrName) != null || orderMember.hasEvaluator()) continue;
                                it.remove();
                            }
                        }
                        featureStore.update(editableFeatureType);
                        dataMamager.clearAvailableValuesCache();
                    }
                    catch (Exception ex) {
                        logger.warn("Problems updating featuretype.", (Throwable)ex);
                        aplication.messageDialog(i18n.getTranslation("_Problems_updating_columns_information") + "\n" + i18n.getTranslation("_see_error_log_for_more_information"), i18n.getTranslation("_Warning"), 2);
                    }
                });
                Dimension screensize = ApplicationLocator.getApplicationManager().getUIManager().getInternalSize();
                Dimension panelsize = panel.asJComponent().getPreferredSize();
                ToolsSwingUtils.ensureHeightWitdh((JComponent)panel.asJComponent(), (int)Math.max(3 * (screensize.height / 4), panelsize.height), (int)Math.max(2 * (screensize.width / 4), panelsize.width), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
                dialog.show(WindowManager.MODE.WINDOW, Collections.singletonMap("align", 10));
            }
            catch (Exception ex) {
                logger.warn("Problems show FeatureTypePanel.", (Throwable)ex);
            }
        } else if ("table-add-column".equals(s)) {
            try {
                final FeatureType featureType = featureStore.getDefaultFeatureType();
                final FeatureTypeAttributePanel panel = dataSwingManager.createFeatureTypeAttributePanel();
                panel.clean();
                panel.setNameAsNew(featureType);
                panel.setMode(1);
                final Dialog dialog = winManager.createDialog(panel.asJComponent(), i18n.getTranslation("_New_field") + " - " + tabledoc.getName(), null, 3);
                dialog.setAutoclose(false);
                dialog.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (dialog.getAction() != 1) {
                            panel.asJComponent().setVisible(false);
                            return;
                        }
                        if (!featureStore.isEditing()) {
                            panel.asJComponent().setVisible(false);
                            return;
                        }
                        try {
                            EditableFeatureType editableFeatureType = featureType.getEditable();
                            EditableFeatureAttributeDescriptor descriptor = editableFeatureType.add(panel.getName(), 8);
                            if (panel.fetch(descriptor) != null) {
                                featureStore.update(editableFeatureType);
                                panel.asJComponent().setVisible(false);
                            }
                        }
                        catch (Exception ex) {
                            logger.warn("Problems updating featuretype.", (Throwable)ex);
                        }
                    }
                });
                dialog.show(WindowManager.MODE.WINDOW, Collections.singletonMap("align", 10));
            }
            catch (Exception ex) {
                logger.warn("Problems show FeatureTypeAttributePanel.", (Throwable)ex);
            }
        }
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        TableDocument tabledoc = (TableDocument)application.getActiveDocument(TableManager.TYPENAME);
        if (tabledoc == null) {
            return false;
        }
        return tabledoc.getStore().isEditing();
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        TableDocument tabledoc = (TableDocument)application.getActiveDocument(TableManager.TYPENAME);
        return tabledoc != null;
    }

    public boolean isVisible(String action) {
        return this.isVisible();
    }

    public boolean isEnabled(String action) {
        ApplicationManager application = ApplicationLocator.getManager();
        TableDocument tabledoc = (TableDocument)application.getActiveDocument(TableManager.TYPENAME);
        if (tabledoc == null) {
            return false;
        }
        if ("table-column-manager".equalsIgnoreCase(action)) {
            return true;
        }
        if ("table-add-column".equals(action)) {
            FeatureStore store = tabledoc.getStore();
            DataStoreProviderFactory factory = store.getProviderFactory();
            if (factory instanceof FeatureStoreProviderFactory) {
                FeatureStoreProviderFactory ffactory = (FeatureStoreProviderFactory)factory;
                if (ffactory.allowEditableFeatureType() == 2) {
                    return false;
                }
                return tabledoc.getStore().isEditing();
            }
            return tabledoc.getStore().isEditing();
        }
        return false;
    }

    public static class ShowAsTableAction
    extends AbstractAction {
        public ShowAsTableAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Show_as_table"));
            this.putValue("ActionCommandKey", "ShowAsTable");
            this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getCurrent().get("layer-show-attributes-table"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            FeatureTypePanel panel = (FeatureTypePanel)ae.getSource();
            EditableFeatureType featureType = panel.fetch(null);
            FeatureStore store = featureType.getAsFeatureStore();
            ProjectManager projectManager = ApplicationLocator.getManager().getProjectManager();
            Project project = projectManager.getCurrentProject();
            TableDocument tableDoc = (TableDocument)project.getDocument(store.getName(), TableManager.TYPENAME);
            if (tableDoc == null) {
                tableDoc = (TableDocument)projectManager.createDocument(TableManager.TYPENAME);
                tableDoc.setStore(store);
                tableDoc.setName(store.getName());
                project.addDocument((Document)tableDoc);
            }
            ApplicationLocator.getManager().getUIManager().addWindow(tableDoc.getMainWindow());
        }
    }

    public static class WriteOpenDataStoreParametersToFileXML
    extends AbstractAction {
        private DataStoreParameters params;

        public WriteOpenDataStoreParametersToFileXML(DataStoreParameters params) {
            this.params = params;
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Save_OpenDataStoreParameters_XML"));
            this.putValue("ActionCommandKey", "WriteOpenDataStoreParametersToFileXML");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ApplicationManager application = ApplicationLocator.getApplicationManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            FoldersManager foldersManager = ToolsLocator.getFoldersManager();
            File[] f = application.showSaveFileDialog(i18n.getTranslation("_Save_OpenDataStoreParameters_XML"), foldersManager.getLastPath("WriteOpenDataStoreParametersToFileXML", null));
            if (f == null || f.length == 0) {
                return;
            }
            foldersManager.setLastPath("WriteOpenDataStoreParametersToFileXML", f[0].getParentFile());
            try {
                PersistenceManager defaultPersistenceManager = ToolsLocator.getPersistenceManager();
                XMLPersistenceManager xmlPersistenceManager = new XMLPersistenceManager();
                for (PersistenceFactory factory : defaultPersistenceManager.getFactories()) {
                    xmlPersistenceManager.registerFactory(factory);
                }
                FileOutputStream stream = new FileOutputStream(f[0]);
                PersistentState state = xmlPersistenceManager.getState((Object)this.params);
                xmlPersistenceManager.saveState(state, (OutputStream)stream);
            }
            catch (Exception ex) {
                logger.warn("Can't save parameters to file '" + Objects.toString(f[0]), (Throwable)ex);
                application.messageDialog(i18n.getTranslation("_Cant_save_parameters_to_file") + "\n" + i18n.getTranslation("_See_log_for_details"), i18n.getTranslation("_Save_parameters_as_XML"), 2);
            }
        }
    }

    public static class WriteOpenDataStoreParametersToFileHex
    extends AbstractAction {
        private DataStoreParameters params;

        public WriteOpenDataStoreParametersToFileHex(DataStoreParameters params) {
            this.params = params;
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Save_OpenDataStoreParameters_hex"));
            this.putValue("ActionCommandKey", "WriteOpenDataStoreParametersToFileHex");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ApplicationManager application = ApplicationLocator.getApplicationManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            FoldersManager foldersManager = ToolsLocator.getFoldersManager();
            File[] f = application.showSaveFileDialog(i18n.getTranslation("_Save_OpenDataStoreParameters_hex"), foldersManager.getLastPath("WriteOpenDataStoreParametersToFileHex", null));
            if (f == null || f.length == 0) {
                return;
            }
            foldersManager.setLastPath("WriteOpenDataStoreParametersToFileHex", f[0].getParentFile());
            try {
                FileUtils.write((File)f[0], (CharSequence)Hex.encodeHexString((byte[])this.params.toByteArray()), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                logger.warn("Can't save parameters to file '" + Objects.toString(f[0]), (Throwable)ex);
                application.messageDialog(i18n.getTranslation("_Cant_save_parameters_to_file") + "\n" + i18n.getTranslation("_See_log_for_details"), i18n.getTranslation("_Save_parameters_as_hex"), 2);
            }
        }
    }

    public static class WriteToDALFileHexAction
    extends AbstractAction {
        public WriteToDALFileHexAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Save_as_DAL_file_hex"));
            this.putValue("ActionCommandKey", "WriteToDALFileHex");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            FeatureTypePanel panel = (FeatureTypePanel)ae.getSource();
            EditableFeatureType featureType = panel.fetch(null);
            ApplicationManager application = ApplicationLocator.getApplicationManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            FoldersManager foldersManager = ToolsLocator.getFoldersManager();
            File[] f = application.showSaveFileDialog(i18n.getTranslation("_Save_as_DAL_file_hex"), foldersManager.getLastPath("SaveAsDALFileHex", null));
            if (f == null || f.length == 0) {
                return;
            }
            foldersManager.setLastPath("SaveAsDALFileHex", f[0].getParentFile());
            featureType.writeAsDALFile(f[0], "hex");
        }
    }

    public static class WriteToDALFileAction
    extends AbstractAction {
        public WriteToDALFileAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Save_as_DAL_file"));
            this.putValue("ActionCommandKey", "WriteToDALFile");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            FeatureTypePanel panel = (FeatureTypePanel)ae.getSource();
            EditableFeatureType featureType = panel.fetch(null);
            ApplicationManager application = ApplicationLocator.getApplicationManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            FoldersManager foldersManager = ToolsLocator.getFoldersManager();
            File[] f = application.showSaveFileDialog(i18n.getTranslation("_Save_as_DAL_file"), foldersManager.getLastPath("SaveAsDALFile", null));
            if (f == null || f.length == 0) {
                return;
            }
            foldersManager.setLastPath("SaveAsDALFile", f[0].getParentFile());
            featureType.writeAsDALFile(f[0]);
        }
    }
}

