/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.actioninfo.ActionInfo;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.plugins.IExtension;
import org.gvsig.andami.plugins.status.IExtensionStatus;
import org.gvsig.andami.plugins.status.IUnsavedData;
import org.gvsig.andami.plugins.status.UnsavedData;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.AbstractTableEditExtension;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.EditingNotification;
import org.gvsig.fmap.dal.EditingNotificationManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.WriteException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.utils.swing.threads.IMonitorableTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableEditStopExtension
extends AbstractTableEditExtension {
    private static Logger LOGGER = LoggerFactory.getLogger(TableEditStopExtension.class);

    @Override
    public void initialize() {
        super.initialize();
        IconThemeHelper.registerIcon((String)"action", (String)"table-stop-editing", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        this.execute(actionCommand, null);
    }

    public void execute(String actionCommand, Object[] args) {
        Arguments arguments = Arguments.create((Object[])args);
        if ("table-stop-editing".equals(actionCommand)) {
            EditingNotificationManager editingNotification;
            EditingNotification notification;
            TableDocument doc = (TableDocument)((Object)arguments.get(0));
            if (doc == null) {
                doc = (TableDocument)this.table.getDocument();
            }
            if ((notification = (editingNotification = DALSwingLocator.getEditingNotificationManager()).notifyObservers((Object)this, "BEFORE_EXIT_EDITING_STORE", (Object)doc, (DataStore)doc.getStore())).isCanceled()) {
                return;
            }
            this.stopEditing(this.table);
            ApplicationLocator.getManager().refreshMenusAndToolBars();
            editingNotification.notifyObservers((Object)this, "AFTER_EXIT_EDITING_STORE", (Object)doc, (DataStore)doc.getStore());
        }
    }

    private void stopEditing(FeatureTableDocumentPanel table) {
        String message;
        Object[] options;
        FeatureStore featureStore = table.getFeatureStore();
        boolean allowWrite = featureStore.allowWrite();
        ApplicationManager application = ApplicationLocator.getManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (allowWrite) {
            options = new Object[]{i18n.getTranslation("_Guardar"), "       " + i18n.getTranslation("_Descartar") + "       ", i18n.getTranslation("_Continuar")};
            message = i18n.getTranslation("stop_editing_message");
        } else {
            options = new Object[]{i18n.getTranslation("_Export"), "       " + i18n.getTranslation("_Descartar") + "       ", i18n.getTranslation("_Continuar")};
            message = i18n.getTranslation("export_and_stop_editing_message");
        }
        int resp = JOptionPane.showOptionDialog((Component)PluginServices.getMainFrame(), message, i18n.getTranslation("stop_edition"), 1, 3, null, options, options[2]);
        switch (resp) {
            case 1: {
                try {
                    featureStore.cancelEditing();
                }
                catch (DataException e) {
                    LOGGER.warn("Problems canceling table editing: " + e.getMessage(), (Throwable)e);
                    application.messageDialog(i18n.getTranslation("_Problems_cancel_table_editing") + "\n\n" + i18n.getTranslation("_see_error_log_for_more_information"), null, i18n.getTranslation("_Warning"), 2, "Table_cant_cancelEditing");
                }
                break;
            }
            case 0: {
                try {
                    if (allowWrite) {
                        featureStore.finishEditing();
                        break;
                    }
                    this.exportTable(table.getDocument(), featureStore);
                }
                catch (DataException e) {
                    LOGGER.warn("Problems finish table editing: " + e.getMessage(), (Throwable)e);
                    application.messageDialog(i18n.getTranslation("_Problems_finish_table_editing") + "\n\n" + i18n.getTranslation("_see_error_log_for_more_information"), null, i18n.getTranslation("_Warning"), 2, "Table_cant_finishEditing");
                }
                break;
            }
        }
    }

    private void exportTable(Document document, FeatureStore store) {
        ApplicationManager appManager = ApplicationLocator.getManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        ActionInfo action = PluginsLocator.getActionInfoManager().getAction("table-exportto");
        action.execute(new Object[]{document, WindowManager.MODE.toInteger((WindowManager.MODE)WindowManager.MODE.DIALOG)});
        String msg = "_Do_you_want_to_finish_editing_If_not_exported_the_data_the_changes_will_be_lost";
        if (appManager.confirmDialog(i18n.getTranslation(msg), i18n.getTranslation("end_editing"), 0, 3) == 0) {
            try {
                store.cancelEditing();
            }
            catch (Exception e) {
                LOGGER.warn("Can't abort editing of table '" + document.getName() + "'.", (Throwable)e);
                msg = i18n.getTranslation("_Problems_finish_table_editing") + "\n\n" + i18n.getTranslation("_see_error_log_for_more_information");
                appManager.messageDialog(msg, "_Warning", 2);
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isVisible() {
        IWindow v = PluginServices.getMDIManager().getActiveWindow();
        if (v == null) {
            return false;
        }
        if (v instanceof FeatureTableDocumentPanel && ((FeatureTableDocumentPanel)v).getModel().getStore().isEditing()) {
            this.table = (FeatureTableDocumentPanel)v;
            return true;
        }
        return false;
    }

    private boolean executeSaveTable(TableDocument table2) {
        FeatureStore fs = table2.getStore();
        if (fs.isEditing()) {
            try {
                fs.finishEditing();
            }
            catch (WriteException e) {
                NotificationManager.addError((String)PluginServices.getText((Object)((Object)this), (String)"error_saving_table"), (Throwable)e);
                return false;
            }
            catch (ReadException e) {
                NotificationManager.addError((String)PluginServices.getText((Object)((Object)this), (String)"error_saving_table"), (Throwable)e);
                return false;
            }
            catch (DataException e) {
                NotificationManager.addError((String)PluginServices.getText((Object)((Object)this), (String)"error_saving_table"), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public IExtensionStatus getStatus() {
        return new StopEditingStatus();
    }

    private class UnsavedTable
    extends UnsavedData {
        private TableDocument table;

        public UnsavedTable(IExtension extension) {
            super(extension);
        }

        public String getDescription() {
            return PluginServices.getText((Object)((Object)this), (String)"editing_table_unsaved");
        }

        public String getResourceName() {
            return this.table.getName();
        }

        public boolean saveData() {
            return TableEditStopExtension.this.executeSaveTable(this.table);
        }

        public void setTable(TableDocument table) {
            this.table = table;
        }

        public String getIcon() {
            return "document-table-icon-small";
        }
    }

    private class StopEditingStatus
    implements IExtensionStatus {
        private StopEditingStatus() {
        }

        public boolean hasUnsavedData() {
            Project project = ProjectManager.getInstance().getCurrentProject();
            List tables = project.getDocuments(TableManager.TYPENAME);
            for (int i = 0; i < tables.size(); ++i) {
                FeatureStore store = ((TableDocument)((Object)tables.get(i))).getStore();
                if (store == null || !store.isEditing()) continue;
                return true;
            }
            return false;
        }

        public boolean hasRunningProcesses() {
            return false;
        }

        public IMonitorableTask[] getRunningProcesses() {
            return null;
        }

        public IUnsavedData[] getUnsavedData() {
            Project project = ProjectManager.getInstance().getCurrentProject();
            List tables = project.getDocuments(TableManager.TYPENAME);
            ArrayList<UnsavedTable> unsavedTables = new ArrayList<UnsavedTable>();
            for (int i = 0; i < tables.size(); ++i) {
                TableDocument table = (TableDocument)((Object)tables.get(i));
                FeatureStore store = table.getStore();
                if (store == null || !store.isEditing()) continue;
                UnsavedTable ul = new UnsavedTable((IExtension)TableEditStopExtension.this);
                ul.setTable(table);
                unsavedTables.add(ul);
            }
            return unsavedTables.toArray(new IUnsavedData[unsavedTables.size()]);
        }
    }
}

