/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.table.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jwizardcomponent.JWizardComponents;
import jwizardcomponent.JWizardPanel;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.utils.swing.JComboBox;
import org.gvsig.utils.swing.objectSelection.ObjectSelectionModel;

public class TableWizardStep
extends JWizardPanel {
    private JLabel lbl_header = null;
    private static final long serialVersionUID = 1L;
    private JLabel tableNameLbl = null;
    private JComboBox tableNameCmb = null;
    private JLabel fieldNameLbl = null;
    private JComboBox fieldNameCmb = null;
    private JLabel fieldPrefixLbl = null;
    private JTextField fieldPrefixTxt = null;

    public TableWizardStep(JWizardComponents wizardComponents, String title) {
        super(wizardComponents, title);
        this.initialize();
    }

    public void setTableModel(ObjectSelectionModel model) {
        this.getTableNameCmb().removeAllItems();
        try {
            Object[] tableNames = model.getObjects();
            for (int i = 0; i < tableNames.length; ++i) {
                this.getTableNameCmb().addItem(tableNames[i]);
            }
        }
        catch (Exception e) {
            NotificationManager.addError((String)PluginServices.getText((Object)((Object)this), (String)"Error_getting_table_fields"), (Throwable)e);
        }
    }

    public void setFieldModel(ObjectSelectionModel model) {
        this.getFieldNameCmb().removeAllItems();
        try {
            Object[] fieldNames = model.getObjects();
            for (int i = 0; i < fieldNames.length; ++i) {
                this.getFieldNameCmb().addItem(fieldNames[i]);
            }
        }
        catch (Exception e) {
            NotificationManager.addError((String)PluginServices.getText((Object)((Object)this), (String)"Error_getting_table_fields"), (Throwable)e);
        }
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.anchor = 11;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(4, 10, 8, 4);
        this.add(this.getHeaderLbl(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(4, 10, 4, 6);
        this.add(this.getTableNameLbl(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.weightx = 0.5;
        constraints.weighty = 0.0;
        this.add((Component)this.getTableNameCmb(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(4, 10, 4, 6);
        this.add(this.getFieldNameLbl(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.weightx = 0.5;
        constraints.weighty = 0.0;
        this.add((Component)this.getFieldNameCmb(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(4, 10, 4, 6);
        this.add(this.getFieldPrefixLbl(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.weightx = 0.5;
        constraints.weighty = 0.0;
        this.add(this.getFieldPrefixTxt(), constraints);
    }

    public JLabel getHeaderLbl() {
        if (this.lbl_header == null) {
            this.lbl_header = new JLabel();
            Font font = this.lbl_header.getFont();
            this.lbl_header.setFont(font.deriveFont(1));
        }
        return this.lbl_header;
    }

    public JLabel getTableNameLbl() {
        if (this.tableNameLbl == null) {
            this.tableNameLbl = new JLabel();
        }
        return this.tableNameLbl;
    }

    public JComboBox getTableNameCmb() {
        if (this.tableNameCmb == null) {
            this.tableNameCmb = new JComboBox();
        }
        return this.tableNameCmb;
    }

    public JLabel getFieldNameLbl() {
        if (this.fieldNameLbl == null) {
            this.fieldNameLbl = new JLabel();
        }
        return this.fieldNameLbl;
    }

    public JComboBox getFieldNameCmb() {
        if (this.fieldNameCmb == null) {
            this.fieldNameCmb = new JComboBox();
        }
        return this.fieldNameCmb;
    }

    public JLabel getFieldPrefixLbl() {
        if (this.fieldPrefixLbl == null) {
            this.fieldPrefixLbl = new JLabel();
        }
        return this.fieldPrefixLbl;
    }

    public JTextField getFieldPrefixTxt() {
        if (this.fieldPrefixTxt == null) {
            this.fieldPrefixTxt = new JTextField();
        }
        return this.fieldPrefixTxt;
    }
}

