/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.i18n.extension.preferences.table;

import java.util.Locale;
import javax.swing.table.AbstractTableModel;
import org.gvsig.i18n.I18nException;
import org.gvsig.i18n.I18nManager;
import org.gvsig.i18n.Messages;

public class LocaleTableModel
extends AbstractTableModel {
    public static final int COLUMN_LOCALE = -1;
    public static final int COLUMN_LANGUAGE = 0;
    public static final int COLUMN_COUNTRY = 1;
    public static final int COLUMN_VARIANT = 2;
    public static final int COLUMN_ACTIVE = 3;
    private static final long serialVersionUID = -3855372372788577788L;
    private final I18nManager manager;
    private Locale[] locales;
    private int currentLocaleIndex;
    private int originalLocaleIndex;

    public LocaleTableModel(I18nManager manager) {
        this.manager = manager;
        this.loadLocales();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.locales.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case -1: {
                return this.locales[rowIndex];
            }
            case 0: {
                return this.manager.getLanguageDisplayName(this.locales[rowIndex]);
            }
            case 1: {
                return this.locales[rowIndex].getDisplayCountry();
            }
            case 2: {
                return this.locales[rowIndex].getDisplayVariant();
            }
            case 3: {
                return rowIndex == this.currentLocaleIndex ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case -1: {
                return Messages.getText((String)"I18nPreferencePage.Locale_code");
            }
            case 0: {
                return Messages.getText((String)"I18nPreferencePage.Idioma");
            }
            case 1: {
                return Messages.getText((String)"I18nPreferencePage.Pais");
            }
            case 2: {
                return Messages.getText((String)"I18nPreferencePage.Variante");
            }
            case 3: {
                return Messages.getText((String)"I18nPreferencePage.Activar");
            }
        }
        return "";
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 3;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 3 && Boolean.TRUE.equals(value)) {
            this.setSelectedLocale(rowIndex, columnIndex);
        }
    }

    public Locale getLocale(int rowIndex) {
        return rowIndex >= 0 ? this.locales[rowIndex] : null;
    }

    public void removeLocale(Locale locale) throws I18nException {
        int rowIndex = this.getLocaleRowIndex(locale);
        this.manager.uninstallLocale(locale);
        this.loadLocales();
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    public void reloadLocales() {
        this.loadLocales();
        this.fireTableDataChanged();
    }

    public void saveSelectedLocale() {
        this.manager.setCurrentLocale(this.getSelectedLocale());
        this.originalLocaleIndex = this.currentLocaleIndex;
    }

    public void selectPreviousLocale() {
        this.setSelectedLocale(this.originalLocaleIndex, 3);
    }

    public void selectDefaultLocale() {
        Locale defLocale = this.manager.getCurrentLocale();
        int pos = this.getLocaleRowIndex(defLocale);
        if (pos == -1) {
            defLocale = new Locale(defLocale.getLanguage());
            pos = this.getLocaleRowIndex(defLocale);
        }
        if (pos == -1) {
            pos = this.getLocaleRowIndex(I18nManager.ENGLISH);
        }
        this.setSelectedLocale(pos, 3);
    }

    public boolean isValueChanged() {
        return this.currentLocaleIndex != this.originalLocaleIndex;
    }

    public void setChangesApplied() {
        this.originalLocaleIndex = this.currentLocaleIndex;
    }

    public void setSelectedLocale(Locale locale) {
        int localeIndex = this.getLocaleRowIndex(locale);
        this.setSelectedLocale(localeIndex);
    }

    public Locale getSelectedLocale() {
        Locale selected = this.getLocale(this.currentLocaleIndex);
        return selected == null ? this.manager.getCurrentLocale() : selected;
    }

    private void setSelectedLocale(int rowIndex) {
        this.setSelectedLocale(rowIndex, 0);
    }

    private void setSelectedLocale(int rowIndex, int columnIndex) {
        int oldCurrentLocaleIndex = this.currentLocaleIndex;
        this.currentLocaleIndex = rowIndex;
        this.fireTableCellUpdated(oldCurrentLocaleIndex, columnIndex);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    private void loadLocales() {
        this.locales = this.manager.getInstalledLocales();
        Locale currentLocale = this.manager.getCurrentLocale();
        this.originalLocaleIndex = this.currentLocaleIndex = this.getLocaleRowIndex(currentLocale);
    }

    private int getLocaleRowIndex(Locale locale) {
        for (int i = 0; i < this.locales.length; ++i) {
            if (!locale.equals(this.locales[i])) continue;
            return i;
        }
        return -1;
    }
}

