/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.jdbc.swing.panels;

import javax.swing.JComponent;
import org.gvsig.export.jdbc.service.ExportJDBCParameters;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCConnectionPanel
implements ExportPanel {
    private static final long serialVersionUID = -3278172717881233447L;
    private static final Logger LOG = LoggerFactory.getLogger(JDBCConnectionPanel.class);
    private org.gvsig.fmap.dal.swing.jdbc.JDBCConnectionPanel connectionPanel;
    private final ExportJDBCParameters parameters;
    private final JExportProcessPanel processPanel;

    public JDBCConnectionPanel(JExportProcessPanel processPanel, ExportJDBCParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = parameters;
        this.initComponents();
    }

    private void initComponents() {
        DataSwingManager manager = DALSwingLocator.getSwingManager();
        this.connectionPanel = manager.createJDBCConnectionPanel();
    }

    public void previousPanel() {
    }

    public void enterPanel() {
        if (this.parameters.getExplorerParameters() != null) {
            this.connectionPanel.setServerExplorerParameters(this.parameters.getExplorerParameters());
        }
    }

    public JDBCServerExplorerParameters getServerExplorerParameters() {
        return this.connectionPanel.getServerExplorerParametersAndRegister();
    }

    public String getIdPanel() {
        return this.getClass().getCanonicalName();
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("connection_params");
    }

    public void nextPanel() {
        this.parameters.setExplorerParameters(this.getServerExplorerParameters());
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        JDBCServerExplorerParameters connection = this.connectionPanel.getServerExplorerParametersWithoutRegister();
        if (connection == null) {
            return false;
        }
        try {
            connection.validate();
            this.parameters.setExplorerParameters(connection);
            return true;
        }
        catch (ValidateDataParametersException ex) {
            throw new ExportPanelValidationException(ex.getMessageStack(), (Throwable)ex);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public JComponent asJComponent() {
        return this.connectionPanel.asJComponent();
    }
}

