/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.crs.CrsFactory;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.gui.panels.CrsAndTransformationRecentsPanel;
import org.gvsig.crs.gui.panels.CrsRecentsPanel;
import org.gvsig.crs.gui.panels.EPSGpanel;
import org.gvsig.crs.gui.panels.ESRIpanel;
import org.gvsig.crs.gui.panels.IAU2000panel;
import org.gvsig.crs.gui.panels.NewCRSPanel;
import org.gvsig.crs.gui.panels.NoAuthCRSpanel;

public class CRSMainPanel
extends JPanel
implements IWindow {
    private static final long serialVersionUID = 1L;
    private JComboBox jComboOptions = null;
    private JPanel Combopanel = null;
    private JPanel USGSpanel = null;
    final String recientes = PluginServices.getText((Object)this, (String)"recientes");
    final String epsg = PluginServices.getText((Object)this, (String)"EPSG");
    final String usgs = PluginServices.getText((Object)this, (String)"USGS");
    final String esri = PluginServices.getText((Object)this, (String)"ESRI");
    final String noAuth = PluginServices.getText((Object)this, (String)"CRS");
    final String iau2000 = PluginServices.getText((Object)this, (String)"IAU2000");
    final String newCRS = PluginServices.getText((Object)this, (String)"newCRS");
    String[] selection = new String[]{this.recientes, this.epsg, this.noAuth, this.esri, this.iau2000, this.newCRS};
    boolean inAnApplet = true;
    public CrsRecentsPanel crsRecentsPanel = null;
    public CrsAndTransformationRecentsPanel crsAndTransformationRecentsPanel = null;
    public EPSGpanel epsgPanel = null;
    public NoAuthCRSpanel noAuthPanel = null;
    public ESRIpanel esriPanel = null;
    public IAU2000panel iauPanel = null;
    public NewCRSPanel newCrsPanel = null;
    private JPanel jPanelMain = null;
    private JPanel jPanelButtons;
    private JButton jButtonAccept;
    private JButton jButonCancel;
    private ICrs viewCrs;
    String dataSource = "";

    public CRSMainPanel(ICrs crs) {
        CrsFactory.initializeDatabaseInbackground();
        this.viewCrs = crs;
        this.crsRecentsPanel = new CrsRecentsPanel();
        this.epsgPanel = new EPSGpanel();
        this.noAuthPanel = new NoAuthCRSpanel();
        this.esriPanel = new ESRIpanel();
        this.iauPanel = new IAU2000panel();
        this.newCrsPanel = new NewCRSPanel(this.viewCrs);
        this.setLayout(new BorderLayout());
        this.add((Component)this.vista(), "North");
        this.add((Component)this.getJPanelButtons(), "South");
        this.setDataSource(this.selection[0]);
    }

    public CRSMainPanel(int target, ICrs crs) {
        this.viewCrs = crs;
        this.crsAndTransformationRecentsPanel = new CrsAndTransformationRecentsPanel();
        this.epsgPanel = new EPSGpanel();
        this.noAuthPanel = new NoAuthCRSpanel();
        this.esriPanel = new ESRIpanel();
        this.iauPanel = new IAU2000panel();
        this.newCrsPanel = new NewCRSPanel(this.viewCrs);
        this.setDataSource(this.selection[0]);
    }

    public JPanel capa() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)this.getCombopanel(), "North");
        p.add((Component)this.getJPanelLayerMain(), "Center");
        return p;
    }

    public JPanel vista() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)this.getCombopanel(), "North");
        p.add((Component)this.getJPanelMain(), "Center");
        return p;
    }

    public JPanel getJPanelMain() {
        if (this.jPanelMain == null) {
            this.jPanelMain = new JPanel();
            this.jPanelMain.setLayout(new CardLayout());
            this.jPanelMain.setPreferredSize(new Dimension(525, 230));
            this.jPanelMain.add(this.recientes, this.crsRecentsPanel);
            this.jPanelMain.add(this.epsg, this.epsgPanel);
            this.jPanelMain.add(this.newCRS, this.newCrsPanel);
            this.jPanelMain.add(this.noAuth, this.noAuthPanel);
            this.jPanelMain.add(this.esri, this.esriPanel);
            this.jPanelMain.add(this.usgs, this.getJPanelUSGS());
            this.jPanelMain.add(this.iau2000, this.iauPanel);
        }
        return this.jPanelMain;
    }

    public JPanel getJPanelLayerMain() {
        if (this.jPanelMain == null) {
            this.jPanelMain = new JPanel();
            this.jPanelMain.setLayout(new CardLayout());
            this.jPanelMain.setPreferredSize(new Dimension(525, 230));
            this.jPanelMain.add(this.recientes, this.crsAndTransformationRecentsPanel);
            this.jPanelMain.add(this.epsg, this.epsgPanel);
            this.jPanelMain.add(this.newCRS, this.newCrsPanel);
            this.jPanelMain.add(this.noAuth, this.noAuthPanel);
            this.jPanelMain.add(this.esri, this.esriPanel);
            this.jPanelMain.add(this.usgs, this.getJPanelUSGS());
            this.jPanelMain.add(this.iau2000, this.iauPanel);
        }
        return this.jPanelMain;
    }

    public JPanel getCombopanel() {
        if (this.Combopanel == null) {
            this.Combopanel = new JPanel();
            this.Combopanel.setLayout(new FlowLayout(1, 10, 5));
            this.Combopanel.add(this.getJLabelTipo());
            this.Combopanel.add(this.getJComboOptions());
        }
        return this.Combopanel;
    }

    private JLabel getJLabelTipo() {
        JLabel jLabelTipo = new JLabel();
        jLabelTipo.setPreferredSize(new Dimension(50, 25));
        jLabelTipo.setText(PluginServices.getText((Object)this, (String)"tipo") + ":");
        return jLabelTipo;
    }

    public JComboBox getJComboOptions() {
        if (this.jComboOptions == null) {
            this.jComboOptions = new JComboBox<String>(this.selection);
            this.jComboOptions.setPreferredSize(new Dimension(100, 25));
            this.jComboOptions.setEditable(false);
            this.jComboOptions.setSelectedIndex(0);
        }
        return this.jComboOptions;
    }

    public JPanel getJPanelUSGS() {
        if (this.USGSpanel == null) {
            this.USGSpanel = new JPanel();
            this.USGSpanel.setLayout(new GridLayout(3, 4));
            this.USGSpanel.setLayout(new FlowLayout(0, 10, 10));
            this.USGSpanel.setPreferredSize(new Dimension(525, 400));
        }
        return this.USGSpanel;
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelButtons == null) {
            this.jPanelButtons = new JPanel();
            this.jPanelButtons.setLayout(new FlowLayout(2));
            this.jPanelButtons.add((Component)this.getJButtonCancel(), null);
            this.jPanelButtons.add((Component)this.getJButtonAccept(), null);
        }
        return this.jPanelButtons;
    }

    public JButton getJButtonCancel() {
        if (this.jButonCancel == null) {
            this.jButonCancel = new JButton();
            this.jButonCancel.setText(PluginServices.getText((Object)this, (String)"cancel"));
            this.jButonCancel.setPreferredSize(new Dimension(100, 25));
            this.jButonCancel.setMnemonic('C');
            this.jButonCancel.setToolTipText("Cancel");
        }
        return this.jButonCancel;
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        PluginServices.getMDIManager().closeWindow((IWindow)this);
    }

    public JButton getJButtonAccept() {
        if (this.jButtonAccept == null) {
            this.jButtonAccept = new JButton();
            this.jButtonAccept.setText(PluginServices.getText((Object)this, (String)"ok"));
            this.jButtonAccept.setPreferredSize(new Dimension(100, 25));
            this.jButtonAccept.setEnabled(false);
            this.jButtonAccept.setMnemonic('A');
            this.jButtonAccept.setToolTipText(PluginServices.getText((Object)this, (String)"ok"));
        }
        return this.jButtonAccept;
    }

    public ICrs getProjection() {
        if (this.getDataSource().equals(PluginServices.getText((Object)this, (String)"EPSG"))) {
            return this.epsgPanel.getProjection();
        }
        if (this.getDataSource().equals(PluginServices.getText((Object)this, (String)"IAU2000"))) {
            return this.iauPanel.getProjection();
        }
        if (this.getDataSource().equals(PluginServices.getText((Object)this, (String)"recientes"))) {
            return this.crsRecentsPanel.getProjection();
        }
        if (this.getDataSource().equals(PluginServices.getText((Object)this, (String)"CRS"))) {
            return this.noAuthPanel.getProjection();
        }
        if (this.getDataSource().equals(PluginServices.getText((Object)this, (String)"ESRI"))) {
            return this.esriPanel.getProjection();
        }
        if (this.getDataSource().equals(PluginServices.getText((Object)this, (String)"newCRS"))) {
            return this.newCrsPanel.getProjection();
        }
        return null;
    }

    public void setProjection(IProjection crs) {
    }

    public void setDataSource(String sour) {
        this.dataSource = sour;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(8);
        m_viewinfo.setTitle(PluginServices.getText((Object)this, (String)"seleccionar_crs"));
        return m_viewinfo;
    }

    public EPSGpanel getEpsgPanel() {
        return this.epsgPanel;
    }

    public NoAuthCRSpanel getNoAuthPanel() {
        return this.noAuthPanel;
    }

    public ESRIpanel getEsriPanel() {
        return this.esriPanel;
    }

    public IAU2000panel getIauPanel() {
        return this.iauPanel;
    }

    public CrsRecentsPanel getRecentsPanel() {
        return this.crsRecentsPanel;
    }

    public CrsAndTransformationRecentsPanel getCrsAndTransformationRecentsPanel() {
        return this.crsAndTransformationRecentsPanel;
    }

    public NewCRSPanel getNewCrsPanel() {
        return this.newCrsPanel;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }
}

