/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.TableSorter;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.CrsFactory;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.gui.panels.InfoCRSPanel;
import org.gvsig.crs.gui.panels.NewCRSPanel;
import org.gvsig.crs.persistence.CrsData;
import org.gvsig.crs.persistence.RecentCRSsPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrsRecentsPanel
extends JPanel
implements ActionListener {
    public static final Logger logger = LoggerFactory.getLogger(CrsRecentsPanel.class);
    private static final long serialVersionUID = 1L;
    public JTable jTable = null;
    private JScrollPane jScrollPane = null;
    private JButton infoCrs = null;
    public DefaultTableModel dtm = null;
    public TableSorter sorter = null;
    private CrsData[] crsDataArray = null;
    public int selectedRowTable = -1;
    private String authority = null;
    private int codeCRS = -1;
    private ICrs crs = null;

    public CrsRecentsPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new FlowLayout(0, 15, 15));
        p.add(this.getJLabel());
        this.add((Component)p, "North");
        this.add((Component)this.getJScrollPane(), "Center");
        JPanel pSouth = new JPanel(new FlowLayout(2, 5, 5));
        pSouth.add(this.getInfoCrs());
        this.add((Component)pSouth, "South");
    }

    private JLabel getJLabel() {
        JLabel label = new JLabel();
        label.setText(PluginServices.getText((Object)this, (String)"ultimos_crs_utilizados") + ":");
        return label;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), this.jScrollPane.getBorder()));
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    public JTable getJTable() {
        if (this.jTable == null) {
            Object[] columnNames = new String[]{PluginServices.getText((Object)this, (String)"repository"), PluginServices.getText((Object)this, (String)"codigo"), PluginServices.getText((Object)this, (String)"nombre")};
            Object[][] data = new Object[][]{};
            this.dtm = new DefaultTableModel(data, columnNames){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }

                public Class getColumnClass(int column) {
                    return this.getValueAt(0, column).getClass();
                }
            };
            this.sorter = new TableSorter((TableModel)this.dtm);
            this.jTable = new JTable((TableModel)this.sorter);
            this.sorter.setTableHeader(this.jTable.getTableHeader());
            this.jTable.setCellSelectionEnabled(false);
            this.jTable.setRowSelectionAllowed(true);
            this.jTable.setColumnSelectionAllowed(false);
            this.jTable.setSelectionMode(0);
            TableColumn column = null;
            for (int i = 0; i < 3; ++i) {
                column = this.jTable.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(80);
                    continue;
                }
                if (i == 2) {
                    column.setPreferredWidth(275);
                    continue;
                }
                column.setPreferredWidth(140);
            }
        }
        return this.jTable;
    }

    public JButton getInfoCrs() {
        if (this.infoCrs == null) {
            this.infoCrs = new JButton();
            this.infoCrs.setPreferredSize(new Dimension(85, 20));
            this.infoCrs.setText(PluginServices.getText((Object)this, (String)"infocrs"));
            this.infoCrs.setMnemonic('I');
            this.infoCrs.setEnabled(false);
            this.infoCrs.setToolTipText(PluginServices.getText((Object)this, (String)"more_info"));
            this.infoCrs.addActionListener(this);
        }
        return this.infoCrs;
    }

    public ICrs getProjection() {
        return this.crs;
    }

    public void setCodeCRS(int code) {
        this.codeCRS = code;
    }

    public int getCodeCRS() {
        return this.codeCRS;
    }

    public void setProjection(IProjection crs) {
    }

    public void loadRecents() {
        int numRow = this.dtm.getRowCount();
        while (numRow != 0) {
            this.dtm.removeRow(--numRow);
        }
        RecentCRSsPersistence persistence = new RecentCRSsPersistence();
        this.crsDataArray = persistence.getArrayOfCrsData();
        boolean available = true;
        for (int iRow = this.crsDataArray.length - 1; iRow >= 0; --iRow) {
            if (this.crsDataArray[iRow].getAuthority() == null) continue;
            Object[] row = new Object[]{this.crsDataArray[iRow].getAuthority(), Integer.toString(this.crsDataArray[iRow].getCode()), this.crsDataArray[iRow].getName()};
            if (this.crsDataArray[iRow].getAuthority().equals(PluginServices.getText((Object)this, (String)"USR"))) {
                available = this.isUSR(this.crsDataArray[iRow].getCode());
            }
            if (available) {
                this.dtm.addRow(row);
                continue;
            }
            available = true;
        }
        int numr = this.dtm.getRowCount();
        if (numr != 0) {
            this.getJTable().setRowSelectionInterval(0, 0);
        }
    }

    public boolean isUSR(int code) {
        NewCRSPanel usr = new NewCRSPanel();
        return usr.isInBD(code);
    }

    public ICrs getCrs() {
        return this.crs;
    }

    public void initCrs() {
        this.selectedRowTable = this.getJTable().getSelectedRow();
        Integer.parseInt((String)this.sorter.getValueAt(this.selectedRowTable, 1));
        this.setAuthority((String)this.sorter.getValueAt(this.selectedRowTable, 0) + ":" + (String)this.sorter.getValueAt(this.selectedRowTable, 1));
        this.codeCRS = Integer.parseInt((String)this.sorter.getValueAt(this.selectedRowTable, 1));
        try {
            this.crs = new CrsFactory().getCRS(this.getAuthority());
        }
        catch (CrsException e) {
            logger.error("Can't create CRS from authority (" + this.authority + ").", (Throwable)e);
        }
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String aut) {
        this.authority = aut;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getInfoCrs()) {
            String[] aut = this.getAuthority().split(":");
            InfoCRSPanel info = new InfoCRSPanel(aut[0], this.getCodeCRS());
            PluginServices.getMDIManager().addWindow((IWindow)info);
        }
    }
}

