/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.gui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.gvsig.andami.PluginServices;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.CrsFactory;
import org.gvsig.crs.CrsWkt;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.persistence.RecentTrsPersistence;
import org.gvsig.crs.persistence.TrData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationManualPanel
extends JPanel {
    public static final Logger logger = LoggerFactory.getLogger(TransformationManualPanel.class);
    private static final long serialVersionUID = 1L;
    private static boolean pressed = true;
    private JLabel x_Translation;
    private JLabel y_Translation;
    private JLabel z_Translation;
    private JLabel x_Rotation;
    private JLabel y_Rotation;
    private JLabel z_Rotation;
    private JLabel scale;
    private JTextField tx_Translation;
    private JTextField ty_Translation;
    private JTextField tz_Translation;
    private JTextField tx_Rotation;
    private JTextField ty_Rotation;
    private JTextField tz_Rotation;
    private JTextField tScale;
    private JLabel domainTranslation;
    private JLabel domainRotation;
    private JLabel domainScale;
    private JTextArea info;
    int codeEpsg;
    String targetAbrev = "";
    String sourceAbrev = "";
    String[] targetAuthority;
    private String cadWKT = "";

    public TransformationManualPanel() {
        this.initialize();
    }

    private void initialize() {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(7, 3, 10, 10));
        p.add(this.getX_Translation());
        p.add(this.getTx_Translation());
        p.add(this.getDomainTranslation());
        p.add(this.getY_Translation());
        p.add(this.getTy_Translation());
        p.add(this.getDomainTranslation());
        p.add(this.getZ_Translation());
        p.add(this.getTz_Translation());
        p.add(this.getDomainTranslation());
        p.add(this.getX_Rotation());
        p.add(this.getTx_Rotation());
        p.add(this.getDomainRotation());
        p.add(this.getY_Rotation());
        p.add(this.getTy_Rotation());
        p.add(this.getDomainRotation());
        p.add(this.getZ_Rotation());
        p.add(this.getTz_Rotation());
        p.add(this.getDomainRotation());
        p.add(this.getScale());
        p.add(this.getTscale());
        p.add(this.getDomainScale());
        p.setBorder(new EmptyBorder(50, 20, 50, 10));
        this.setLayout(new BorderLayout(1, 30));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(PluginServices.getText((Object)this, (String)"transformacion_manual")), BorderFactory.createEmptyBorder(2, 2, 2, 2)), this.getBorder()));
        this.add((Component)p, "Center");
    }

    private JLabel getDomainTranslation() {
        this.domainTranslation = new JLabel();
        this.domainTranslation.setText("[-1000.0, 1000.0]");
        return this.domainTranslation;
    }

    private JLabel getDomainRotation() {
        this.domainRotation = new JLabel();
        this.domainRotation.setText("[-60.0, 60.0]");
        return this.domainRotation;
    }

    private JLabel getDomainScale() {
        this.domainScale = new JLabel();
        this.domainScale.setText("[-20.0, 20.0]");
        return this.domainScale;
    }

    private JLabel getX_Translation() {
        if (this.x_Translation == null) {
            this.x_Translation = new JLabel();
            this.x_Translation.setText(PluginServices.getText((Object)this, (String)"x_Translation") + ":");
        }
        return this.x_Translation;
    }

    private JLabel getY_Translation() {
        if (this.y_Translation == null) {
            this.y_Translation = new JLabel();
            this.y_Translation.setText(PluginServices.getText((Object)this, (String)"y_Translation") + ":");
        }
        return this.y_Translation;
    }

    private JLabel getZ_Translation() {
        if (this.z_Translation == null) {
            this.z_Translation = new JLabel();
            this.z_Translation.setText(PluginServices.getText((Object)this, (String)"z_Translation") + ":");
        }
        return this.z_Translation;
    }

    private JLabel getX_Rotation() {
        if (this.x_Rotation == null) {
            this.x_Rotation = new JLabel();
            this.x_Rotation.setText(PluginServices.getText((Object)this, (String)"x_Rotation") + ":");
        }
        return this.x_Rotation;
    }

    private JLabel getY_Rotation() {
        if (this.y_Rotation == null) {
            this.y_Rotation = new JLabel();
            this.y_Rotation.setText(PluginServices.getText((Object)this, (String)"y_Rotation") + ":");
        }
        return this.y_Rotation;
    }

    private JLabel getZ_Rotation() {
        if (this.z_Rotation == null) {
            this.z_Rotation = new JLabel();
            this.z_Rotation.setText(PluginServices.getText((Object)this, (String)"z_Rotation") + ":");
        }
        return this.z_Rotation;
    }

    private JLabel getScale() {
        if (this.scale == null) {
            this.scale = new JLabel();
            this.scale.setText(PluginServices.getText((Object)this, (String)"scale_factor_ppm") + ":");
        }
        return this.scale;
    }

    public JTextField getTx_Translation() {
        if (this.tx_Translation == null) {
            this.tx_Translation = new JTextField();
            this.tx_Translation.setText("0");
            this.tx_Translation.setEditable(true);
        }
        return this.tx_Translation;
    }

    public JTextField getTy_Translation() {
        if (this.ty_Translation == null) {
            this.ty_Translation = new JTextField();
            this.ty_Translation.setText("0");
            this.ty_Translation.setEditable(true);
        }
        return this.ty_Translation;
    }

    public JTextField getTz_Translation() {
        if (this.tz_Translation == null) {
            this.tz_Translation = new JTextField();
            this.tz_Translation.setText("0");
            this.tz_Translation.setEditable(true);
        }
        return this.tz_Translation;
    }

    public JTextField getTx_Rotation() {
        if (this.tx_Rotation == null) {
            this.tx_Rotation = new JTextField();
            this.tx_Rotation.setText("0");
            this.tx_Rotation.setEditable(true);
        }
        return this.tx_Rotation;
    }

    public JTextField getTy_Rotation() {
        if (this.ty_Rotation == null) {
            this.ty_Rotation = new JTextField();
            this.ty_Rotation.setText("0");
            this.ty_Rotation.setEditable(true);
        }
        return this.ty_Rotation;
    }

    public JTextField getTz_Rotation() {
        if (this.tz_Rotation == null) {
            this.tz_Rotation = new JTextField();
            this.tz_Rotation.setText("0");
            this.tz_Rotation.setEditable(true);
        }
        return this.tz_Rotation;
    }

    public JTextField getTscale() {
        if (this.tScale == null) {
            this.tScale = new JTextField();
            this.tScale.setText("0");
            this.tScale.setEditable(true);
        }
        return this.tScale;
    }

    public ICrs getProjection() {
        if (this.tx_Translation.getText().equals("")) {
            this.tx_Translation.setText("0");
        } else if (this.ty_Translation.getText().equals("")) {
            this.ty_Translation.setText("0");
        } else if (this.tz_Translation.getText().equals("")) {
            this.tz_Translation.setText("0");
        } else if (this.tx_Rotation.getText().equals("")) {
            this.tx_Rotation.setText("0");
        } else if (this.ty_Rotation.getText().equals("")) {
            this.ty_Rotation.setText("0");
        } else if (this.tz_Rotation.getText().equals("")) {
            this.tz_Rotation.setText("0");
        } else if (this.tScale.getText().equals("")) {
            this.tScale.setText("0");
        }
        String param = "+towgs84=" + this.tx_Translation.getText() + "," + this.ty_Translation.getText() + "," + this.tz_Translation.getText() + "," + this.tx_Rotation.getText() + "," + this.ty_Rotation.getText() + "," + this.tz_Rotation.getText() + "," + this.tScale.getText() + " ";
        String[] sourceAuthority = this.getSourceAbrev().split(":");
        try {
            ICrs crs = new CrsFactory().getCRS(sourceAuthority[0] + ":" + this.getCode(), param, null);
            return crs;
        }
        catch (CrsException e) {
            logger.info("Can't create CRS with authority '" + sourceAuthority[0] + "', code " + this.getCode() + " and transformation params '" + param + "'.", (Throwable)e);
            return null;
        }
    }

    public void setCode(int cod) {
        this.codeEpsg = cod;
    }

    public int getCode() {
        return this.codeEpsg;
    }

    public void setWKT(String cad) {
        this.cadWKT = cad;
        CrsWkt parser = new CrsWkt(cad);
        this.setSourceAbrev(parser.getAuthority()[0], parser.getAuthority()[1]);
    }

    public void setWKT(ICrs crs) {
        this.cadWKT = crs.getWKT();
        this.setSourceAbrev(crs.getCrsWkt().getAuthority()[0], crs.getCrsWkt().getAuthority()[1]);
    }

    public String getWKT() {
        return this.cadWKT;
    }

    public static boolean isPressed() {
        return pressed;
    }

    public boolean correctJTextField() {
        boolean correct = true;
        if (this.tx_Translation.getText().length() == 0 || this.tx_Translation.getText().length() != this.verify(this.tx_Translation.getText()).length()) {
            this.tx_Translation.setText("0");
            this.tx_Translation.setBackground(new Color(255, 204, 204));
            correct = false;
        } else {
            this.tx_Translation.setBackground(new Color(255, 255, 255));
        }
        if (this.ty_Translation.getText().length() == 0 || this.ty_Translation.getText().length() != this.verify(this.ty_Translation.getText()).length()) {
            this.ty_Translation.setText("0");
            this.ty_Translation.setBackground(new Color(255, 204, 204));
            correct = false;
        } else {
            this.ty_Translation.setBackground(new Color(255, 255, 255));
        }
        if (this.tz_Translation.getText().length() == 0 || this.tz_Translation.getText().length() != this.verify(this.tz_Translation.getText()).length()) {
            this.tz_Translation.setText("0");
            this.tz_Translation.setBackground(new Color(255, 204, 204));
            correct = false;
        } else {
            this.tz_Translation.setBackground(new Color(255, 255, 255));
        }
        if (this.tx_Rotation.getText().length() == 0 || this.tx_Rotation.getText().length() != this.verify(this.tx_Rotation.getText()).length()) {
            this.tx_Rotation.setText("0");
            this.tx_Rotation.setBackground(new Color(255, 204, 204));
            correct = false;
        } else {
            this.tx_Rotation.setBackground(new Color(255, 255, 255));
        }
        if (this.ty_Rotation.getText().length() == 0 || this.ty_Rotation.getText().length() != this.verify(this.ty_Rotation.getText()).length()) {
            this.ty_Rotation.setText("0");
            this.ty_Rotation.setBackground(new Color(255, 204, 204));
            correct = false;
        } else {
            this.ty_Rotation.setBackground(new Color(255, 255, 255));
        }
        if (this.tz_Rotation.getText().length() == 0 || this.tz_Rotation.getText().length() != this.verify(this.tz_Rotation.getText()).length()) {
            this.tz_Rotation.setText("0");
            this.tz_Rotation.setBackground(new Color(255, 204, 204));
            correct = false;
        } else {
            this.tz_Rotation.setBackground(new Color(255, 255, 255));
        }
        if (this.tScale.getText().length() == 0 || this.tScale.getText().length() != this.verify(this.tScale.getText()).length()) {
            this.tScale.setText("0");
            this.tScale.setBackground(new Color(255, 204, 204));
            correct = false;
        } else {
            this.tScale.setBackground(new Color(255, 255, 255));
        }
        return correct;
    }

    private String verify(String cad) {
        String num_cad = "";
        int pto = 0;
        char[] nums = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        if (cad.startsWith("-")) {
            num_cad = num_cad + "-";
        }
        for (int i = 0; i < cad.length(); ++i) {
            if (cad.charAt(i) == '.') {
                if (cad.startsWith(".") || cad.endsWith(".") || pto > 0) continue;
                ++pto;
                num_cad = num_cad + cad.charAt(i);
                continue;
            }
            for (int j = 0; j < nums.length; ++j) {
                if (cad.charAt(i) != nums[j]) continue;
                num_cad = num_cad + cad.charAt(i);
            }
        }
        return num_cad;
    }

    public boolean correctDomain() {
        boolean correctDomain = true;
        double tx = Double.parseDouble(this.tx_Translation.getText());
        double ty = Double.parseDouble(this.ty_Translation.getText());
        double tz = Double.parseDouble(this.tz_Translation.getText());
        double rx = Double.parseDouble(this.tx_Rotation.getText());
        double ry = Double.parseDouble(this.ty_Rotation.getText());
        double rz = Double.parseDouble(this.tz_Rotation.getText());
        double sc = Double.parseDouble(this.tScale.getText());
        if (tx < -1000.0 || tx > 1000.0) {
            this.tx_Translation.setText("0");
            this.tx_Translation.setBackground(new Color(255, 204, 204));
            correctDomain = false;
        } else {
            this.tx_Translation.setBackground(new Color(255, 255, 255));
        }
        if (ty < -1000.0 || ty > 1000.0) {
            this.ty_Translation.setText("0");
            this.ty_Translation.setBackground(new Color(255, 204, 204));
            correctDomain = false;
        } else {
            this.ty_Translation.setBackground(new Color(255, 255, 255));
        }
        if (tz < -1000.0 || tz > 1000.0) {
            this.tz_Translation.setText("0");
            this.tz_Translation.setBackground(new Color(255, 204, 204));
            correctDomain = false;
        } else {
            this.tz_Translation.setBackground(new Color(255, 255, 255));
        }
        if (rx < -60.0 || rx > 60.0) {
            this.tx_Rotation.setText("0");
            this.tx_Rotation.setBackground(new Color(255, 204, 204));
            correctDomain = false;
        } else {
            this.tx_Rotation.setBackground(new Color(255, 255, 255));
        }
        if (ry < -60.0 || ry > 60.0) {
            this.ty_Rotation.setText("0");
            this.ty_Rotation.setBackground(new Color(255, 204, 204));
            correctDomain = false;
        } else {
            this.ty_Rotation.setBackground(new Color(255, 255, 255));
        }
        if (rz < -60.0 || rz > 60.0) {
            this.tz_Rotation.setText("0");
            this.tz_Rotation.setBackground(new Color(255, 204, 204));
            correctDomain = false;
        } else {
            this.tz_Rotation.setBackground(new Color(255, 255, 255));
        }
        if (sc < -20.0 || sc > 20.0) {
            this.tScale.setText("0");
            this.tScale.setBackground(new Color(255, 204, 204));
            correctDomain = false;
        } else {
            this.tScale.setBackground(new Color(255, 255, 255));
        }
        return correctDomain;
    }

    public boolean getStatus() {
        if ((this.tx_Translation.getText().equals("0") || this.tx_Translation.getText().equals("")) && (this.ty_Translation.getText().equals("0") || this.ty_Translation.getText().equals("")) && (this.tz_Translation.getText().equals("0") || this.tz_Translation.getText().equals("")) && (this.tx_Rotation.getText().equals("0") || this.tx_Rotation.getText().equals("")) && (this.ty_Rotation.getText().equals("0") || this.ty_Rotation.getText().equals("")) && (this.tz_Rotation.getText().equals("0") || this.tz_Rotation.getText().equals("")) && (this.tScale.getText().equals("0") || this.tScale.getText().equals(""))) {
            return false;
        }
        return !this.tx_Translation.getText().equals("") && !this.ty_Translation.getText().equals("") && !this.tz_Translation.getText().equals("") && !this.tx_Rotation.getText().equals("") && !this.ty_Rotation.getText().equals("") && !this.tz_Rotation.getText().equals("") && !this.tScale.getText().equals("");
    }

    public void setTargetAuthority(String[] authority) {
        this.targetAuthority = authority;
        this.setTargetAbrev(this.targetAuthority[0], this.targetAuthority[1]);
    }

    public void setTargetAbrev(String fuente, String codigo) {
        this.targetAbrev = fuente + ":" + codigo;
    }

    public String getTargetAbrev() {
        return this.targetAbrev;
    }

    public void setSourceAbrev(String fuente, String codigo) {
        this.sourceAbrev = fuente + ":" + codigo;
    }

    public String getSourceAbrev() {
        return this.sourceAbrev;
    }

    public String getValues() {
        return "[" + this.tx_Translation.getText() + "," + this.ty_Translation.getText() + "," + this.tz_Translation.getText() + "," + this.tx_Rotation.getText() + "," + this.ty_Rotation.getText() + "," + this.tz_Rotation.getText() + "," + this.tScale.getText() + "]";
    }

    public void fillData(String details) {
        RecentTrsPersistence trPersistence = new RecentTrsPersistence();
        TrData[] crsTrDataArray = trPersistence.getArrayOfTrData();
        for (int iRow = crsTrDataArray.length - 1; iRow >= 0; --iRow) {
            if (!details.equals(crsTrDataArray[iRow].getAuthority() + ":" + crsTrDataArray[iRow].getCode() + " <--> " + crsTrDataArray[iRow].getDetails()) || !crsTrDataArray[iRow].getAuthority().equals(PluginServices.getText((Object)this, (String)"USR"))) continue;
            String data = crsTrDataArray[iRow].getDetails();
            data = data.trim().substring(1, data.length() - 1);
            String[] values = data.split(",");
            this.tx_Translation.setText(values[0]);
            this.ty_Translation.setText(values[1]);
            this.tz_Translation.setText(values[2]);
            this.tx_Rotation.setText(values[3]);
            this.ty_Rotation.setText(values[4]);
            this.tz_Rotation.setText(values[5]);
            this.tScale.setText(values[6]);
            break;
        }
    }

    public void resetData() {
        this.tx_Translation.setText("0");
        this.ty_Translation.setText("0");
        this.tz_Translation.setText("0");
        this.tx_Rotation.setText("0");
        this.ty_Rotation.setText("0");
        this.tz_Rotation.setText("0");
        this.tScale.setText("0");
    }
}

