/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.gui.panels.wizard;

import es.idr.teledeteccion.connection.EpsgConnection;
import es.idr.teledeteccion.connection.Query;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.geotools.referencing.wkt.Parser;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.CrsFactory;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.gui.panels.wizard.DefCrsUsr;
import org.gvsig.crs.gui.panels.wizard.DefSistCoordenadas;
import org.gvsig.crs.gui.panels.wizard.DefinirDatum;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainPanel
extends JPanel
implements ActionListener,
ChangeListener,
IWindow {
    public static final Logger logger = LoggerFactory.getLogger(MainPanel.class);
    private static final long serialVersionUID = 1L;
    private JTabbedPane pCard;
    private JPanel pSouth;
    private JButton btnCancelar;
    private JButton btnSiguiente;
    private JButton btnAnterior;
    private JButton btnFinalizar;
    private DefCrsUsr pCrsUsr;
    private DefinirDatum pDatum;
    private DefSistCoordenadas pSistCoord;
    private ICrs currentCrs;
    private String cadWkt = "";
    private int newCrsCode = -1;
    private boolean edit = false;

    public MainPanel(ICrs crs) {
        this.setCrs(crs);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPCard(), "Center");
        this.add((Component)this.getPSouth(), "South");
        this.getPCrsUsr().getRbCadenaWkt().addActionListener(this);
        this.getPCrsUsr().getRbCrsExistente().addActionListener(this);
        this.getPCrsUsr().getRbNuevoCrs().addActionListener(this);
    }

    public JButton getBtnAnterior() {
        if (this.btnAnterior == null) {
            this.btnAnterior = new JButton();
            this.btnAnterior.setText(PluginServices.getText((Object)this, (String)"wz_anterior"));
            this.btnAnterior.addActionListener(this);
        }
        return this.btnAnterior;
    }

    public JButton getBtnCancelar() {
        if (this.btnCancelar == null) {
            this.btnCancelar = new JButton();
            this.btnCancelar.setText(PluginServices.getText((Object)this, (String)"wz_cancel"));
            this.btnCancelar.addActionListener(this);
        }
        return this.btnCancelar;
    }

    public JButton getBtnFinalizar() {
        if (this.btnFinalizar == null) {
            this.btnFinalizar = new JButton();
            this.btnFinalizar.setText(PluginServices.getText((Object)this, (String)"wz_fin"));
            this.btnFinalizar.addActionListener(this);
        }
        return this.btnFinalizar;
    }

    public JButton getBtnSiguiente() {
        if (this.btnSiguiente == null) {
            this.btnSiguiente = new JButton();
            this.btnSiguiente.setText(PluginServices.getText((Object)this, (String)"wz_siguiente"));
            this.btnSiguiente.addActionListener(this);
        }
        return this.btnSiguiente;
    }

    public JTabbedPane getPCard() {
        if (this.pCard == null) {
            this.pCard = new JTabbedPane();
            this.pCard.addTab(PluginServices.getText((Object)this, (String)"crs_usuario"), this.getPCrsUsr());
            this.pCard.addTab(PluginServices.getText((Object)this, (String)"Dat_nDatum"), this.getPDatum());
            this.pCard.addTab(PluginServices.getText((Object)this, (String)"SistCoor_titmarco"), this.getPSistCoord());
            this.pCard.setSelectedIndex(0);
            this.pCard.addChangeListener(this);
        }
        return this.pCard;
    }

    public JPanel getPSouth() {
        if (this.pSouth == null) {
            this.pSouth = new JPanel();
            this.pSouth.setLayout(new FlowLayout(2, 5, 5));
            this.pSouth.add(this.getBtnCancelar());
            this.pSouth.add(this.getBtnAnterior());
            this.pSouth.add(this.getBtnSiguiente());
            this.pSouth.add(this.getBtnFinalizar());
            this.getBtnFinalizar().setVisible(false);
            this.getBtnAnterior().setVisible(false);
        }
        return this.pSouth;
    }

    public DefCrsUsr getPCrsUsr() {
        if (this.pCrsUsr == null) {
            this.pCrsUsr = new DefCrsUsr(this.getCrs());
        }
        return this.pCrsUsr;
    }

    public DefinirDatum getPDatum() {
        if (this.pDatum == null) {
            this.pDatum = new DefinirDatum();
        }
        return this.pDatum;
    }

    public DefSistCoordenadas getPSistCoord() {
        if (this.pSistCoord == null) {
            this.pSistCoord = new DefSistCoordenadas();
        }
        return this.pSistCoord;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.getBtnAnterior())) {
            this.getBtnFinalizar().setVisible(false);
            this.getBtnSiguiente().setVisible(true);
            if (this.getPSistCoord().isShowing() && this.isEditing()) {
                this.getBtnAnterior().setVisible(false);
            }
            if (this.getPDatum().isShowing()) {
                this.getBtnAnterior().setVisible(false);
                if (this.getPCrsUsr().getRbCadenaWkt().isSelected()) {
                    this.getBtnFinalizar().setVisible(true);
                }
                this.getPCard().setSelectedComponent(this.getPCrsUsr());
            } else if (this.getPSistCoord().isShowing()) {
                this.getPCard().setSelectedComponent(this.getPDatum());
            }
        } else if (e.getSource().equals(this.getBtnSiguiente())) {
            if (this.getPCrsUsr().isShowing() && this.getPCrsUsr().getRbCrsExistente().isSelected()) {
                this.getBtnFinalizar().setVisible(false);
                ICrs crs = this.getPCrsUsr().getCrs();
                if (crs != null) {
                    this.fillData(crs);
                } else {
                    this.fillData(this.getCrs());
                }
            } else if (this.getPCrsUsr().isShowing() && this.getPCrsUsr().getRbNuevoCrs().isSelected()) {
                this.getBtnFinalizar().setVisible(false);
                this.cleanData();
            } else if (this.getPCrsUsr().isShowing() && this.getPCrsUsr().getRbCadenaWkt().isSelected()) {
                if (this.getPCrsUsr().getTxtAreaWkt().getText().equals("")) {
                    JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"white_Textbox"), "Warning...", 2);
                    return;
                }
                CoordinateReferenceSystem crs = null;
                String wkt = this.getPCrsUsr().getTxtAreaWkt().getText();
                Parser parser = new Parser();
                try {
                    crs = parser.parseCoordinateReferenceSystem(wkt);
                }
                catch (ParseException e1) {
                    JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"problem_with_wkt_try_manually"), "Warning...", 2);
                    return;
                }
                catch (UnsupportedOperationException e2) {
                    JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"problem_with_wkt_try_manually"), "Warning...", 2);
                    return;
                }
                this.fillData(crs);
            }
            if (this.getPCrsUsr().isShowing()) {
                this.getPCard().setSelectedComponent(this.getPDatum());
            } else if (this.getPDatum().isShowing()) {
                this.getPCard().setSelectedComponent(this.getPSistCoord());
            }
            this.getBtnAnterior().setVisible(true);
            if (this.getPDatum().isShowing()) {
                this.getBtnFinalizar().setVisible(true);
                this.getBtnSiguiente().setVisible(false);
                this.getBtnAnterior().setVisible(true);
            }
        } else if (e.getSource().equals(this.getBtnFinalizar())) {
            if (this.getPCrsUsr().getRbCadenaWkt().isSelected()) {
                CoordinateReferenceSystem crs = null;
                String wkt = this.getPCrsUsr().getTxtAreaWkt().getText();
                Parser parser = new Parser();
                if (this.getPCrsUsr().getTxtAreaWkt().getText().equals("")) {
                    JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"white_Textbox"), "Warning...", 2);
                    return;
                }
                try {
                    crs = parser.parseCoordinateReferenceSystem(wkt);
                }
                catch (ParseException e1) {
                    JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"problem_with_wkt_try_manually"), "Warning...", 2);
                    return;
                }
                catch (UnsupportedOperationException e2) {
                    JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"problem_with_wkt_try_manually"), "Warning...", 2);
                    return;
                }
                this.fillData(crs);
            }
            this.getDataAndUpdate();
        } else if (e.getSource().equals(this.getBtnCancelar())) {
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        } else if (e.getSource().equals(this.getPCrsUsr().getRbCadenaWkt())) {
            this.getPCrsUsr().habilitarExistente(false);
            this.getPCrsUsr().habilitarWkt(true);
            this.getBtnFinalizar().setVisible(true);
        } else if (e.getSource().equals(this.getPCrsUsr().getRbCrsExistente())) {
            this.getPCrsUsr().habilitarExistente(true);
            this.getPCrsUsr().habilitarWkt(false);
            this.getBtnFinalizar().setVisible(false);
        } else if (e.getSource().equals(this.getPCrsUsr().getRbNuevoCrs())) {
            this.getPCrsUsr().habilitarExistente(false);
            this.getPCrsUsr().habilitarWkt(false);
            this.getBtnFinalizar().setVisible(false);
        }
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(8);
        m_viewinfo.setTitle(PluginServices.getText((Object)this, (String)"wz_titulo"));
        m_viewinfo.setWidth(560);
        m_viewinfo.setHeight(400);
        return m_viewinfo;
    }

    public ICrs getCrs() {
        return this.currentCrs;
    }

    public void setCrs(ICrs crs) {
        this.currentCrs = crs;
    }

    public void fillData(ICrs crs) {
        this.getPDatum().fillData(crs);
        this.getPSistCoord().fillData(crs);
    }

    public void fillData(ICrs crs, boolean editing) {
        this.getPDatum().fillData(crs, editing);
        this.getPSistCoord().fillData(crs);
    }

    public void cleanData() {
        this.getPDatum().cleanData();
        this.getPSistCoord().cleanData();
    }

    public void fillData(CoordinateReferenceSystem crs) {
        this.getPDatum().fillData(crs);
        this.getPSistCoord().fillData(crs);
    }

    private void getDataAndUpdate() {
        String name;
        String datum;
        ResultSet result;
        String sentence;
        EpsgConnection conn = new EpsgConnection();
        conn.setConnectionUsr();
        String codeCrs = "";
        if (this.getPDatum().getTxtSemMay().getText().equals("")) {
            JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"white_Textbox") + ": Semieje Mayor", "Warning...", 2);
            return;
        }
        if (this.getPDatum().getTxtLong().getText().equals("")) {
            JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"white_Textbox") + ": Longitud", "Warning...", 2);
            return;
        }
        if (this.getPDatum().getTxtCodigoCrs().getText().equals("")) {
            JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"white_Textbox") + ": Codigo CRS", "Warning...", 2);
            return;
        }
        String cadenaNumerica = this.getPDatum().getTxtSemMay().getText().replaceAll("[^0-9.E-]", "");
        if (this.getPDatum().getTxtSemMay().getText().length() != cadenaNumerica.length() || this.notANumber(cadenaNumerica)) {
            JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"numeric_format") + ": Semieje Mayor", "Warning...", 2);
            return;
        }
        cadenaNumerica = this.getPDatum().getTxtLong().getText().replaceAll("[^0-9.E-]", "");
        if (this.getPDatum().getTxtLong().getText().length() != cadenaNumerica.length() || this.notANumber(cadenaNumerica)) {
            JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"numeric_format") + ": Longitud", "Warning...", 2);
            return;
        }
        codeCrs = this.getPDatum().getTxtCodigoCrs().getText().replaceAll("[^0-9]", "");
        if (this.getPDatum().getTxtCodigoCrs().getText().length() != codeCrs.length()) {
            JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"numeric_format") + ": Codigo CRS", "Warning...", 2);
            return;
        }
        double value = Double.valueOf(this.getPDatum().getTxtSemMay().getText());
        String unit = this.getPDatum().getLengthUnit(this.getPDatum().getCbSemMay().getSelectedIndex());
        double semMay = this.getPDatum().convert2Meters(unit, value);
        value = Double.valueOf(this.getPDatum().getTxtLong().getText());
        unit = this.getPDatum().getAngularUnit(this.getPDatum().getCbLong().getSelectedIndex());
        double longitude = this.getPDatum().convert2Degree(unit, value);
        String spheroidName = this.getPDatum().getTxtElipsoide().getText();
        if (spheroidName.equals("")) {
            spheroidName = PluginServices.getText((Object)this, (String)"no_name");
        }
        String[] spheroid = new String[]{spheroidName, "" + semMay, this.getPDatum().getTxtInvF().getText()};
        String meridianName = this.getPDatum().getTxtMeridian().getText();
        if (meridianName.equals("")) {
            meridianName = PluginServices.getText((Object)this, (String)"no_name");
        }
        String[] primem = new String[]{meridianName, "" + longitude};
        String[] authority = new String[]{"\"USR\"", codeCrs};
        if (!this.isEditing()) {
            sentence = "SELECT usr_code FROM USR WHERE usr_code = " + authority[1];
            result = Query.select((String)sentence, (Connection)conn.getConnection());
            try {
                if (result.next()) {
                    JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"crsRepeat") + ": " + authority[1], "Warning...", 2);
                    return;
                }
            }
            catch (SQLException e1) {
                logger.error("Can't get values from resulset '" + sentence + "'.", (Throwable)e1);
            }
        }
        if ((datum = this.getPDatum().getTxtDatum().getText()).equals("")) {
            datum = PluginServices.getText((Object)this, (String)"no_name");
        }
        if (this.getPSistCoord().getRbGeografico().isSelected()) {
            name = this.getPDatum().getTxtNombreCrs().getText();
            if (name.equals("")) {
                name = PluginServices.getText((Object)this, (String)"no_name");
            }
            this.cadWkt = "GEOGCS[\"" + name + "\", DATUM[\"" + datum + "\", SPHEROID[\"" + spheroid[0] + "\", " + spheroid[1] + ", " + spheroid[2] + "]], " + "PRIMEM[\"" + primem[0] + "\", " + primem[1] + "], UNIT[\"Degree\", " + Math.PI / 180 + "]]";
            sentence = !this.isEditing() ? "INSERT INTO USR VALUES(" + authority[1] + ",'" + this.cadWkt + "','','" + name + "','" + datum + "')" : "UPDATE USR SET usr_wkt='" + this.cadWkt + "'," + "usr_proj='',usr_geog='" + this.getPDatum().getTxtNombreCrs().getText() + "'," + "usr_datum='" + datum + "' " + "WHERE usr_code = " + authority[1];
        } else {
            String projection;
            name = this.getPDatum().getTxtNombreCrs().getText();
            if (name.equals("")) {
                name = PluginServices.getText((Object)this, (String)"no_name");
            }
            if ((projection = this.getPSistCoord().getTxtNombreProy().getText()).equals("")) {
                projection = PluginServices.getText((Object)this, (String)"no_name");
            }
            this.cadWkt = "PROJCS[\"" + projection + "\", GEOGCS[\"" + name + "\", DATUM[\"" + datum + "\", SPHEROID[\"" + spheroid[0] + "\", " + spheroid[1] + ", " + spheroid[2] + "]], " + "PRIMEM[\"" + primem[0] + "\", " + primem[1] + "], UNIT[\"Degree\", " + Math.PI / 180 + "]], PROJECTION[\"" + this.getPSistCoord().getProjection(this.getPSistCoord().getCbProyeccion().getSelectedIndex()) + "\"], ";
            ArrayList maxValues = null;
            ArrayList minValues = null;
            int paramPos = 0;
            try {
                maxValues = this.getPSistCoord().getProj4().getProj4ProjectionParameterMaxValues(this.getPSistCoord().getPos());
                minValues = this.getPSistCoord().getProj4().getProj4ProjectionParameterMinValues(this.getPSistCoord().getPos());
            }
            catch (CrsException e) {
                logger.error("Can't get max and min values from the proj parameters.", (Throwable)e);
            }
            int j = 0;
            for (int i = 0; i < this.getPSistCoord().getTableParametros().getRowCount(); ++i) {
                if (((String)this.getPSistCoord().getTableParametros().getValueAt(i, 1)).equals("")) {
                    this.getPSistCoord().getTableParametros().setValueAt("0", i, 1);
                }
                cadenaNumerica = ((String)this.getPSistCoord().getTableParametros().getValueAt(i, 1)).replaceAll("[^0-9.E-]", "");
                if (((String)this.getPSistCoord().getTableParametros().getValueAt(i, 1)).length() != cadenaNumerica.length() || this.notANumber(cadenaNumerica)) {
                    JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"numeric_format") + ": Parametro " + (String)this.getPSistCoord().getTableParametros().getValueAt(i, 0), "Warning...", 2);
                    return;
                }
                String condition = (String)this.getPSistCoord().getTableParametros().getValueAt(i, 0);
                String param = this.getPSistCoord().getTrueParametersNames(j);
                paramPos = this.findPositionParameter(param);
                if (paramPos != -1) {
                    value = Double.parseDouble(cadenaNumerica);
                    if (PluginServices.getText((Object)this, (String)condition).trim().equals("semi_major") || PluginServices.getText((Object)this, (String)condition).trim().equals("semi_minor")) continue;
                    if (!param.trim().equals("semi_major") && !param.trim().equals("semi_minor")) {
                        double maxValue = Double.parseDouble((String)maxValues.get(paramPos));
                        double minValue = Double.parseDouble((String)minValues.get(paramPos));
                        if (value > maxValue || value < minValue) {
                            JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"incorrect_domain") + ": Parametro " + (String)this.getPSistCoord().getTableParametros().getValueAt(i, 0), "Warning...", 2);
                            return;
                        }
                        ++j;
                    }
                    value = 0.0;
                    unit = "";
                    String type = (String)this.getPSistCoord().getTableParametros().getValueAt(i, 2);
                    value = Double.parseDouble((String)this.getPSistCoord().getTableParametros().getValueAt(i, 1));
                    this.cadWkt = this.cadWkt + "PARAMETER[\"" + this.getPSistCoord().getTrueParametersNames(i) + "\", " + value + "], ";
                    continue;
                }
                ++j;
            }
            this.cadWkt = this.cadWkt + "UNIT[\"Meters\", 1.0]]";
            sentence = !this.isEditing() ? "INSERT INTO USR VALUES(" + authority[1] + ",'" + this.cadWkt + "','" + projection + "','" + name + "','" + datum + "')" : "UPDATE USR SET usr_wkt='" + this.cadWkt + "'," + "usr_proj='" + projection + "'," + "usr_geog='" + name + "'," + "usr_datum='" + datum + "' " + "WHERE usr_code = " + authority[1];
        }
        try {
            conn.update(sentence);
            conn.shutdown();
        }
        catch (SQLException e) {
            logger.error("Can't execute sentence '" + sentence + "'.", (Throwable)e);
        }
        this.setNewCrsCode(Integer.parseInt(authority[1]));
        try {
            ICrs crs = new CrsFactory().getCRS("USR:" + authority[1]);
            crs.getProj4String();
        }
        catch (CrsException e1) {
            JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)e1.getMessage()), "Warning...", 2);
            conn.setConnectionUsr();
            sentence = "DELETE FROM USR WHERE usr_code =" + authority[1];
            result = Query.select((String)sentence, (Connection)conn.getConnection());
            try {
                conn.shutdown();
            }
            catch (SQLException arg0) {
                logger.error("Can't shutdown connection.", (Throwable)arg0);
            }
            return;
        }
        PluginServices.getMDIManager().closeWindow((IWindow)this);
    }

    private int findPositionParameter(String param) {
        ArrayList parameters = new ArrayList();
        try {
            parameters = this.getPSistCoord().getProj4().getProj4ProjectionParameters(this.getPSistCoord().getPos());
            int pos = -1;
            int i = 0;
            do {
                pos = this.getPSistCoord().getProj4().findProjectionParameters(param, parameters.get(i).toString());
            } while (++i != parameters.size() && pos == -1);
            if (pos != -1) {
                param = this.getPSistCoord().getProj4().getProj4ProjectionParameterName(pos);
            }
        }
        catch (CrsException e) {
            logger.error("Can't get parameter name from projection.", (Throwable)e);
        }
        for (int i = 0; i < parameters.size(); ++i) {
            String actualParam = ((String)parameters.get(i)).trim();
            if (!actualParam.equals(param)) continue;
            return i;
        }
        return -1;
    }

    public void setNewCrsCode(int code) {
        this.newCrsCode = code;
    }

    public int getNewCrsCode() {
        return this.newCrsCode;
    }

    private boolean notANumber(String cadenaNumerica) {
        int puntos = 0;
        int signos = 0;
        int letras = 0;
        for (int i = 0; i < cadenaNumerica.length(); ++i) {
            if (cadenaNumerica.charAt(i) == '.') {
                ++puntos;
                continue;
            }
            if (cadenaNumerica.charAt(i) == '-') {
                if (i == 0) {
                    ++signos;
                    continue;
                }
                if (i == 0 || cadenaNumerica.charAt(i - 1) == 'E') continue;
                signos = 2;
                continue;
            }
            if (cadenaNumerica.charAt(i) != 'E') continue;
            if (i == 0) {
                letras = 2;
                continue;
            }
            ++letras;
        }
        return letras > 1 || signos > 1 || puntos > 1;
    }

    public void setEditing(boolean edit) {
        this.edit = edit;
    }

    public boolean isEditing() {
        return this.edit;
    }

    public void setEditingPanel() {
        this.pCard.setSelectedComponent(this.getPDatum());
        this.pCard.setEnabledAt(0, false);
        this.fillData(this.getCrs(), true);
        this.getPDatum().getTxtCodigoCrs().setEnabled(false);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.getPCard()) {
            int i;
            if (this.getPCrsUsr().getHasChanged()) {
                ICrs crs;
                if (this.getPCrsUsr().getRbCrsExistente().isSelected()) {
                    crs = this.getPCrsUsr().getCrs();
                    if (crs != null) {
                        this.fillData(crs);
                    } else {
                        this.fillData(this.getCrs());
                    }
                    this.getPCrsUsr().setHasChange(false);
                } else if (this.getPCrsUsr().getRbNuevoCrs().isSelected()) {
                    this.cleanData();
                    this.getPCrsUsr().setHasChange(false);
                } else if (this.getPCrsUsr().getRbCadenaWkt().isSelected()) {
                    this.cleanData();
                    if (this.getPCrsUsr().getTxtAreaWkt().getText().equals("")) {
                        JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"white_Textbox"), "Warning...", 2);
                        this.getPCrsUsr().setHasChange(false);
                        this.getPCard().setSelectedComponent(this.getPCrsUsr());
                        return;
                    }
                    crs = null;
                    String wkt = this.getPCrsUsr().getTxtAreaWkt().getText();
                    Parser parser = new Parser();
                    Object crs2 = null;
                    try {
                        crs = parser.parseCoordinateReferenceSystem(wkt);
                    }
                    catch (ParseException e1) {
                        JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"problem_with_wkt_try_manually"), "Warning...", 2);
                        this.getPCrsUsr().setHasChange(false);
                        this.getPCard().setSelectedComponent(this.getPCrsUsr());
                        return;
                    }
                    catch (UnsupportedOperationException e2) {
                        JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"problem_with_wkt_try_manually"), "Warning...", 2);
                        this.getPCrsUsr().setHasChange(false);
                        this.getPCard().setSelectedComponent(this.getPCrsUsr());
                        return;
                    }
                    this.fillData((CoordinateReferenceSystem)crs);
                    this.getPCrsUsr().setHasChange(false);
                }
            }
            if ((i = ((JTabbedPane)e.getSource()).getSelectedIndex()) == 0) {
                this.getBtnAnterior().setVisible(false);
                this.getBtnSiguiente().setVisible(true);
                if (this.getPCrsUsr().getRbCadenaWkt().isSelected()) {
                    this.getPCrsUsr().setHasChange(true);
                    this.getBtnFinalizar().setVisible(true);
                } else {
                    this.getBtnFinalizar().setVisible(false);
                }
            } else if (i == 1 && !this.isEditing()) {
                this.getBtnAnterior().setVisible(true);
                this.getBtnSiguiente().setVisible(true);
                this.getBtnFinalizar().setVisible(false);
                if (this.getPCrsUsr().getRbCadenaWkt().isSelected()) {
                    this.getBtnFinalizar().setVisible(true);
                }
            } else if (i == 1 && this.isEditing()) {
                this.getBtnAnterior().setVisible(false);
                this.getBtnSiguiente().setVisible(true);
                this.getBtnFinalizar().setVisible(false);
            } else if (i == 2) {
                this.getBtnAnterior().setVisible(true);
                this.getBtnSiguiente().setVisible(false);
                this.getBtnFinalizar().setVisible(true);
            }
        }
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }
}

