/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.persistence;

import org.gvsig.crs.persistence.TrData;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class CompTrData
extends TrData {
    private static final String COMPTRDATA_PERSISTENCE_DEFINITION_NAME = "jCRS_CompTrData";
    TrData firstTr = null;
    TrData secondTr = null;

    public CompTrData(String authority, int code, String name, String crsSource, String crsTarget, String details, TrData firstTr, TrData secondTr) {
        super(authority, code, name, crsSource, crsTarget, details);
        this.firstTr = firstTr;
        this.secondTr = secondTr;
    }

    public CompTrData(TrData firstTr, TrData secondTr) {
        super("COMP", 0, "----", firstTr.getCrsSource(), secondTr.getCrsTarget(), firstTr.getDetails() + " @ " + secondTr.getDetails());
        this.firstTr = firstTr;
        this.secondTr = secondTr;
    }

    public TrData getFirstTr() {
        return this.firstTr;
    }

    public void setFirstTr(TrData firstTr) {
        this.firstTr = firstTr;
    }

    public TrData getSecondTr() {
        return this.secondTr;
    }

    public void setSecondTr(TrData secondTr) {
        this.secondTr = secondTr;
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("firstTr", (Persistent)this.firstTr);
        state.set("secondTr", (Persistent)this.secondTr);
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.firstTr = (TrData)state.get("firstTr");
        this.secondTr = (TrData)state.get("secondTr");
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(COMPTRDATA_PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(CompTrData.class, COMPTRDATA_PERSISTENCE_DEFINITION_NAME, "jCRS_CompTrData Persistence definition", null, null);
            DynStruct parent = manager.getDefinition("jCRS_TrData");
            definition.extend(parent);
            definition.addDynFieldObject("firstTr").setMandatory(false).setClassOfValue(TrData.class);
            definition.addDynFieldObject("secondTr").setMandatory(false).setClassOfValue(TrData.class);
        }
    }
}

