/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.backup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import org.gvsig.tools.backup.BackupGenerator;
import org.gvsig.tools.backup.exceptions.BackupException;

public class DefaultBackupGenerator
implements BackupGenerator {
    @Override
    public void backup(File source) throws BackupException {
        try {
            int index = source.getAbsolutePath().lastIndexOf(".");
            if (index == -1) {
                return;
            }
            File dest = new File(source.getAbsolutePath().substring(0, index) + ".bak");
            FileChannel srcChannel = new FileInputStream(source).getChannel();
            FileChannel dstChannel = new FileOutputStream(dest).getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
        }
        catch (Exception ex) {
            throw new BackupException(ex.getMessage(), ex, source);
        }
    }
}

