/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.console;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.gvsig.utils.console.ResponseListener;
import org.gvsig.utils.console.ResponseListenerSupport;
import org.gvsig.utils.console.jedit.ConsoleInputHandler;
import org.gvsig.utils.console.jedit.JEditTextArea;
import org.gvsig.utils.console.jedit.TextAreaDefaults;
import org.gvsig.utils.console.jedit.TokenMarker;

public class JConsole
extends JPanel {
    private JEditTextArea txt;
    private int startingCaretPosition = 0;
    private ArrayList entries = new ArrayList();
    private int currentEntry = -1;
    private ResponseListenerSupport listenerSupport = new ResponseListenerSupport();
    public static int MESSAGE = 0;
    public static int COMMAND = 1;
    public static int INSERT = 2;
    public static int ERROR = 3;
    private static TextAreaDefaults defaults;
    private JConsole theContainer = null;
    private boolean redispatch_key_events = false;

    public JConsole() {
        this.initialize();
        defaults = TextAreaDefaults.getDefaults();
        ((ConsoleInputHandler)JConsole.defaults.inputHandler).addConsoleListener(this);
        this.theContainer = this;
    }

    public JConsole(boolean redisp_key_events) {
        this();
        this.redispatch_key_events = redisp_key_events;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(300, 200);
        this.setPreferredSize(new Dimension(300, 200));
        this.add((Component)this.getTxt(), "Center");
    }

    public void setTokenMarker(TokenMarker tm) {
        this.txt.setTokenMarker(tm);
    }

    public JEditTextArea getTxt() {
        if (this.txt == null) {
            this.txt = new JEditTextArea();
            this.txt.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    if (JConsole.this.txt.getCaretPosition() < JConsole.this.startingCaretPosition && JConsole.this.startingCaretPosition <= JConsole.this.txt.getText().length()) {
                        JConsole.this.txt.setCaretPosition(JConsole.this.startingCaretPosition);
                    }
                }
            });
        }
        return this.txt;
    }

    public void addText(String text, int type) {
        this.txt.setText(this.txt.getText() + text);
        this.txt.setCaretPosition(this.txt.getText().length());
        this.startingCaretPosition = this.txt.getText().length();
    }

    public void addResponseText(String text) {
        this.txt.setText(this.txt.getText() + text);
        this.txt.setCaretPosition(this.txt.getText().length());
    }

    public void addResponseListener(ResponseListener listener) {
        this.listenerSupport.addResponseListener(listener);
    }

    public void removeResponseListener(ResponseListener listener) {
        this.listenerSupport.removeResponseListener(listener);
    }

    public void setJTextName(String name) {
        this.txt.setName(name);
    }

    public void keyPressed(KeyEvent e) {
        Container cont;
        if (e.getKeyCode() == 8 && this.startingCaretPosition >= this.txt.getCaretPosition()) {
            int caretPos = this.txt.getCaretPosition();
            String text = this.txt.getText();
            text = text.substring(0, caretPos) + " " + text.substring(caretPos);
            this.txt.setText(text);
            this.txt.setCaretPosition(caretPos);
        }
        if (this.redispatch_key_events && (cont = this.getParent()) != null && cont instanceof Component) {
            Container comp = cont;
            comp.dispatchEvent(e);
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            String texto = this.txt.getText();
            String response = texto.substring(this.startingCaretPosition);
            this.listenerSupport.callAcceptResponse(response);
            if (response.trim().length() > 0) {
                this.entries.add(response.trim());
            }
            this.currentEntry = -1;
        } else if (e.getKeyCode() == 38) {
            if (this.entries.size() == 0) {
                return;
            }
            if (this.currentEntry == -1) {
                this.currentEntry = this.entries.size() - 1;
            } else {
                --this.currentEntry;
                if (this.currentEntry < 0) {
                    this.currentEntry = 0;
                }
            }
            this.putEntry();
        } else if (e.getKeyCode() == 40) {
            if (this.entries.size() == 0) {
                return;
            }
            if (this.currentEntry != -1) {
                ++this.currentEntry;
                if (this.currentEntry >= this.entries.size()) {
                    this.currentEntry = this.entries.size() - 1;
                }
            }
            this.putEntry();
        } else if (e.getKeyCode() == 27) {
            this.txt.setText(this.txt.getText());
            this.listenerSupport.callAcceptResponse(null);
        } else if (e.getKeyCode() == 86 && (e.getModifiers() & 2) != 0) {
            String clipb = "";
            try {
                clipb = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException response) {
            }
            catch (IOException response) {
                // empty catch block
            }
            if (clipb != null && clipb.length() > 0) {
                String[] parts = clipb.split("\n");
                for (int i = 0; i < parts.length; ++i) {
                    String part = parts[i];
                    if (part == null || part.length() <= 0) continue;
                    this.txt.setText(this.txt.getText() + part);
                    String texto = this.txt.getText();
                    String response = texto.substring(this.startingCaretPosition);
                    this.listenerSupport.callAcceptResponse(response);
                    if (response.trim().length() > 0) {
                        this.entries.add(response.trim());
                    }
                    this.currentEntry = -1;
                }
            }
        }
    }

    private void putEntry() {
        String anterior = this.txt.getText();
        anterior = anterior.substring(0, this.startingCaretPosition);
        this.txt.setText(anterior + this.entries.get(this.currentEntry));
    }
}

