/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.gvsig.utils.MathExtension;

public class BinarySearchUsingFirstCharacters {
    public static synchronized List doSearchConsideringCaseSensitive(String text, Vector sortOrderedItems) {
        int size = sortOrderedItems.size();
        int maxNumberOfIterations = (int)MathExtension.log2(size);
        int lowIndex = 0;
        int highIndex = sortOrderedItems.size() - 1;
        for (int currentIteration = 0; lowIndex <= highIndex && currentIteration <= maxNumberOfIterations; ++currentIteration) {
            int mIndx = (lowIndex + highIndex) / 2;
            if (sortOrderedItems.get(mIndx).toString().startsWith(text)) {
                highIndex = mIndx;
                lowIndex = highIndex++;
                while (highIndex < size && sortOrderedItems.get(highIndex).toString().startsWith(text)) {
                    ++highIndex;
                }
                while (lowIndex - 1 > -1 && sortOrderedItems.get(lowIndex - 1).toString().startsWith(text)) {
                    --lowIndex;
                }
                Vector list = new Vector(sortOrderedItems.subList(lowIndex, highIndex));
                --lowIndex;
                while (lowIndex > -1 && sortOrderedItems.get(lowIndex).toString().toLowerCase().startsWith(text.toLowerCase())) {
                    if (sortOrderedItems.get(lowIndex).toString().startsWith(text)) {
                        list.add(0, sortOrderedItems.get(lowIndex));
                    }
                    --lowIndex;
                }
                while (highIndex < size && sortOrderedItems.get(highIndex).toString().toLowerCase().startsWith(text.toLowerCase())) {
                    if (sortOrderedItems.get(highIndex).toString().startsWith(text)) {
                        list.add(list.size(), sortOrderedItems.get(highIndex));
                    }
                    ++highIndex;
                }
                return list;
            }
            if (sortOrderedItems.get(mIndx).toString().compareTo(text) > 0) {
                highIndex = mIndx - 1;
                continue;
            }
            lowIndex = mIndx + 1;
        }
        return null;
    }

    public static synchronized List doSearchIgnoringCaseSensitive(String text, Vector sortOrderedItems) {
        int mIndx;
        int currentIteration;
        int size = sortOrderedItems.size();
        int maxNumberOfIterations = (int)MathExtension.log2(size);
        int lowIndex = 0;
        int highIndex = sortOrderedItems.size() - 1;
        List<Object> list = null;
        List<Object> list2 = null;
        for (currentIteration = 0; lowIndex <= highIndex && currentIteration <= maxNumberOfIterations; ++currentIteration) {
            mIndx = (lowIndex + highIndex) / 2;
            if (sortOrderedItems.get(mIndx).toString().toLowerCase().startsWith(text.toLowerCase())) {
                highIndex = mIndx;
                lowIndex = highIndex++;
                while (highIndex < size && sortOrderedItems.get(highIndex).toString().toLowerCase().startsWith(text.toLowerCase())) {
                    ++highIndex;
                }
                while (lowIndex - 1 > -1 && sortOrderedItems.get(lowIndex - 1).toString().toLowerCase().startsWith(text.toLowerCase())) {
                    --lowIndex;
                }
                list = Arrays.asList(sortOrderedItems.subList(lowIndex, highIndex).toArray());
                break;
            }
            if (sortOrderedItems.get(mIndx).toString().compareTo(text) > 0) {
                highIndex = mIndx - 1;
                continue;
            }
            lowIndex = mIndx + 1;
        }
        lowIndex = 0;
        highIndex = sortOrderedItems.size() - 1;
        for (currentIteration = 0; lowIndex <= highIndex && currentIteration <= maxNumberOfIterations; ++currentIteration) {
            mIndx = (lowIndex + highIndex) / 2;
            if (sortOrderedItems.get(mIndx).toString().toLowerCase().startsWith(text.toLowerCase())) {
                int j;
                Object obj;
                highIndex = mIndx;
                lowIndex = highIndex++;
                while (highIndex < size && sortOrderedItems.get(highIndex).toString().toLowerCase().startsWith(text.toLowerCase())) {
                    ++highIndex;
                }
                while (lowIndex - 1 > -1 && sortOrderedItems.get(lowIndex - 1).toString().toLowerCase().startsWith(text.toLowerCase())) {
                    --lowIndex;
                }
                list2 = Arrays.asList(sortOrderedItems.subList(lowIndex, highIndex).toArray());
                if (list == null) {
                    return list2;
                }
                if (list2 == null) {
                    return null;
                }
                list = new ArrayList<Object>(list.subList(0, list.size()));
                for (int i = 0; i < list2.size(); ++i) {
                    obj = list2.get(i);
                    if (list.contains(obj)) continue;
                    for (j = 0; j < list.size() && list.get(j).toString().compareTo(obj.toString()) <= 0; ++j) {
                    }
                    list.add(j, obj);
                }
                size = list.size();
                j = size == 0 ? 0 : sortOrderedItems.indexOf(list.get(size - 1));
                if (++j < sortOrderedItems.size()) {
                    do {
                        if (!(obj = sortOrderedItems.get(j)).toString().toLowerCase().startsWith(text.toLowerCase())) continue;
                        list.add(size, obj);
                    } while (++j < sortOrderedItems.size());
                }
                return list;
            }
            if (sortOrderedItems.get(mIndx).toString().toLowerCase().compareTo(text.toLowerCase()) > 0) {
                highIndex = mIndx - 1;
                continue;
            }
            lowIndex = mIndx + 1;
        }
        return null;
    }

    public static synchronized List doSearchConsideringCaseSensitive(String text, Vector sortOrderedItems, Comparator comp) {
        List results_list = BinarySearchUsingFirstCharacters.doSearchIgnoringCaseSensitive(text, sortOrderedItems, comp);
        if (results_list == null) {
            return null;
        }
        ArrayList results = new ArrayList();
        for (int i = 0; i < results_list.size(); ++i) {
            if (!results_list.get(i).toString().startsWith(text)) continue;
            results.add(results_list.get(i));
        }
        return results;
    }

    public static synchronized List doSearchIgnoringCaseSensitive(String text, Vector sortOrderedItems, Comparator comp) {
        int size = sortOrderedItems.size();
        int maxNumberOfIterations = (int)MathExtension.log2(size);
        int lowIndex = 0;
        int highIndex = sortOrderedItems.size() - 1;
        for (int currentIteration = 0; lowIndex <= highIndex && currentIteration <= maxNumberOfIterations; ++currentIteration) {
            int mIndx = (lowIndex + highIndex) / 2;
            if (sortOrderedItems.get(mIndx).toString().toLowerCase().startsWith(text.toLowerCase())) {
                highIndex = mIndx;
                lowIndex = highIndex++;
                while (highIndex < size && sortOrderedItems.get(highIndex).toString().toLowerCase().startsWith(text.toLowerCase())) {
                    ++highIndex;
                }
                while (lowIndex - 1 > -1 && sortOrderedItems.get(lowIndex - 1).toString().toLowerCase().startsWith(text.toLowerCase())) {
                    --lowIndex;
                }
                return Arrays.asList(sortOrderedItems.subList(lowIndex, highIndex).toArray());
            }
            if (comp.compare(sortOrderedItems.get(mIndx).toString().toLowerCase(), text.toLowerCase()) > 0) {
                highIndex = mIndx - 1;
                continue;
            }
            lowIndex = mIndx + 1;
        }
        return null;
    }
}

