/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.swing.jcomboServer;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.gvsig.utils.swing.jcomboServer.ServerData;

public class ComboServerController {
    private final JComboBox combo;

    public ComboServerController(JComboBox combo) {
        this.combo = combo;
    }

    public ComboServerController(JComboBox combo, ServerData[] servers) {
        this.combo = combo;
        this.combo.setModel(new DefaultComboBoxModel<ServerData>(ComboServerController.setLastAccessOrder(servers)));
    }

    public JComboBox getCombo() {
        return this.combo;
    }

    public ServerData getSelectedServer() {
        try {
            return (ServerData)this.combo.getSelectedItem();
        }
        catch (ClassCastException e) {
            return new ServerData((String)this.combo.getSelectedItem(), "", "");
        }
    }

    public void addServer(ServerData server) {
        ServerData[] servers = this.getAllServers();
        ServerData[] newServers = new ServerData[servers.length + 1];
        System.arraycopy(servers, 0, newServers, 0, servers.length);
        newServers[servers.length] = server;
        newServers = ComboServerController.setLastAccessOrder(newServers);
        this.setServerList(newServers);
    }

    public ServerData[] getAllServers() {
        ServerData[] servers = new ServerData[this.combo.getItemCount()];
        for (int i = 0; i < this.combo.getItemCount(); ++i) {
            servers[i] = (ServerData)this.combo.getItemAt(i);
        }
        return servers;
    }

    public void setServerList(ServerData[] servers) {
        this.combo.removeAllItems();
        servers = ComboServerController.setLastAccessOrder(servers);
        for (int i = 0; i < servers.length; ++i) {
            try {
                if (servers[i].getServerAddress().equals("")) continue;
                this.combo.addItem(servers[i]);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void setServersOrder() {
        ServerData[] servers = this.getAllServers();
        servers = ComboServerController.setLastAccessOrder(servers);
        this.setServerList(servers);
    }

    private static ServerData[] setLastAccessOrder(ServerData[] servers) {
        ServerData[] orderedServerData = new ServerData[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            int pos = ComboServerController.getServerPosition(servers, i);
            orderedServerData[pos] = servers[i];
        }
        return orderedServerData;
    }

    private static int getServerPosition(ServerData[] servers, int serverPos) {
        int pos = 0;
        for (int i = 0; i < servers.length; ++i) {
            if (servers[serverPos].getServerAddress().equals(servers[i].getServerAddress())) continue;
            if (servers[serverPos].getLastAccess().before(servers[i].getLastAccess())) {
                ++pos;
            }
            if (!servers[serverPos].getLastAccess().equals(servers[i].getLastAccess()) || serverPos >= i) continue;
            ++pos;
        }
        return pos;
    }

    public void setModel(ComboBoxModel model) {
        this.combo.setModel(model);
    }

    public ComboBoxModel getModel() {
        return this.combo.getModel();
    }

    public int getItemCount() {
        return this.combo.getItemCount();
    }

    public Object getItemAt(int i) {
        return this.combo.getItemAt(i);
    }
}

