/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.vectorUtilities;

import java.util.Comparator;
import java.util.Vector;
import org.gvsig.utils.MathExtension;

public class VectorUtilities {
    public static synchronized void addAlphabeticallyOrdered(Vector v, Object obj) {
        int size = v.size();
        int lowIndex = 0;
        int highIndex = size - 1;
        int maxNumberOfIterations = (int)MathExtension.log2(size);
        if (size == 0) {
            v.add(obj);
            return;
        }
        for (int currentIteration = 0; lowIndex <= highIndex && currentIteration <= maxNumberOfIterations; ++currentIteration) {
            int aux_index;
            int index = (lowIndex + highIndex) / 2;
            if (v.get(index).toString().compareTo(obj.toString()) == 0) {
                v.add(index, obj);
                return;
            }
            if (v.get(index).toString().compareTo(obj.toString()) < 0) {
                aux_index = index + 1;
                if (aux_index >= size) {
                    v.add(v.size(), obj);
                    return;
                }
                if (v.get(aux_index).toString().compareTo(obj.toString()) > 0) {
                    v.add(aux_index, obj);
                    return;
                }
                lowIndex = aux_index;
                continue;
            }
            if (v.get(index).toString().compareTo(obj.toString()) <= 0) continue;
            aux_index = index - 1;
            if (aux_index < 0) {
                v.add(0, obj);
                return;
            }
            if (v.get(aux_index).toString().compareTo(obj.toString()) < 0) {
                v.add(index, obj);
                return;
            }
            highIndex = aux_index;
        }
    }

    public static synchronized void addAlphabeticallyOrdered(Vector v, Object obj, Comparator comp) {
        int size = v.size();
        int lowIndex = 0;
        int highIndex = size - 1;
        int maxNumberOfIterations = (int)MathExtension.log2(size);
        if (size == 0) {
            v.add(obj);
            return;
        }
        for (int currentIteration = 0; lowIndex <= highIndex && currentIteration <= maxNumberOfIterations; ++currentIteration) {
            int aux_index;
            int index = (lowIndex + highIndex) / 2;
            if (comp.compare(v.get(index), obj) == 0) {
                v.add(index, obj);
                return;
            }
            if (comp.compare(v.get(index), obj) < 0) {
                aux_index = index + 1;
                if (aux_index >= size) {
                    v.add(v.size(), obj);
                    return;
                }
                if (comp.compare(v.get(aux_index), obj) > 0) {
                    v.add(aux_index, obj);
                    return;
                }
                lowIndex = aux_index;
                continue;
            }
            if (comp.compare(v.get(index), obj) <= 0) continue;
            aux_index = index - 1;
            if (aux_index < 0) {
                v.add(0, obj);
                return;
            }
            if (comp.compare(v.get(aux_index), obj) < 0) {
                v.add(index, obj);
                return;
            }
            highIndex = aux_index;
        }
    }
}

