/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib;

import java.util.List;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.VCSGisUserEditable;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.workspace.tables.UsersTable;

public class VCSGisUserImpl
implements VCSGisUserEditable {
    private String code;
    private String description;
    private String identifier;
    private String allowed_operations;
    private String roles;
    private List<String> operations_list;
    private List<String> roles_list;

    public VCSGisUserImpl() {
    }

    public VCSGisUserImpl(JsonObject jsonData) {
        this.code = jsonData.getString("UserCode", null);
        this.description = jsonData.getString("Description", null);
        this.identifier = jsonData.getString("Identifier", null);
        this.allowed_operations = jsonData.getString("AllowedOperations", null);
        this.roles = jsonData.getString("Roles", null);
    }

    public String getUserCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getAllowedOperations() {
        return this.allowed_operations;
    }

    @Override
    public void setUserCode(String userCode) {
        this.code = userCode;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setAllowedOperations(String operation) {
        this.allowed_operations = operation;
    }

    @Override
    public void copy(VCSGisUser source, VCSGisUser target) {
        VCSGisUserImpl.copyUser(source, (VCSGisUserEditable)target);
    }

    public void copyFrom(VCSGisUser other) {
        VCSGisUserImpl.copyUser(other, this);
    }

    @Override
    public VCSGisUser clone() {
        try {
            VCSGisUserEditable other = (VCSGisUserEditable)super.clone();
            VCSGisUserImpl.copyUser(this, other);
            return other;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public List<String> getAllowedOperationsAsList() {
        if (this.operations_list == null) {
            this.operations_list = VCSGisUserImpl.getAllowedOperationsAsList(this);
        }
        return this.operations_list;
    }

    public boolean isAllowedOperation(String operation) {
        return VCSGisUserImpl.isAllowedOperation(this, operation);
    }

    public void fromJson(JsonObject json) {
        VCSGisUserImpl.fromJson(this, json);
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        return VCSGisUserImpl.toJsonBuilder(this);
    }

    public String toString() {
        return VCSGisUserImpl.toString(this);
    }

    public static String toString(VCSGisUser user) {
        return user.getIdentifier();
    }

    public static JsonObjectBuilder toJsonBuilder(VCSGisUser user) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("UserCode", user.getUserCode());
        builder.add("Identifier", user.getIdentifier());
        if (user instanceof UsersTable.UserRow) {
            builder.addNull("AllowedOperations");
            builder.addNull("Roles");
        } else {
            builder.add("AllowedOperations", user.getAllowedOperations());
            builder.add("Roles", user.getRoles());
        }
        builder.add("Description", user.getDescription());
        return builder;
    }

    public static boolean isAllowedOperation(VCSGisUser user, String operation) {
        if (StringUtils.isBlank((CharSequence)operation)) {
            return false;
        }
        List rl = user.getAllowedOperationsAsList();
        if (rl == null) {
            return false;
        }
        return rl.contains(operation.trim().toLowerCase());
    }

    public static void fromJson(VCSGisUserEditable user, JsonObject json) {
        user.setUserCode(json.getString("UserCode", null));
        user.setIdentifier(json.getString("Identifier", null));
        if (!(user instanceof UsersTable.UserRow)) {
            user.setAllowedOperations(json.getString("AllowedOperations", null));
            user.setRoles(json.getString("Roles", null));
        }
        user.setDescription(json.getString("Description", null));
    }

    public static void copyUser(VCSGisUser source, VCSGisUserEditable target) {
        target.setUserCode(source.getUserCode());
        target.setIdentifier(source.getIdentifier());
        if (!(target instanceof UsersTable.UserRow)) {
            target.setAllowedOperations(source.getAllowedOperations());
            target.setRoles(source.getRoles());
        }
        target.setDescription(source.getDescription());
    }

    public static List<String> getAllowedOperationsAsList(VCSGisUser user) {
        String s = user.getAllowedOperations();
        return VCSGisUtils.getAsList(s);
    }

    public static List<String> getRolesAsList(VCSGisUser user) {
        String s = user.getRoles();
        return VCSGisUtils.getAsList(s);
    }

    public String getRoles() {
        return this.roles;
    }

    public List<String> getRolesAsList() {
        if (this.roles_list == null) {
            this.roles_list = VCSGisUserImpl.getRolesAsList(this);
        }
        return this.roles_list;
    }

    @Override
    public void setRoles(String roles) {
        this.roles = roles;
    }
}

