/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository;

import java.util.Map;
import java.util.UUID;
import javax.json.JsonObject;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisUserIdentificationRequester;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisAuthenticateRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepository
extends AbstractDisposable
implements VCSGisRepository {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractRepository.class);
    protected String token;
    protected String userCode;
    protected PropertiesSupportHelper propertiesHelper = new PropertiesSupportHelper();

    protected AbstractRepository() {
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public String createUniqueCode() {
        UUID x = UUID.randomUUID();
        String s = x.toString().replace("-", "");
        return s;
    }

    public String getLabel() {
        return null;
    }

    public String getAuthenticationToken() {
        return this.token;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public void setAuthenticationToken(String token) {
        this.token = token;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public int getDataTableBatchSize() {
        return -1;
    }

    public void addObserver(String tableName, String type, String operation, String command) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int authenticate(String userId, String password, SimpleTaskStatus status) {
        int errcode = 0;
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Authenticate-" + userId);
            status.setAutoremove(true);
            status.add();
        }
        try {
            VCSGisAuthenticateRequest request = this.createAuthenticateRequest(userId, password);
            if (request.execute() != 0) {
                status.message(request.getLastErrorMessage());
                status.abort();
                return request.getLastErrorCode();
            }
            this.setAuthenticationToken(request.getAuthenticationToken());
            this.setUserCode(request.getUserCode());
            status.message("Authentication completed");
            status.terminate();
            return 0;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't authenticate user.", (Throwable)ex);
            status.message("Can't authenticate user");
            status.abort();
            return errcode;
        }
    }

    public int execute(VCSGisRequest request) {
        VCSGisUserIdentificationRequester userIdentificationRequester = null;
        block3: while (true) {
            LOGGER.info("Client execute '" + request.getRequestName() + "' with user '" + request.getUserCode() + "' token = " + request.getAuthenticationToken());
            request.cleanLastError();
            switch (request.execute()) {
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    if (userIdentificationRequester == null) {
                        userIdentificationRequester = VCSGisLocator.getVCSGisManager().getUserIdentificationRequester();
                    }
                    if (!userIdentificationRequester.requestIdentification()) break block3;
                    int r = this.authenticate(userIdentificationRequester.getUserId(), userIdentificationRequester.getPassword(), null);
                    if (r != 0) continue block3;
                    request.setAuthenticationToken(this.getAuthenticationToken());
                    request.setUserCode(this.getUserCode());
                    continue block3;
                }
            }
            break;
        }
        return request.getLastErrorCode();
    }

    public Object getProperty(String name) {
        return this.propertiesHelper.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.propertiesHelper.setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        return this.propertiesHelper.getProperties();
    }
}

