/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.requests;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.EntityEditableImpl;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.requests.AbstractRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.tables.EntitiesRepoTable;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisEntitiesRequest;
import org.gvsig.vcsgis.lib.requests.EntitiesRequestHelper;

public class EntitiesRequestLocaldb
extends AbstractRequestLocaldb
implements VCSGisEntitiesRequest {
    public EntitiesRequestLocaldb(VCSGisRepositoryLocaldbImpl repository) {
        super(new EntitiesRequestHelper(repository));
    }

    @Override
    public EntitiesRequestHelper helper() {
        return (EntitiesRequestHelper)super.helper();
    }

    public List<VCSGisEntity> getRepositoryEntities() {
        return this.helper().getRepositoryEntities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        int n;
        if (!this.isAuthorized()) {
            return this.getLastErrorCode();
        }
        LOGGER.info("Process request: " + this.getRequestName() + " user '" + this.getUserCode() + "'.");
        DisposableFeatureSetIterable entities_it = null;
        try {
            EntitiesRepoTable entitiesTable = new EntitiesRepoTable();
            ArrayList<VCSGisEntity> list = new ArrayList<VCSGisEntity>();
            entities_it = entitiesTable.getAll(this.getRepository());
            VCSGisUser user = this.getUser();
            boolean authenticationRequired = this.getRepository().isAuthenticationRequired();
            for (Feature fentity : entities_it) {
                EntitiesRepoTable.EntityRepoRow rEntity = new EntitiesRepoTable.EntityRepoRow(this.getRepository(), fentity);
                if (authenticationRequired && !rEntity.isAuthorized(user, "view")) continue;
                EntityEditableImpl entity = new EntityEditableImpl();
                entity.copyfrom((VCSGisEntity)rEntity);
                list.add((VCSGisEntity)entity);
            }
            this.helper().entities = list;
            n = this.error(0);
        }
        catch (Exception ex) {
            int n2;
            try {
                LOGGER.warn("Can't retrieve entities from '" + this.getRepository().getLabel() + "'.", (Throwable)ex);
                n2 = this.error(250, "Can't retrieve entities from '" + this.getRepository().getLabel() + "'.");
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(entities_it);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)entities_it);
            return n2;
        }
        DisposeUtils.disposeQuietly((Disposable)entities_it);
        return n;
    }
}

