/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.requests;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.task.CancellableTask;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.requests.AbstractRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.tables.ConfigRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.UsersRepoTable;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisPrepareWCRequest;
import org.gvsig.vcsgis.lib.requests.PrepareWCRequestHelper;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.tables.VarsTable;
import org.slf4j.Logger;

public class PrepareWCRequestLocaldb
extends AbstractRequestLocaldb
implements VCSGisPrepareWCRequest {
    private String remoteHost;
    private PrepareWorkingCopyContext context;

    public PrepareWCRequestLocaldb(VCSGisRepositoryLocaldbImpl repository) {
        super(new PrepareWCRequestHelper(repository));
    }

    public void setContext(PrepareWorkingCopyContext context) {
        this.context = context;
    }

    public PrepareWorkingCopyContext getContext() {
        return this.context;
    }

    @Override
    public PrepareWCRequestHelper helper() {
        return (PrepareWCRequestHelper)super.helper();
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute() {
        ConfigRepoTable configTable;
        String trustedClientUrl;
        boolean authorized = false;
        boolean trustedClient = false;
        if (StringUtils.isNotBlank((CharSequence)this.remoteHost) && StringUtils.equals((CharSequence)this.remoteHost, (CharSequence)(trustedClientUrl = (configTable = new ConfigRepoTable()).get(this.getRepository(), "TRUSTED_CLIENT_IP")))) {
            authorized = true;
            trustedClient = true;
        }
        if (!authorized && !this.isAuthorized()) {
            return this.getLastErrorCode();
        }
        LOGGER.info("Process request: " + this.getRequestName() + " user '" + this.getUserCode() + "', trusted " + trustedClient + ", remote-host '" + this.remoteHost + "'.");
        try {
            VCSGisRepositoryLocaldbImpl repo = this.getRepository();
            URL url = this.getRepositoryURL(repo);
            if (url == null) {
                return this.error(801);
            }
            File folder = repo.getWorkingCopiesFolder(this);
            if (folder == null) {
                return this.getLastErrorCode();
            }
            File workspaceFile = FileUtils.getFile((File)folder, (String[])new String[]{this.getName()});
            String label = this.getLabel();
            List<String> categories = VCSGisUtils.getAsList(this.getCategories(), false);
            String username = this.getUserName();
            String userpass = this.getUserPass();
            if (repo.isAuthenticationRequired()) {
                if (StringUtils.isBlank((CharSequence)username)) {
                    return 19;
                }
                if (trustedClient) {
                    userpass = ((UsersRepoTable.UserRepoRow)this.getUser(username)).getPassword();
                }
            }
            DisposeUtils.bind((Disposable)repo);
            PrepareWorkingCopyTask task = new PrepareWorkingCopyTask(this.context, repo, url, workspaceFile, label, categories, username, userpass);
            task.start();
            return this.error(0);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't retrieve entities from '" + this.getRepository().getLabel() + "'.", (Throwable)ex);
            return this.error(800, "Can't prepare workspace.");
        }
    }

    private URL getRepositoryURL(VCSGisRepository repository) {
        ConfigRepoTable varsTable = new ConfigRepoTable();
        String repourl_s = varsTable.get((VCSGisRepositoryLocaldbImpl)repository, "REPOSITORY_URL");
        if (StringUtils.isBlank((CharSequence)repourl_s)) {
            return null;
        }
        URL repourl = null;
        try {
            repourl = new URL(repourl_s);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return repourl;
    }

    public String getName() {
        return this.helper().getName();
    }

    public String getLabel() {
        return this.helper().getLabel();
    }

    public String getCategories() {
        return this.helper().getCategories();
    }

    public String getUserName() {
        return this.helper().getUserName();
    }

    public String getUserPass() {
        return this.helper().getUserPass();
    }

    public void setCategories(String categories) {
        this.helper().setCategories(categories);
    }

    public void setLabel(String label) {
        this.helper().setLabel(label);
    }

    public void setName(String name) {
        this.helper().setName(name);
    }

    public void setUserPass(String pass) {
        this.helper().setUserPass(pass);
    }

    public void setUserName(String user) {
        this.helper().setUserName(user);
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$400() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$500() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$600() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$700() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$800() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$900() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1000() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1300() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1400() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1500() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1600() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1700() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1800() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1900() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$2000() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$2100() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$2200() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$2300() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$2400() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$2500() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$2600() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$2700() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$2800() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$2900() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$3000() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$3100() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$3200() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$3300() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$3400() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$3500() {
        return LOGGER;
    }

    private static class PrepareWorkingCopyTask
    extends Thread
    implements CancellableTask {
        private final VCSGisRepository repository;
        private final URL repositoryUrl;
        private final File workspaceFile;
        private final String label;
        private final List<String> categories;
        private final String username;
        private final String password;
        private boolean cancellationRequested;
        private long t1;
        private final PrepareWorkingCopyContext context;

        public PrepareWorkingCopyTask(PrepareWorkingCopyContext context, VCSGisRepository repository, URL repositoryUrl, File workspaceFile, String label, List<String> categories, String username, String password) {
            super("VCSGisPrepareWorkspace");
            this.context = context;
            this.repository = repository;
            this.repositoryUrl = repositoryUrl;
            this.workspaceFile = workspaceFile;
            this.label = label;
            this.categories = categories;
            this.username = username;
            this.password = password;
            this.cancellationRequested = false;
        }

        public boolean isCancellationRequested() {
            return this.cancellationRequested;
        }

        public void cancelRequest() {
            this.cancellationRequested = true;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 26[FORLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private long getEleapsedMins() {
            return (System.currentTimeMillis() - this.t1) / 1000L / 60L;
        }

        private boolean matchAny(List<String> categories, List<String> wilcardCategories, Collection<String> matcheds) {
            if (wilcardCategories == null || wilcardCategories.isEmpty()) {
                return false;
            }
            if (categories == null || categories.isEmpty()) {
                for (String wilcardCategory : wilcardCategories) {
                    if (!FilenameUtils.wildcardMatch((String)"", (String)wilcardCategory, (IOCase)IOCase.INSENSITIVE)) continue;
                    matcheds.add(wilcardCategory);
                    return true;
                }
            }
            if (categories != null) {
                for (String category : categories) {
                    for (String wilcardCategory : wilcardCategories) {
                        if (!FilenameUtils.wildcardMatch((String)category, (String)wilcardCategory, (IOCase)IOCase.INSENSITIVE)) continue;
                        matcheds.add(wilcardCategory);
                        return true;
                    }
                }
            }
            return false;
        }

        private void zipfiles(File zip, List<File> files) throws IOException, URISyntaxException {
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("create", "true");
            env.put("useTempFile", Boolean.TRUE);
            URIBuilder builder = new URIBuilder();
            builder.setScheme("jar");
            builder.setPath(zip.toURL().toString());
            URI uri = builder.build();
            try (FileSystem zipfs = FileSystems.newFileSystem(uri, env);){
                for (File target_file : files) {
                    if (this.isCancellationRequested()) {
                        LOGGER.info("Prepared working copy cancelled (" + this.getEleapsedMins() + "min).");
                        return;
                    }
                    Path target_path = zipfs.getPath(target_file.getName(), new String[0]);
                    Files.copy(target_file.toPath(), target_path, StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }

        private void updateVarsTable(URL repositoryUrl, VCSGisWorkspace workspace, List<String> categories, File zipfile) {
            VCSGisManager manager = VCSGisLocator.getVCSGisManager();
            VCSGisRepository remoteRepo = manager.openRepository(repositoryUrl);
            VarsTable config = new VarsTable();
            config.set(workspace, "REPOSITORY", remoteRepo.toJson().toString());
            config.set(workspace, "WORKSPACE_CODE", "CHANGE_ON_FIRST_USE");
            try {
                config.set(workspace, "PREPAREDWC_CATEGORIES", StringUtils.join(categories, (String)","));
            }
            catch (Exception ex) {
                LOGGER.warn("Can't set PREPAREDWC_CATEGORIES variable", (Throwable)ex);
            }
            try {
                config.set(workspace, "PREPAREDWC_NAME", FilenameUtils.removeExtension((String)zipfile.getName()));
            }
            catch (Exception ex) {
                LOGGER.warn("Can't set PREPAREDWC_NAME variable", (Throwable)ex);
            }
            try {
                config.set(workspace, "PREPAREDWC_TIME", new Timestamp(new Date().getTime()).toString());
            }
            catch (Exception ex) {
                LOGGER.warn("Can't set PREPAREDWC_TIME variable", (Throwable)ex);
            }
        }
    }

    public static interface PrepareWorkingCopyContext {
        public void addTask(CancellableTask var1);

        public void removeTask(CancellableTask var1);
    }
}

