/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.requests;

import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.vcsgis.lib.DisposableIterableAdapter;
import org.gvsig.vcsgis.lib.EntityEditableImpl;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryData;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.requests.AbstractRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.tables.DataRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.EntitiesRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.RevisionsRepoTable;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRevisionChangesRequest;
import org.gvsig.vcsgis.lib.requests.RevisionChangesRequestHelper;

public class RevisionChangesRequestLocaldb
extends AbstractRequestLocaldb
implements VCSGisRevisionChangesRequest {
    public RevisionChangesRequestLocaldb(VCSGisRepositoryLocaldbImpl repository, String entityName) {
        super(new RevisionChangesRequestHelper(repository, entityName));
    }

    @Override
    public RevisionChangesRequestHelper helper() {
        return (RevisionChangesRequestHelper)super.helper();
    }

    public String getEntityName() {
        return this.helper().getEntityName();
    }

    public String getLocalRevisionCode1() {
        return this.helper().getLocalRevisionCode1();
    }

    public void setLocalRevisionCode1(String revisionCode) {
        this.helper().setLocalRevisionCode1(revisionCode);
    }

    public String getLocalRevisionCode2() {
        return this.helper().getLocalRevisionCode2();
    }

    public void setLocalRevisionCode2(String revisionCode) {
        this.helper().setLocalRevisionCode2(revisionCode);
    }

    public VCSGisEntity getEntity() {
        return this.helper().getEntity();
    }

    public DisposableIterable<VCSGisRepositoryData> getData() {
        return this.helper().getData();
    }

    public int execute() {
        LOGGER.info("Process request: " + this.getRequestName() + " user '" + this.getUserCode() + "' entity '" + this.helper().entityName + "', localRevisionCode1 '" + this.helper().localRevisionCode1 + "', localRevisionCode2' " + this.helper().localRevisionCode2 + "'.");
        EntitiesRepoTable entitiesTable = new EntitiesRepoTable();
        EntitiesRepoTable.EntityRepoRow entityRow = entitiesTable.getByEntityName(this.getRepository(), this.helper().entityName);
        if (entityRow == null) {
            LOGGER.warn("Process request: " + this.getRequestName() + " entity '" + this.helper().entityName + "' not found.");
            return this.error(240, "Entity '" + this.helper().entityName + "' not exists.");
        }
        if (!this.isAuthorized((VCSGisEntity)entityRow)) {
            return this.getLastErrorCode();
        }
        this.helper().entity = new EntityEditableImpl();
        this.helper().entity.copyfrom((VCSGisEntity)entityRow);
        RevisionsRepoTable revisionsTable = new RevisionsRepoTable();
        DataRepoTable dataTable = this.getRepository().getDataRepoTable(this.helper().entity.getDataTableName());
        long revisionNumber1 = -1L;
        long revisionNumber2 = -1L;
        if (this.helper().localRevisionCode1 != null) {
            RevisionsRepoTable.RevisionRepoRow revision1 = revisionsTable.getByRevisionCode(this.getRepository(), this.helper().localRevisionCode1);
            if (revision1 == null) {
                return this.error(15);
            }
            revisionNumber1 = revision1.getNumber();
        }
        if (this.helper().localRevisionCode2 != null) {
            RevisionsRepoTable.RevisionRepoRow revision2 = revisionsTable.getByRevisionCode(this.getRepository(), this.helper().localRevisionCode2);
            if (revision2 == null) {
                return this.error(15);
            }
            revisionNumber2 = revision2.getNumber();
        }
        DisposableIterable<Feature> features = dataTable.getDataOfRevisions(this.getRepository(), this.helper().entity.getDataTableName(), this.helper().entity.getEntityCode(), revisionNumber1, revisionNumber2);
        this.helper().data = new DisposableIterableAdapter<Feature, VCSGisRepositoryData>(features, f -> new DataRepoTable.DataRepoRow(this.getRepository(), this.helper().entity.getDataTableName(), (Feature)f));
        return this.error(0);
    }

    public void notifyObservers(String tableName, String operation) {
    }

    public void addObserver(String tableName, String type, String operation, String command) {
    }
}

