/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.tables;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.JsonObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.vcsgis.lib.VCSGisCategories;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisEntityEditable;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.tables.AbstractRepoTable;

public class EntitiesRepoTable
extends AbstractRepoTable {
    public static final String TABLE_NAME = "VCSGISREPO_ENTITIES";
    public static final String COD_ENTITY = "COD_ENTITY";
    private static final String COD_USER = "COD_USER";
    private static final String COD_TOPOLOGYPLAN = "COD_TOPOLOGYPLAN";
    private static final String COD_REVISION = "COD_REVISION";
    public static final String ENTITY_NAME = "ENT_NAME";
    private static final String DATATABLE_NAME = "ENT_DATATABLE";
    private static final String FEATUREID_FIELD_NAME = "ENT_FEATURECODE";
    private static final String GEOMETRY_FIELD_NAME = "ENT_GEOMNAME";
    private static final String DESCRIPTION = "ENT_DESCRIPTION";
    private static final String FEATURETYPE = "ENT_FEATURETYPE";
    private static final String FIELD_FOR_LABEL = "ENT_FIELDFORLABEL";
    private static final String CATEGORY = "ENT_CATEGORY";
    private static final String LABEL = "ENT_LABEL";
    private static final String AUTHORIZATIONS = "ENT_AUTORIZATIONS";
    private static final String TOPOLOGYPLAN_MODE = "ENT_TOPOLOGYPLAN_MODE";
    public static final String RESOURCES = "ENT_RESOURCES";
    public static final String DATA_MODELS = "ENT_DATA_MODELS";
    public static final String ENT_PROJECTION = "ENT_PROJECTION";
    public static final String ENT_CUSTOMDATA = "ENT_CUSTOMDATA";

    public EntitiesRepoTable() {
        super(TABLE_NAME, EntitiesRepoTable.featureType());
    }

    public EntityRepoRow getByEntityCode(VCSGisRepositoryLocaldbImpl repository, String entityCode) {
        EntityRepoRow entityRepoRow;
        Feature f;
        FeatureStore store;
        block5: {
            store = null;
            store = repository.getFeatureStore(TABLE_NAME, true);
            f = store.findFirst("\"COD_ENTITY\"='" + entityCode + "'");
            if (f != null) break block5;
            EntityRepoRow entityRepoRow2 = null;
            DisposeUtils.disposeQuietly((Disposable)store);
            return entityRepoRow2;
        }
        try {
            EntityRepoRow row;
            entityRepoRow = row = new EntityRepoRow(repository, f);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve entity '" + entityCode + "'.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return entityRepoRow;
    }

    public EntityRepoRow getByEntityName(VCSGisRepositoryLocaldbImpl repository, String entityName) {
        EntityRepoRow entityRepoRow;
        Feature f;
        FeatureStore store;
        block5: {
            store = null;
            store = repository.getFeatureStore(TABLE_NAME, true);
            f = store.findFirst("\"ENT_NAME\"='" + entityName + "'");
            if (f != null) break block5;
            EntityRepoRow entityRepoRow2 = null;
            DisposeUtils.disposeQuietly((Disposable)store);
            return entityRepoRow2;
        }
        try {
            EntityRepoRow row;
            entityRepoRow = row = new EntityRepoRow(repository, f);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve entity '" + entityName + "'.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return entityRepoRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, EntityRepoRow> getAllAsMap(VCSGisRepositoryLocaldbImpl repository) {
        HashMap<String, EntityRepoRow> entitiesMap = new HashMap<String, EntityRepoRow>();
        DisposableFeatureSetIterable entities = null;
        try {
            entities = this.getAll(repository);
            for (Feature fentity : entities) {
                EntityRepoRow entity = new EntityRepoRow(repository, fentity);
                entitiesMap.put(entity.getCode(), entity);
            }
            HashMap<String, EntityRepoRow> hashMap = entitiesMap;
            return hashMap;
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)entities);
        }
    }

    public DisposableFeatureSetIterable getAll(VCSGisRepositoryLocaldbImpl repository) {
        FeatureStore store = null;
        try {
            DisposableFeatureSetIterable changes;
            store = repository.getFeatureStore(TABLE_NAME, true);
            DisposableFeatureSetIterable disposableFeatureSetIterable = changes = store.getFeatureSet().iterable();
            return disposableFeatureSetIterable;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve all entities.", ex);
        }
        finally {
            if (store != null) {
                DisposeUtils.dispose((Disposable)store);
            }
        }
    }

    public static final FeatureType featureType() {
        DataManager dataManager = DALLocator.getDataManager();
        EditableFeatureType ft = dataManager.createFeatureType();
        ft.setLabel("VCSGIS Entities");
        ft.getTags().set("ID", (Object)TABLE_NAME);
        ft.getTags().set("dynform.height", (Object)475);
        ft.getTags().set("dynform.width", (Object)570);
        ft.getTags().set("dynform.layoutmode", (Object)"tabs");
        ft.add(COD_ENTITY, 8).setSize(60).setIsPrimaryKey(true).setLabel("Code").setOrder(10);
        ft.add(COD_REVISION, 8).setForeingkey(true, false, "VCSGISREPO_REVISIONS", COD_REVISION, "FORMAT('r%d %s', REV_NUMBER, REV_OPERATIONDATE)").setIsIndexed(true).setAllowIndexDuplicateds(true).setSize(60).setLabel("Head revision of this entity").setOrder(40);
        ft.add(COD_USER, 8).setForeingkey(true, false, "VCSGISREPO_USERS", COD_USER, "USER_ID").setIsIndexed(true).setAllowIndexDuplicateds(true).setSize(60).setLabel("Cod. user").setOrder(30);
        ft.add(COD_TOPOLOGYPLAN, 8).setForeingkey(true, false, "VCSGISREPO_TOPOLOGYPLANS", COD_TOPOLOGYPLAN, "TOPP_NAME").setSize(60).setIsIndexed(true).setAllowIndexDuplicateds(true).setLabel("Topology plan").setOrder(90);
        ft.add(ENTITY_NAME, 8).setIsIndexed(true).setAllowIndexDuplicateds(false).setSize(200).setLabel("Name").setOrder(20);
        ft.add(DATATABLE_NAME, 8).setSize(200).setLabel("Name of the table in which the data is stored").setOrder(50);
        ft.add(FEATUREID_FIELD_NAME, 8).setSize(200).setLabel("Name of the primary key attribute.").setOrder(60);
        ft.add(GEOMETRY_FIELD_NAME, 8).setSize(200).setLabel("Name of the geometry attribute.").setOrder(70);
        ft.add(FIELD_FOR_LABEL, 8).setSize(200).setLabel("Field for label").setOrder(10);
        ft.add(CATEGORY, 8).setSize(200).setLabel("Category").setOrder(80);
        ft.add(LABEL, 8).setSize(200).setLabel("Label").setOrder(25);
        ft.add(AUTHORIZATIONS, 8).setTag("dynform.resizeWeight", (Object)60).setTag("dynform.label.empty", (Object)true).setDataProfileName("Text").setSize(4096).setLabel("Authorizations").setGroup("Authorizations").setOrder(10).setDefaultFieldValue((Object)"{\n  \"checkout\": [ \"*\" ],\n  \"commit\": [ \"*\" ],\n  \"view\": [ \"*\" ],\n  \"history\": [ \"*\" ],\n  \"update\": [ \"*\" ]\n}").setDescription("Json with the information of what operations the different users can do.\nExample:\n{\n  \"checkout\": [ \"user1\", \"user2\"],\n  \"commit\": [ \"user1\" ],\n  \"view\": [ \"user1\", \"user2\"],\n  \"history\": [ \"user1\" ],\n  \"update\": [ \"user1\", \"user2\"],\n  \"RowCreate\": [ \"batchuser1\"],\n  \"RowUpdate\": [ \"batchuser1\"],\n  \"RowDelete\": [ \"batchuser1\"],\n}\n\nuse $ before the name to indicate a role name instead of a username.");
        ft.add(DESCRIPTION, 8).setTag("dynform.resizeWeight", (Object)60).setDataProfileName("Text").setSize(4096).setLabel("Description").setOrder(110);
        ft.add(FEATURETYPE, 8).setTag("dynform.resizeWeight", (Object)60).setTag("dynform.label.empty", (Object)true).setDataProfileName("Text").setSize(4096).setLabel("Feature type").setGroup("Feature type").setOrder(10);
        ft.add(TOPOLOGYPLAN_MODE, 4).setLabel("Topology plan mode").setAvailableValues(new DynObjectValueItem[]{new DynObjectValueItem((Object)0, "Recommended"), new DynObjectValueItem((Object)1, "Mandatory")}).setOrder(100);
        ft.add(RESOURCES, 8).setSize(200).setLabel("Resources");
        ft.add(DATA_MODELS, 8).setSize(200).setLabel("Data models");
        ft.add(ENT_PROJECTION, 8).setSize(100).setLabel("Projection");
        ft.add(ENT_CUSTOMDATA, 8).setTag("dynform.resizeWeight", (Object)60).setTag("dynform.label.empty", (Object)true).setDataProfileName("Text").setSize(4096).setLabel("Custom data").setGroup("Custom data").setOrder(10);
        return ft.getNotEditableCopy();
    }

    public static class EntityRepoRow
    extends AbstractRepoTable.AbstractRow
    implements VCSGisEntityEditable {
        FeatureType featureType;
        private VCSGisCategories categories;

        public EntityRepoRow(VCSGisRepositoryLocaldbImpl repository) {
            super(repository, EntitiesRepoTable.TABLE_NAME, EntitiesRepoTable.COD_ENTITY, null);
        }

        public EntityRepoRow(VCSGisRepositoryLocaldbImpl repository, Feature feature) {
            super(repository, EntitiesRepoTable.TABLE_NAME, EntitiesRepoTable.COD_ENTITY, feature);
        }

        public String getEntityCode() {
            return super.getCode();
        }

        public VCSGisEntityEditable setEntityCode(String code) {
            super.setCode(code);
            return this;
        }

        public String getEntityName() {
            return this.feature.getString(EntitiesRepoTable.ENTITY_NAME);
        }

        public String getCRS() {
            return this.feature.getString(EntitiesRepoTable.ENT_PROJECTION);
        }

        public IProjection getCRSAsProjection() {
            String s = this.feature.getString(EntitiesRepoTable.ENT_PROJECTION);
            if (s == null) {
                return null;
            }
            try {
                return CRSFactory.getCRS((String)s);
            }
            catch (Exception ex) {
                return null;
            }
        }

        public String getRepositoryRevisionCode() {
            return this.feature.getString(EntitiesRepoTable.COD_REVISION);
        }

        public String getTopologyPlanCode() {
            return this.feature.getString(EntitiesRepoTable.COD_TOPOLOGYPLAN);
        }

        public String getUserCode() {
            return this.feature.getString(EntitiesRepoTable.COD_USER);
        }

        public String getDataTableName() {
            return this.feature.getString(EntitiesRepoTable.DATATABLE_NAME);
        }

        public String getFeatureIdFieldName() {
            return this.feature.getString(EntitiesRepoTable.FEATUREID_FIELD_NAME);
        }

        public String getGeometryFieldName() {
            return this.feature.getString(EntitiesRepoTable.GEOMETRY_FIELD_NAME);
        }

        public String getDescription() {
            return this.feature.getString(EntitiesRepoTable.DESCRIPTION);
        }

        public String getFieldForLabel() {
            return this.feature.getString(EntitiesRepoTable.FIELD_FOR_LABEL);
        }

        public String getCategory() {
            return this.feature.getString(EntitiesRepoTable.CATEGORY);
        }

        public VCSGisCategories getCategoriesAsList() {
            if (this.categories == null) {
                this.categories = new VCSGisCategories(this.getCategory());
            }
            return this.categories;
        }

        public Tags getCategoryTags(String category) {
            VCSGisCategories l = this.getCategoriesAsList();
            if (l == null) {
                return Tags.EMPTY_TAGS;
            }
            return l.getTags(category);
        }

        public String getFirstCategory() {
            VCSGisCategories l = this.getCategoriesAsList();
            if (CollectionUtils.isEmpty((Collection)l)) {
                return null;
            }
            return l.get(0);
        }

        public String getFirstDataModel() {
            List<String> l = this.getDataModelsAsList();
            if (CollectionUtils.isEmpty(l)) {
                return null;
            }
            return l.get(0);
        }

        public String getAuthorizations() {
            return this.feature.getString(EntitiesRepoTable.AUTHORIZATIONS);
        }

        public int getTopologyPlanMode() {
            return this.feature.getIntOrDefault(EntitiesRepoTable.TOPOLOGYPLAN_MODE, 0);
        }

        public String getLabel() {
            return this.feature.getString(EntitiesRepoTable.LABEL);
        }

        public String getFeatureTypeAsJson() {
            return this.feature.getString(EntitiesRepoTable.FEATURETYPE);
        }

        public FeatureType getFeatureType() {
            if (this.featureType == null) {
                JsonObject json = Json.createObject((String)this.getFeatureTypeAsJson());
                this.featureType = DALLocator.getDataManager().createFeatureType(json);
            }
            return this.featureType;
        }

        public VCSGisEntityEditable setEntityName(String entityName) {
            this.feature.set(EntitiesRepoTable.ENTITY_NAME, (Object)entityName);
            if (StringUtils.isBlank((CharSequence)this.getLabel())) {
                this.setLabel(entityName);
            }
            return this;
        }

        public VCSGisEntityEditable setCRS(IProjection projection) {
            return this.setCRS(projection.toString());
        }

        public VCSGisEntityEditable setCRS(String crs) {
            this.feature.set(EntitiesRepoTable.ENT_PROJECTION, (Object)crs);
            if (StringUtils.isBlank((CharSequence)this.getLabel())) {
                this.setLabel(crs);
            }
            return this;
        }

        public VCSGisEntityEditable setRepositoryRevisionCode(String code) {
            this.feature.set(EntitiesRepoTable.COD_REVISION, (Object)code);
            return this;
        }

        public VCSGisEntityEditable setDataTableName(String dataTableName) {
            this.feature.set(EntitiesRepoTable.DATATABLE_NAME, (Object)dataTableName);
            return this;
        }

        public VCSGisEntityEditable setFeatureIdFieldName(String name) {
            this.feature.set(EntitiesRepoTable.FEATUREID_FIELD_NAME, (Object)name);
            return this;
        }

        public VCSGisEntityEditable setGeometryFieldName(String name) {
            this.feature.set(EntitiesRepoTable.GEOMETRY_FIELD_NAME, (Object)name);
            return this;
        }

        public VCSGisEntityEditable setDescription(String description) {
            this.feature.set(EntitiesRepoTable.DESCRIPTION, (Object)description);
            return this;
        }

        public VCSGisEntityEditable setFieldForLabel(String fieldForLabel) {
            this.feature.set(EntitiesRepoTable.FIELD_FOR_LABEL, (Object)fieldForLabel);
            return this;
        }

        public VCSGisEntityEditable setFeatureTypeAsJson(String json) {
            this.feature.set(EntitiesRepoTable.FEATURETYPE, (Object)json);
            this.featureType = null;
            return this;
        }

        public void setFeatureType(FeatureType featureType) {
            this.feature.set(EntitiesRepoTable.FEATURETYPE, (Object)featureType.toJson().toString());
            this.featureType = featureType;
        }

        public VCSGisEntityEditable setTopologyPlanCode(String code) {
            this.feature.set(EntitiesRepoTable.COD_TOPOLOGYPLAN, (Object)code);
            return this;
        }

        public VCSGisEntityEditable setUserCode(String code) {
            this.feature.set(EntitiesRepoTable.COD_USER, (Object)code);
            return this;
        }

        public VCSGisEntityEditable setCategory(String category) {
            this.feature.set(EntitiesRepoTable.CATEGORY, (Object)category);
            return this;
        }

        public VCSGisEntityEditable setAuthorizations(String authorizations) {
            this.feature.set(EntitiesRepoTable.AUTHORIZATIONS, (Object)authorizations);
            return this;
        }

        public VCSGisEntityEditable setTopologyPlanMode(int topologyPlanMode) {
            this.feature.set(EntitiesRepoTable.TOPOLOGYPLAN_MODE, (Object)topologyPlanMode);
            return this;
        }

        public VCSGisEntityEditable setLabel(String label) {
            this.feature.set(EntitiesRepoTable.LABEL, (Object)label);
            return this;
        }

        public void copyfrom(VCSGisEntity entity) {
            VCSGisUtils.copy(entity, this, null);
        }

        public void copyto(VCSGisEntityEditable entity) {
            VCSGisUtils.copy((VCSGisEntity)this, entity, null);
        }

        public JsonObject toJson() {
            return VCSGisUtils.toJsonBuilder((VCSGisEntity)this, null).build();
        }

        public JsonObjectBuilder toJsonBuilder() {
            return VCSGisUtils.toJsonBuilder((VCSGisEntity)this, null);
        }

        public void fromJson(JsonObject json) {
            VCSGisUtils.fromJson(this, json);
        }

        public EntityRepoRow getValue() {
            return this;
        }

        public String toString() {
            return VCSGisUtils.getLabelOrName((VCSGisEntity)this);
        }

        public boolean isAuthorized(VCSGisUser user, String operation) {
            return VCSGisUtils.isAuthorized((VCSGisEntity)this, operation, user);
        }

        public VCSGisEntityEditable setResources(String resources) {
            this.feature.set(EntitiesRepoTable.RESOURCES, (Object)resources);
            return this;
        }

        public VCSGisEntityEditable setDataModels(String dataModels) {
            this.feature.set(EntitiesRepoTable.DATA_MODELS, (Object)dataModels);
            return this;
        }

        public String getResources() {
            return this.getString(EntitiesRepoTable.RESOURCES);
        }

        public String getDataModels() {
            return this.getString(EntitiesRepoTable.DATA_MODELS);
        }

        public List<String> getDataModelsAsList() {
            String s = this.getDataModels();
            return VCSGisUtils.getAsList(s, false);
        }

        public String getLabelOrName() {
            return VCSGisUtils.getLabelOrName((VCSGisEntity)this);
        }

        public boolean isLinkedTable() {
            return VCSGisUtils.isLinkedTable((VCSGisEntity)this);
        }

        public VCSGisRepository getLinkedRepository() {
            return VCSGisUtils.getLinkedRepository((VCSGisEntity)this);
        }

        public VCSGisEntityEditable setCustomData(String customData) {
            this.feature.set(EntitiesRepoTable.ENT_CUSTOMDATA, (Object)customData);
            return this;
        }

        public String getCustomData() {
            return this.getString(EntitiesRepoTable.ENT_CUSTOMDATA);
        }
    }
}

