/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.remoteclient.requests;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.Objects;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.apache.commons.io.IOUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.json.Json;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.vcsgis.lib.EntityEditableImpl;
import org.gvsig.vcsgis.lib.PipedIterator;
import org.gvsig.vcsgis.lib.SAJParserImpl;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisRepositoryDataImpl;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryData;
import org.gvsig.vcsgis.lib.repository.remoteclient.VCSGisRepositoryClientImpl;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.AbstractRequestClient;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisCheckoutRequest;
import org.gvsig.vcsgis.lib.requests.CheckoutRequestHelper;

public class CheckoutRequestClient
extends AbstractRequestClient
implements VCSGisCheckoutRequest {
    public CheckoutRequestClient(VCSGisRepositoryClientImpl repository, String entityName) {
        super(new CheckoutRequestHelper(repository, entityName), "checkout");
    }

    @Override
    public CheckoutRequestHelper helper() {
        return (CheckoutRequestHelper)super.helper();
    }

    public String getEntityName() {
        return this.helper().getEntityName();
    }

    public Timestamp getEfectiveDate() {
        return this.helper().getEfectiveDate();
    }

    public void setEfectiveDate(Timestamp efectiveDate) {
        this.helper().setEfectiveDate(efectiveDate);
    }

    public void setEfectiveDate(String efectiveDate) {
        this.helper().setEfectiveDate(efectiveDate);
    }

    public String getRevisionCode() {
        return this.helper().getRevisionCode();
    }

    public void setRevisionCode(String revisionCode) {
        this.helper().setRevisionCode(revisionCode);
    }

    public Envelope getROI() {
        return this.helper().getROI();
    }

    public void setROI(Envelope roi) {
        this.helper().setROI(roi);
    }

    public VCSGisEntity getEntity() {
        return this.helper().getEntity();
    }

    public DisposableIterable<VCSGisRepositoryData> getData() {
        return this.helper().getData();
    }

    public String getUsersHashCode() {
        return this.helper().usersHashCode;
    }

    public String getTopologyPlansHashCode() {
        return this.helper().topologyPlansHashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestProducer(Writer out) {
        try {
            LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 1");
            org.gvsig.json.JsonObjectBuilder parametersBuilder = Json.createObjectBuilder();
            parametersBuilder.add("EntityName", this.getEntityName());
            parametersBuilder.add("EfectiveDate", Objects.toString(this.getEfectiveDate(), null));
            parametersBuilder.add("RevisionCode", this.getRevisionCode());
            Envelope roi = this.getROI();
            if (roi != null) {
                parametersBuilder.add("ROI", roi.getGeometry().convertToHexWKB());
                parametersBuilder.add("ROIProjection", roi.getGeometry().getProjection().getAbrev());
            }
            org.gvsig.json.JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("Parameters", (JsonObjectBuilder)parametersBuilder);
            IOUtils.write((String)builder.toString(), (Writer)out);
            this.error(0);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't produce Json data for " + this.getRequestName() + ".", (Throwable)ex);
            this.error(600, "Can't produce Json data for " + this.getRequestName() + ". " + ex.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Writer)out);
        }
    }

    @Override
    public void responseConsumer(BufferedReader request_contents) {
        LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer 1");
        PipedIterator<VCSGisRepositoryData> dataIterator = new PipedIterator<VCSGisRepositoryData>(this.getRepository().getTimeoutForReceiveElements());
        this.helper().data = dataIterator;
        LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer 2");
        SAJParserImpl parser = new SAJParserImpl(request_contents, (context, e, value) -> {
            if (e == null) {
                return;
            }
            switch (e) {
                case END_OBJECT: {
                    switch (context.getPathName()) {
                        case "/Parameters": {
                            JsonObject jsonParams = ((JsonObjectBuilder)value).build();
                            this.helper().error(jsonParams.getInt("StatusCode", 0), jsonParams.getString("StatusMessage", null));
                            this.helper().entity = jsonParams.isNull("Entity") ? null : new EntityEditableImpl(jsonParams.getJsonObject("Entity"));
                            this.helper().usersHashCode = jsonParams.getString("UsershashCode", null);
                            this.helper().topologyPlansHashCode = jsonParams.getString("TopologyPlansHashCode", null);
                            this.notifyResponseConsumers();
                            break;
                        }
                        case "/Data/?": {
                            JsonObject jsonData = ((JsonObjectBuilder)value).build();
                            VCSGisRepositoryDataImpl data = new VCSGisRepositoryDataImpl(jsonData);
                            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer data = " + jsonData.toString());
                            dataIterator.put(data);
                        }
                    }
                    break;
                }
                case END_ARRAY: {
                    if (!"/Data".equals(context.getPathName())) break;
                    dataIterator.close();
                    break;
                }
                case START_ARRAY: {
                    switch (context.getPathName()) {
                        case "/Data": {
                            context.setArrayBuilder(null);
                        }
                    }
                }
            }
        });
        parser.parse();
        LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer 3 (parse)");
        IOUtils.closeQuietly((Reader)request_contents);
    }
}

