/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.remoteclient.requests;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.vcsgis.lib.DisposableIterableAdapter;
import org.gvsig.vcsgis.lib.VCSGisChange;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisEntityEditable;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlanStatus;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.remoteclient.VCSGisRepositoryClientImpl;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.AbstractRequestClient;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisCommitRequest;
import org.gvsig.vcsgis.lib.requests.CommitRequestHelper;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntityImpl;

public class CommitRequestClient
extends AbstractRequestClient
implements VCSGisCommitRequest {
    public CommitRequestClient(VCSGisRepositoryClientImpl repository) {
        super(new CommitRequestHelper(repository), "commit");
    }

    @Override
    public CommitRequestHelper helper() {
        return (CommitRequestHelper)super.helper();
    }

    public Timestamp getEfectiveDate() {
        return this.helper().getEfectiveDate();
    }

    public void setEfectiveDate(Timestamp efectiveDate) {
        this.helper().setEfectiveDate(efectiveDate);
    }

    public Timestamp getRevisionDate() {
        return this.helper().getRevisionDate();
    }

    public void setRevisionDate(Timestamp revisionDate) {
        this.helper().setRevisionDate(revisionDate);
    }

    public String getComment() {
        return this.helper().getComment();
    }

    public void setComment(String comment) {
        this.helper().setComment(comment);
    }

    public VCSGisWorkspaceEntity createEntity(String code, String name) {
        return this.helper().createEntity(code, name);
    }

    public VCSGisWorkspaceEntity createEntity(VCSGisWorkspaceEntity entity) {
        return this.helper().createEntity(entity);
    }

    public void add(VCSGisWorkspaceEntity entity) {
        this.helper().add(entity);
    }

    public void add(DisposableIterable<VCSGisChange> changes) {
        this.helper().add(changes);
    }

    public void markAsNew(VCSGisEntity entity) {
        this.helper().markAsNew(entity);
    }

    public void markAsNew(String entityCode) {
        this.helper().markAsNew(entityCode);
    }

    public boolean hasNewEntities() {
        return this.helper().hasNewEntities();
    }

    public List<VCSGisWorkspaceEntity> getChangedLocalEntities() {
        return this.helper().getChangedLocalEntities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestProducer(Writer out) {
        LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer");
        I18nManager i18n = ToolsLocator.getI18nManager();
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Commit"));
        status.setAutoremove(true);
        status.add();
        JsonGenerator gen = null;
        try {
            JsonGeneratorFactory genFactory = Json.createGeneratorFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));
            gen = genFactory.createGenerator(out);
            gen.writeStartObject();
            gen.writeStartObject("Parameters");
            if (this.getEfectiveDate() == null) {
                gen.writeNull("EfectiveDate");
            } else {
                gen.write("EfectiveDate", this.getEfectiveDate().toString());
            }
            if (this.getRevisionDate() == null) {
                gen.writeNull("RevisionDate");
            } else {
                gen.write("RevisionDate", this.getRevisionDate().toString());
            }
            LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 6 notifyRequestConsumers");
            this.notifyRequestConsumers();
            if (this.getComment() == null) {
                gen.writeNull("Comment");
            } else {
                gen.write("Comment", this.getComment());
            }
            LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 2");
            gen.writeStartArray("Entities");
            for (VCSGisEntityEditable vCSGisEntityEditable : this.helper().changedLocalEntities) {
                LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 3 entity " + vCSGisEntityEditable.getEntityName());
                status.message("_Sending_metadata_table '" + vCSGisEntityEditable.getEntityName() + "'");
                if (this.helper().newLocalEntities.contains(vCSGisEntityEditable.getEntityCode())) {
                    gen.write((JsonValue)vCSGisEntityEditable.toJson());
                    continue;
                }
                gen.write((JsonValue)VCSGisUtils.toJsonBuilder((VCSGisEntity)vCSGisEntityEditable, t -> StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"FeatureTypeAsJson") || StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"Authorizations") || StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"DataTableName") || StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"Description") || StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"FeatureIdFieldName") || StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"FieldForLabel") || StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"GeometryFieldName") || StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"TopologyPlanCode") || StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"UserCode") || StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"Category") || StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"Label") || StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"TopologyPlanMode") || StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"Resources") || StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"DataModels") || StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"CRS") || StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"customdata") || StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"RevisionCode")).build());
            }
            gen.writeEnd();
            LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 4");
            gen.writeStartArray("NewEntityCodes");
            for (String string : this.helper().newLocalEntities) {
                LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 5 new entity " + string);
                gen.write(string);
            }
            gen.writeEnd();
            LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 5");
            if (!CollectionUtils.isEmpty(this.helper().getTopologyPlanStatus())) {
                gen.writeStartArray("TopologyPlans");
                for (VCSGisTopologyPlanStatus vCSGisTopologyPlanStatus : this.helper().getTopologyPlanStatus()) {
                    LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 3 topologyPlanStatus " + vCSGisTopologyPlanStatus.getTopologyPlanCode());
                    status.message("_Sending_topology_plans '" + vCSGisTopologyPlanStatus.getTopologyPlanCode() + "'");
                    gen.write((JsonValue)vCSGisTopologyPlanStatus.toJson());
                }
                gen.writeEnd();
            }
            gen.writeEnd();
            status.message(i18n.getTranslation("_Committing_changes"));
            gen.writeStartArray("Data");
            if (this.helper().changes != null) {
                if (this.helper().changes instanceof DisposableIterableAdapter) {
                    status.setRangeOfValues(0L, ((DisposableIterableAdapter)this.helper().changes).size64());
                } else {
                    status.setIndeterminate();
                }
                status.setCurValue(0L);
                for (VCSGisChange vCSGisChange : this.helper().changes) {
                    JsonObjectBuilder jsonChange = Json.createObjectBuilder();
                    jsonChange.add("Code", vCSGisChange.getCode());
                    jsonChange.add("EntityCode", vCSGisChange.getEntityCode());
                    jsonChange.add("Operation", vCSGisChange.getOperation());
                    jsonChange.add("RelatedFeatureCode", vCSGisChange.getRelatedFeatureCode());
                    jsonChange.add("Data", vCSGisChange.getRelatedFeatureData());
                    LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 7 change " + vCSGisChange.getLabel());
                    gen.write((JsonValue)jsonChange.build());
                    gen.flush();
                    out.flush();
                    status.incrementCurrentValue();
                }
            }
            gen.writeEnd();
            gen.writeEnd();
            LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 8 flush");
            gen.flush();
            LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 9 flush");
            out.flush();
            status.message(i18n.getTranslation("_Data_sent"));
            LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 10 return");
            status.terminate();
            this.error(0);
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Can't produce Json data for commit request.", (Throwable)ex);
                status.abort();
                this.error(500, "Can't produce Json data for commit request. " + ex.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gen);
                IOUtils.closeQuietly((Writer)out);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)gen);
            IOUtils.closeQuietly((Writer)out);
        }
        IOUtils.closeQuietly((Closeable)gen);
        IOUtils.closeQuietly((Writer)out);
    }

    @Override
    public void responseConsumer(BufferedReader responseContents) {
        try {
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer 1");
            JsonReader reader = Json.createReader((Reader)responseContents);
            JsonObject jsonResponse = reader.readObject();
            JsonObject jsonParameters = jsonResponse.getJsonObject("Parameters");
            int statusCode = jsonParameters.getInt("StatusCode", 500);
            if (statusCode != 0) {
                LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer 2 error " + statusCode);
                this.error(statusCode, jsonParameters.getString("StatusMessage", VCSGisUtils.getErrorMessage(statusCode)));
                return;
            }
            this.cleanLastError();
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer 3");
            ArrayList<VCSGisWorkspaceEntity> changedEntities = new ArrayList<VCSGisWorkspaceEntity>();
            JsonArray jsonChangedLocalEntities = jsonParameters.getJsonArray("Entities");
            for (JsonValue jsonEntity : jsonChangedLocalEntities) {
                VCSGisWorkspaceEntityImpl rentity = new VCSGisWorkspaceEntityImpl();
                rentity.fromJson((JsonObject)jsonEntity);
                LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer 4 entity " + rentity.getEntityName());
                changedEntities.add(rentity);
            }
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer 5");
            this.helper().changedLocalEntities = changedEntities;
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer 6 return");
            this.error(0);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't process Json data from commit response.", (Throwable)ex);
            this.error(500, "Can't process Json data from commit response. " + ex.getMessage());
        }
    }

    public void add(VCSGisTopologyPlanStatus topologyPlanStatus) {
        this.helper().add(topologyPlanStatus);
    }

    public Collection<VCSGisTopologyPlanStatus> getTopologyPlanStatus() {
        return this.helper().getTopologyPlanStatus();
    }
}

