/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.requests;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.VCSGisChange;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisEntityEditable;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlanStatus;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisCommitRequest;
import org.gvsig.vcsgis.lib.requests.AbstractRequestHelper;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntityImpl;

public class CommitRequestHelper
extends AbstractRequestHelper
implements VCSGisCommitRequest {
    private static final String REQUEST_NAME = "Commit";
    public Set<String> newLocalEntities = new HashSet<String>();
    public Timestamp efectiveDate = null;
    public Timestamp revisionDate;
    public String comment = null;
    public DisposableIterable<VCSGisChange> changes = null;
    public Map<String, VCSGisTopologyPlanStatus> topologyPlanStatusMap;
    public List<VCSGisWorkspaceEntity> changedLocalEntities = new ArrayList<VCSGisWorkspaceEntity>();

    public CommitRequestHelper(VCSGisRepository repository) {
        super(repository, REQUEST_NAME);
        this.topologyPlanStatusMap = new HashMap<String, VCSGisTopologyPlanStatus>();
    }

    public VCSGisWorkspaceEntity createEntity(String code, String name) {
        VCSGisWorkspaceEntityImpl entity = new VCSGisWorkspaceEntityImpl();
        entity.setEntityCode(code);
        entity.setEntityName(name);
        return entity;
    }

    public VCSGisWorkspaceEntity createEntity(VCSGisWorkspaceEntity fromEntity) {
        VCSGisWorkspaceEntityImpl entity = new VCSGisWorkspaceEntityImpl();
        entity.copyfrom((VCSGisEntity)fromEntity);
        return entity;
    }

    public List<VCSGisWorkspaceEntity> getChangedLocalEntities() {
        return this.changedLocalEntities;
    }

    public VCSGisEntityEditable getChangedLocalEntityByName(String name) {
        for (VCSGisEntityEditable vCSGisEntityEditable : this.changedLocalEntities) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)vCSGisEntityEditable.getEntityName())) continue;
            return vCSGisEntityEditable;
        }
        return null;
    }

    public VCSGisEntityEditable getChangedLocalEntityByCode(String code) {
        for (VCSGisEntityEditable vCSGisEntityEditable : this.changedLocalEntities) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)code, (CharSequence)vCSGisEntityEditable.getEntityCode())) continue;
            return vCSGisEntityEditable;
        }
        return null;
    }

    public void markAsNew(VCSGisEntity entity) {
        this.markAsNew(entity.getEntityCode());
    }

    public void markAsNew(String entityCode) {
        if (this.newLocalEntities.contains(entityCode)) {
            return;
        }
        if (this.getChangedLocalEntityByCode(entityCode) == null) {
            throw new IllegalArgumentException("Entity not added to commit");
        }
        this.newLocalEntities.add(entityCode);
    }

    public void add(VCSGisWorkspaceEntity entity) {
        if (this.getChangedLocalEntityByCode(entity.getEntityCode()) != null) {
            if (this.newLocalEntities.contains(entity.getEntityCode())) {
                return;
            }
            throw new IllegalArgumentException("Entity already added to commit");
        }
        this.changedLocalEntities.add(entity);
    }

    public Timestamp getEfectiveDate() {
        return this.efectiveDate;
    }

    public void setEfectiveDate(Timestamp efectiveDate) {
        this.efectiveDate = efectiveDate;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void add(DisposableIterable<VCSGisChange> changes) {
        this.changes = changes;
    }

    @Override
    public void dispose() {
        DisposeUtils.disposeQuietly(this.changes);
        this.changes = null;
        this.changedLocalEntities = null;
        this.newLocalEntities = null;
    }

    public Timestamp getRevisionDate() {
        return this.revisionDate;
    }

    public void setRevisionDate(Timestamp revisionDate) {
        this.revisionDate = revisionDate;
    }

    public void add(VCSGisTopologyPlanStatus topologyPlanStatus) {
        this.topologyPlanStatusMap.put(topologyPlanStatus.getTopologyPlanCode(), topologyPlanStatus);
    }

    public Collection<VCSGisTopologyPlanStatus> getTopologyPlanStatus() {
        return this.topologyPlanStatusMap.values();
    }

    public boolean hasNewEntities() {
        return CollectionUtils.isNotEmpty(this.newLocalEntities);
    }
}

