/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.handlers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.json.JsonArrayBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisEntitiesRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.server.handlers.AbstractVCSGisServertHandler;

public class EntitiesHandler
extends AbstractVCSGisServertHandler {
    public EntitiesHandler(VCSGisRepository repository) {
        super(repository, "EntitiesHandler");
    }

    @Override
    protected void requestProducer(MutableObject<VCSGisRequest> req, Map<String, String> params, Reader request_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 1");
        VCSGisEntitiesRequest request = this.getRepository().createEntitiesRequest();
        request.setAuthenticationTokenAndUser(params);
        req.setValue((Object)request);
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 2 notifyRequestConsumers");
        this.notifyRequestConsumers();
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 3 return");
    }

    @Override
    protected void responseProducer(VCSGisRequest req, Writer response_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  1");
        VCSGisEntitiesRequest request = (VCSGisEntitiesRequest)req;
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  3");
        List entities = request.getRepositoryEntities();
        org.gvsig.json.JsonArrayBuilder jsonEntities = Json.createArrayBuilder();
        for (VCSGisEntity entity : entities) {
            LOGGER.debug("===: [" + this.getName() + "] responseProducer  4 entity " + entity.getEntityName());
            JsonObjectBuilder builder = VCSGisUtils.toJsonBuilder(entity, t -> StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"Authorizations"));
            jsonEntities.add((javax.json.JsonObjectBuilder)builder);
        }
        JsonObjectBuilder jsonResponse = Json.createObjectBuilder();
        JsonObjectBuilder jsonParams = Json.createObjectBuilder();
        jsonParams.add("StatusCode", 0);
        jsonParams.addNull("StatusMessage");
        jsonParams.add("Entities", (JsonArrayBuilder)jsonEntities);
        jsonResponse.add("Parameters", (javax.json.JsonObjectBuilder)jsonParams);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  5 notifyResponseConsumers");
        this.notifyResponseConsumers();
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  6 write json");
        IOUtils.write((String)jsonResponse.toString(), (Writer)response_contents);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  7 flush");
        response_contents.flush();
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  8 close");
        IOUtils.closeQuietly((Writer)response_contents);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  9 return");
    }
}

