/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.handlers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.json.JsonArrayBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.vcsgis.lib.VCSGisPreparedWorkingCopyInformation;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisListWCRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.server.handlers.AbstractVCSGisServertHandler;

public class ListWCHandler
extends AbstractVCSGisServertHandler {
    public ListWCHandler(VCSGisRepository repository) {
        super(repository, "ListWCHandler");
    }

    @Override
    protected void requestProducer(MutableObject<VCSGisRequest> req, Map<String, String> params, Reader request_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 1");
        VCSGisListWCRequest request = this.getRepository().createListWCRequest();
        request.setAuthenticationTokenAndUser(params);
        req.setValue((Object)request);
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 2 notifyRequestConsumers");
        this.notifyRequestConsumers();
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 3 return");
    }

    @Override
    protected void responseProducer(VCSGisRequest req, Writer response_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  1");
        VCSGisListWCRequest request = (VCSGisListWCRequest)req;
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  3");
        List workspaces = request.getWorkingCopiesInformation();
        org.gvsig.json.JsonArrayBuilder jsonWorkspaces = Json.createArrayBuilder();
        for (VCSGisPreparedWorkingCopyInformation workspace : workspaces) {
            LOGGER.debug("===: [" + this.getName() + "] responseProducer  4 workspace " + workspace.getName());
            jsonWorkspaces.add((javax.json.JsonObjectBuilder)workspace.toJsonBuilder());
        }
        JsonObjectBuilder jsonResponse = Json.createObjectBuilder();
        JsonObjectBuilder jsonParams = Json.createObjectBuilder();
        jsonParams.add("StatusCode", 0);
        jsonParams.addNull("StatusMessage");
        jsonParams.add("WorkingCopiesInformation", (JsonArrayBuilder)jsonWorkspaces);
        jsonResponse.add("Parameters", (javax.json.JsonObjectBuilder)jsonParams);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  5 notifyResponseConsumers");
        this.notifyResponseConsumers();
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  6 write json");
        IOUtils.write((String)jsonResponse.toString(), (Writer)response_contents);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  7 flush");
        response_contents.flush();
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  8 close");
        IOUtils.closeQuietly((Writer)response_contents);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  9 return");
    }
}

