/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.workspace.tables;

import java.sql.Timestamp;
import java.util.Date;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.util.GetItemWithSizeAndIterator64;
import org.gvsig.tools.util.GetItemWithSizeIsEmptyAndIterator64;
import org.gvsig.vcsgis.lib.VCSGisRevision;
import org.gvsig.vcsgis.lib.VCSGisRevisionImpl;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.tables.AbstractTable;

public class LocalRevisionsTable
extends AbstractTable {
    public static final String TABLE_NAME = "VCSGIS_LOCALREVISIONS";
    public static final String COD_REVISION = "COD_REVISION";
    public static final String COD_USER = "COD_USER";
    public static final String COD_ENTITY = "COD_ENTITY";
    public static final String REVISION_NUMBER = "REV_NUMBER";
    private static final String REVISION_COMMENT = "REV_COMMENT";
    public static final String REVISION_EFECTIVEDATE = "REV_EFECTIVEDATE";
    public static final String REVISION_DATE = "REV_OPERATIONDATE";
    private static final String REVISION_TAGS = "REV_TAGS";
    private static final String REVISION_GROUP = "REV_IDENTIFIER";
    private static final String REVISION_TOPOLOGYPLAN = "REV_TOPPLAN";
    private static final String REVISION_CHANGESCOUNT = "REV_CHANGESCOUNT";

    public LocalRevisionsTable() {
        super(TABLE_NAME, LocalRevisionsTable.featureType());
    }

    public static final FeatureType featureType() {
        DataManager dataManager = DALLocator.getDataManager();
        EditableFeatureType ft = dataManager.createFeatureType();
        ft.setLabel("VCSGIS Revisions");
        ft.getTags().set("ID", (Object)TABLE_NAME);
        ft.add(COD_REVISION, 8).setSize(60).setIsPrimaryKey(true).setLabel("Code");
        ft.add(COD_USER, 8).setIsIndexed(true).setAllowIndexDuplicateds(true).setSize(60).setLabel("Cod. user");
        ft.add(COD_ENTITY, 8).setIsIndexed(true).setAllowIndexDuplicateds(true).setSize(60).setLabel("Cod. entity");
        ft.add(REVISION_GROUP, 8).setIsIndexed(true).setAllowIndexDuplicateds(true).setSize(40).setLabel("Group");
        ft.add(REVISION_DATE, 11).setIsIndexed(true).setAllowIndexDuplicateds(true).setLabel("Revision date");
        ft.add(REVISION_EFECTIVEDATE, 11).setIsIndexed(true).setAllowIndexDuplicateds(true).setLabel("Efective date");
        ft.add(REVISION_NUMBER, 5).setIsIndexed(true).setAllowIndexDuplicateds(true).setLabel("Revision number");
        ft.add(REVISION_TOPOLOGYPLAN, 4).setIsIndexed(false).setLabel("Topology plan").setAvailableValues(new DynObjectValueItem[]{new DynObjectValueItem((Object)0, "Unknown"), new DynObjectValueItem((Object)1, "Passed"), new DynObjectValueItem((Object)2, "Not passed")});
        ft.add(REVISION_TAGS, 8).setSize(200).setLabel("Tags");
        ft.add(REVISION_COMMENT, 8).setSize(200).setLabel("Comment");
        ft.add(REVISION_CHANGESCOUNT, 5).setIsIndexed(false).setLabel("Changes count");
        return ft.getNotEditableCopy();
    }

    public LocalRevisionsTable(String tableName, FeatureType featureType) {
        super(tableName, featureType);
    }

    public void deleteByEntityCodeAndGroup(VCSGisWorkspace workspace, FeatureStore store, String entityCode, String group) {
        store.delete("\"COD_ENTITY\" = '" + entityCode + "' AND \"" + REVISION_GROUP + "\" = '" + group + "'");
    }

    public GetItemWithSizeAndIterator64<Feature> getRevisions(VCSGisWorkspace workspace, String entityCode, String group, String filter) {
        FeatureStore store = null;
        try {
            GetItemWithSizeIsEmptyAndIterator64 revisions;
            store = workspace.getFeatureStore(TABLE_NAME);
            String condition = "\"COD_ENTITY\" = '" + entityCode + "' AND \"" + REVISION_GROUP + "\" = '" + group + "'";
            if (StringUtils.isNotBlank((CharSequence)filter)) {
                condition = condition + "AND (" + filter + ")";
            }
            GetItemWithSizeIsEmptyAndIterator64 getItemWithSizeIsEmptyAndIterator64 = revisions = store.getFeatures64(condition, "\"REV_NUMBER\"", true);
            return getItemWithSizeIsEmptyAndIterator64;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve changes by entity.", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public static class LocalRevisionRow
    extends AbstractTable.AbstractRow
    implements VCSGisRevision {
        public LocalRevisionRow(VCSGisWorkspace workspace) {
            super(workspace, LocalRevisionsTable.TABLE_NAME, LocalRevisionsTable.COD_REVISION);
        }

        public LocalRevisionRow(VCSGisWorkspace workspace, Feature feature) {
            super(workspace, LocalRevisionsTable.TABLE_NAME, LocalRevisionsTable.COD_REVISION, feature);
        }

        public String getGroup() {
            return this.getString(LocalRevisionsTable.REVISION_GROUP);
        }

        public String getUserCode() {
            return this.getString(LocalRevisionsTable.COD_USER);
        }

        public String getRevisionCode() {
            return this.getCode();
        }

        public Timestamp getRevisionDate() {
            return this.getTimestamp(LocalRevisionsTable.REVISION_DATE);
        }

        public Timestamp getEfectiveDate() {
            return this.getTimestamp(LocalRevisionsTable.REVISION_EFECTIVEDATE);
        }

        public int getTopologyPlan() {
            return this.getInt(LocalRevisionsTable.REVISION_TOPOLOGYPLAN);
        }

        public String getTags() {
            return this.getString(LocalRevisionsTable.REVISION_TAGS);
        }

        public long getNumber() {
            return this.getLong(LocalRevisionsTable.REVISION_NUMBER);
        }

        public String getComment() {
            return this.getString(LocalRevisionsTable.REVISION_COMMENT);
        }

        public String getEntityCode() {
            return this.getString(LocalRevisionsTable.COD_ENTITY);
        }

        public long getChangesCount() {
            return this.getLong(LocalRevisionsTable.REVISION_CHANGESCOUNT);
        }

        public void setChangesCount(long changesCount) {
            this.set(LocalRevisionsTable.REVISION_CHANGESCOUNT, changesCount);
        }

        public void setGroup(String group) {
            this.set(LocalRevisionsTable.REVISION_GROUP, group);
        }

        public void setUserCode(String code) {
            this.set(LocalRevisionsTable.COD_USER, code);
        }

        public void setRevisionDate(Timestamp date) {
            this.set(LocalRevisionsTable.REVISION_DATE, date);
        }

        public void setEfectiveDate(Timestamp date) {
            this.set(LocalRevisionsTable.REVISION_EFECTIVEDATE, date);
        }

        public void setRevisionDate(Date date) {
            Timestamp tm = new Timestamp(date.getTime());
            this.set(LocalRevisionsTable.REVISION_DATE, tm);
        }

        public void setEfectiveDate(Date date) {
            Timestamp tm = new Timestamp(date.getTime());
            this.set(LocalRevisionsTable.REVISION_EFECTIVEDATE, tm);
        }

        public void setTopologyPlan(int topologyPlan) {
            this.set(LocalRevisionsTable.REVISION_TOPOLOGYPLAN, topologyPlan);
        }

        public void setTags(String tags) {
            this.set(LocalRevisionsTable.REVISION_TAGS, tags);
        }

        public void setComment(String comment) {
            this.set(LocalRevisionsTable.REVISION_COMMENT, comment);
        }

        public void setEntityCode(String code) {
            this.set(LocalRevisionsTable.COD_ENTITY, code);
        }

        public void setNumber(long number) {
            this.set(LocalRevisionsTable.REVISION_NUMBER, number);
        }

        public void copyFrom(VCSGisRevision other) {
            this.setCode(other.getRevisionCode());
            this.setComment(other.getComment());
            this.setEfectiveDate(other.getEfectiveDate());
            this.setEntityCode(other.getEntityCode());
            this.setRevisionDate(other.getRevisionDate());
            this.setTags(other.getTags());
            this.setUserCode(other.getUserCode());
            this.setNumber(other.getNumber());
            this.setTopologyPlan(other.getTopologyPlan());
            this.setChangesCount(other.getChangesCount());
        }

        public LocalRevisionRow getValue() {
            return this;
        }

        public String getLabel() {
            return VCSGisRevisionImpl.getLabel(this);
        }

        public JsonObject toJson() {
            return this.toJsonBuilder().build();
        }

        public JsonObjectBuilder toJsonBuilder() {
            return VCSGisRevisionImpl.toJsonBuilder(this);
        }

        public String toString() {
            return VCSGisRevisionImpl.toString(this);
        }

        public boolean exists(FeatureStore store) {
            try {
                Feature f = store.findFirst("\"COD_REVISION\" = '" + this.getCode() + "'");
                return f != null;
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't check if revision exists.", ex);
            }
        }
    }
}

