/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.spi.simpleprovider;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.fmap.dal.DALFileLocator;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.SimpleSequentialReader;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.SimpleSequentialReaderFactory;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.SimpleSequentialReaderFilesystemServerProviderFactory;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.SimpleSequentialReaderStoreParameters;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.SimpleSequentialReaderStoreProviderFactory;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderFactory;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.metadata.MetadataManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.util.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSimpleSequentialReaderFactory
implements SimpleSequentialReaderFactory {
    protected Logger LOGGER = LoggerFactory.getLogger(AbstractSimpleSequentialReaderFactory.class);
    private final String name;
    private final String description;
    private final String[] extensions;

    protected AbstractSimpleSequentialReaderFactory(String name, String description, String[] extensions) {
        this.name = name;
        this.description = description;
        this.extensions = extensions;
    }

    protected Logger logger() {
        return this.LOGGER;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String[] getExtensions() {
        return this.extensions;
    }

    @Override
    public final boolean isValidExtension(File f) {
        if (f == null) {
            return false;
        }
        String[] theExtensions = this.getExtensions();
        if (theExtensions == null) {
            return true;
        }
        String extension = FilenameUtils.getExtension((String)f.getName()).trim();
        if (extension.isEmpty()) {
            return true;
        }
        for (String currentExtension : theExtensions) {
            if (currentExtension == null || (currentExtension = currentExtension.trim()).isEmpty() || !extension.equalsIgnoreCase(currentExtension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File f) {
        return this.isValidExtension(f);
    }

    @Override
    public FeatureStoreProviderFactory createStoreProviderFactory() {
        return new SimpleSequentialReaderStoreProviderFactory(this);
    }

    @Override
    public FilesystemServerExplorerProviderFactory createFilesystemServerProviderFactory() {
        return new SimpleSequentialReaderFilesystemServerProviderFactory(this);
    }

    private InputStream openStream(URL url) {
        return URLUtils.openStream((URL)url);
    }

    @Override
    public void selfRegister(Class loader) {
        this.selfRegister(loader.getResource(this.getName() + "Parameters.xml"), loader.getResource(this.getName() + "Metadata.xml"));
    }

    @Override
    public void selfRegister(URL parameters_xml, URL metadata_xml) {
        DataManagerProviderServices dataman;
        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
        DynStruct definition = persistenceManager.getDefinition(this.getName());
        if (definition == null) {
            InputStream stream = this.openStream(parameters_xml);
            if (stream == null) {
                throw new RuntimeException("Can't access parameters definition in resource '" + parameters_xml.toString() + "'.");
            }
            persistenceManager.updateDefinition(SimpleSequentialReaderStoreParameters.class, this.getName(), stream, SimpleSequentialReaderStoreParameters.class.getClassLoader(), null, null);
        }
        if (metadata_xml != null) {
            MetadataManager metadataManager = MetadataLocator.getMetadataManager();
            try {
                definition = metadataManager.getDefinition(this.getName());
                if (definition == null) {
                    InputStream stream = this.openStream(metadata_xml);
                    metadataManager.addDefinition(this.getName(), stream, SimpleSequentialReaderStoreParameters.class.getClassLoader());
                }
            }
            catch (Exception e) {
                this.LOGGER.warn("Can't access metadata definition in resource '" + metadata_xml.toString() + "'.", (Throwable)e);
            }
        }
        if (!(dataman = (DataManagerProviderServices)DALLocator.getDataManager()).getStoreProviders().contains(this.getName())) {
            dataman.registerStoreProviderFactory((DataStoreProviderFactory)new SimpleSequentialReaderStoreProviderFactory(this));
        }
        try {
            DALFileLocator.getFilesystemServerExplorerManager().registerProviderFactory(new SimpleSequentialReaderFilesystemServerProviderFactory(this));
        }
        catch (Exception e) {
            this.LOGGER.warn("Can't register filesystem server provider factory (" + this.getName() + ").", (Throwable)e);
        }
    }

    @Override
    public void fetchDefaultParameters(DataParameters parameters) {
    }

    @Override
    public abstract SimpleSequentialReader createReader(OpenFeatureStoreParameters var1);
}

