/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.simplereader.virtualrows;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.List;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.RecordsFileImpl;
import org.gvsig.tools.util.GetItem;
import org.gvsig.tools.util.GetItem64;
import org.gvsig.tools.util.Size;
import org.gvsig.tools.util.Size64;

public interface RecordsFile
extends List<Record>,
Size,
Size64,
GetItem<Record>,
GetItem64<Record>,
Closeable {
    public static final byte TYPE_BYTE = 0;
    public static final byte TYPE_SHORT = 1;
    public static final byte TYPE_INTEGER = 2;
    public static final byte TYPE_LONG = 3;
    public static final byte TYPE_DOUBLE = 4;
    public static final byte TYPE_TIMESTAMP = 5;
    public static final byte TYPE_STRING = 6;
    public static final byte TYPE_BYTES = 7;

    public RecordType getRecordType();

    public void open(File var1) throws IOException;

    public void open(RandomAccessFile var1) throws IOException;

    public void create(File var1, RecordType var2) throws IOException;

    public void create(RandomAccessFile var1, RecordType var2) throws IOException;

    public boolean isOpen();

    public static interface RecordTypeBuilder {
        public RecordTypeBuilder addbyte();

        public RecordTypeBuilder addShort();

        public RecordTypeBuilder addInteger();

        public RecordTypeBuilder addLong();

        public RecordTypeBuilder addDouble();

        public RecordTypeBuilder addTimestamp();

        public RecordTypeBuilder addString(int var1);

        public RecordTypeBuilder addBytes(int var1);

        public RecordType build();

        public static RecordTypeBuilder recordTypeBuilder() {
            return RecordsFileImpl.RecordTypeBuilderImpl.recordTypeBuilder();
        }
    }

    public static interface RecordType {
        public int getSize();

        public int getFieldCount();

        public int getFieldType(int var1);

        public int getFieldSize(int var1);

        public int getFieldOffset(int var1);

        public Record createRecord();

        public byte[] toBytes();

        public static RecordType from(byte[] bytes) {
            return RecordsFileImpl.RecordTypeImpl.from(bytes);
        }

        public static RecordType from(ByteBuffer bytes) {
            return RecordsFileImpl.RecordTypeImpl.from(bytes);
        }
    }

    public static interface Record {
        public RecordType getType();

        public byte[] getBytes();

        public void setBytes(byte[] var1);

        public ByteBuffer getBuffer();

        public int getByte(int var1);

        public int getShort(int var1);

        public int getInt(int var1);

        public long getLong(int var1);

        public double getDouble(int var1);

        public Timestamp getTimestamp(int var1);

        public String getString(int var1);

        public byte[] getBytes(int var1);

        public void setByte(int var1, byte var2);

        public void setShort(int var1, short var2);

        public void setInt(int var1, int var2);

        public void setLong(int var1, long var2);

        public void setDouble(int var1, double var2);

        public void setTimestamp(int var1, Timestamp var2);

        public void setString(int var1, String var2);

        public void setBytes(int var1, byte[] var2);
    }
}

