/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.ermapper.io;

import es.gva.cit.jecwcompress.EcwException;
import es.gva.cit.jecwcompress.NCSEcwCompressClient;
import es.gva.cit.jecwcompress.ReadCallBack;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.coverage.store.ExternalCancellable;
import org.gvsig.raster.ermapper.io.ErmapperProvider;
import org.gvsig.raster.ermapper.io.Reader;
import org.gvsig.raster.impl.store.ParamImpl;
import org.gvsig.raster.impl.store.WriteFileFormatFeatures;
import org.gvsig.raster.impl.store.writer.DefaultRasterWriter;
import org.gvsig.raster.util.DefaultProviderServices;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;

public class ErmapperWriter
extends DefaultRasterWriter {
    public final int windowSizeX = 386;
    public final int windowSizeY = 220;
    public final int panelSizeX = 358;
    public final int panelSizeY = 125;
    public final String panelLayout = "BorderLayout";
    private NCSEcwCompressClient compressclient = null;
    private Reader readerObj;
    private double pixelSizeX;
    private double pixelSizeY;
    private double geoCoordOrigenX;
    private double geoCoordOrigenY;
    private boolean consulta = false;

    public static void register() {
        DefaultProviderServices pInfo = (DefaultProviderServices)RasterLocator.getManager().getProviderServices();
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("RasterWriter");
        WriteFileFormatFeatures features = null;
        String os = System.getProperties().getProperty("os.version");
        if (os.startsWith("2.4")) {
            point.append("ecw", "", ErmapperWriter.class);
            features = new WriteFileFormatFeatures("Ecw", "ecw", new int[]{3}, null, ErmapperWriter.class);
            pInfo.getFileFeature().put("ecw", features);
        }
        point.append("jp2", "", ErmapperWriter.class);
        features = new WriteFileFormatFeatures("Jpeg2000", "jp2", new int[]{3}, null, ErmapperWriter.class);
        pInfo.getFileFeature().put("jp2", features);
    }

    public void loadParams() {
        WriteFileFormatFeatures wfff = new WriteFileFormatFeatures();
        wfff.loadParams();
        this.driverParams = wfff.getParams();
        this.driverParams.setParam("compression", (Object)new Integer(10), 3, new String[]{"1", "20", "10", "1", "5"});
        this.driverParams.setParam("format", (Object)new Integer(4), 2, new String[]{"NONE", "UINT8", "YUV", "MULTI", "RGB"});
    }

    public String getProviderName() {
        return ErmapperProvider.NAME;
    }

    public ErmapperWriter(String fileName) {
        DefaultProviderServices pInfo = (DefaultProviderServices)RasterLocator.getManager().getProviderServices();
        this.ident = this.fileUtil.getExtensionFromFileName(fileName);
        this.driver = ((WriteFileFormatFeatures)pInfo.getFileFeature().get(this.ident)).getDriverName();
        this.loadParams();
        this.consulta = true;
    }

    public ErmapperWriter(DataServerWriter dataWriter, String outFileName, Integer nBands, AffineTransform at, Integer outSizeX, Integer outSizeY, Integer dataType, Params params, IProjection proj, Boolean geo) throws EcwException, IOException {
        DefaultProviderServices pInfo = (DefaultProviderServices)RasterLocator.getManager().getProviderServices();
        String ext = this.fileUtil.getExtensionFromFileName(outFileName);
        String fname = outFileName.substring(outFileName.lastIndexOf(File.separator) + 1, outFileName.lastIndexOf(".")).replaceAll("[^a-zA-Z0-9_]", "X");
        outFileName = outFileName.substring(0, outFileName.lastIndexOf(File.separator) + 1) + fname + "." + ext;
        this.proj = proj;
        this.ident = this.fileUtil.getExtensionFromFileName(outFileName);
        this.driver = ((WriteFileFormatFeatures)pInfo.getFileFeature().get(this.ident)).getDriverName();
        this.dataType = dataType;
        if (nBands <= 0) {
            throw new EcwException("N\u00famero de bandas erroneo.");
        }
        this.outFileName = outFileName;
        this.dataWriter = dataWriter;
        this.nBands = nBands;
        this.sizeWindowX = outSizeX;
        this.sizeWindowY = outSizeY;
        this.geoCoordOrigenX = at.getTranslateX();
        this.geoCoordOrigenY = at.getTranslateY();
        this.pixelSizeX = at.getScaleX() > 0.0 ? at.getScaleX() : -at.getScaleX();
        this.pixelSizeY = at.getScaleY() < 0.0 ? at.getScaleY() : -at.getScaleY();
        String outRmf = this.fileUtil.getNameWithoutExtension(outFileName);
        if (geo.booleanValue()) {
            this.rasterUtil.saveGeoInfo(outRmf, at, (Point2D)new Point2D.Double(this.sizeWindowX, this.sizeWindowY));
        }
        if (this.pixelSizeX == 0.0) {
            this.pixelSizeX = 1.0;
        }
        if (this.pixelSizeY == 0.0) {
            this.pixelSizeY = 1.0;
        }
        if (params == null) {
            this.loadParams();
        } else {
            this.driverParams = params;
        }
        this.init();
    }

    private void init() throws EcwException {
        this.percent = 0;
        int comp = (Integer)((ParamImpl)this.driverParams.getParamById("compression")).getDefaultValue();
        ParamImpl param = (ParamImpl)this.driverParams.getParamById("format");
        String format = param.getList()[(Integer)param.getDefaultValue()];
        if (comp == 0) {
            this.driverParams.changeParamValue("compression", (Object)"1");
        }
        if (this.compressclient == null) {
            this.compressclient = new NCSEcwCompressClient();
        }
        this.compressclient.setOutputFilename(this.outFileName);
        this.compressclient.setInputFilename(this.inFileName);
        this.compressclient.setTargetCompress((double)comp);
        this.compressclient.setInOutSizeX(this.sizeWindowX);
        this.compressclient.setInOutSizeY(this.sizeWindowY);
        this.compressclient.setInputBands(this.nBands);
        this.compressclient.setCompressFormat(this.convertFormatToInt(format));
        this.compressclient.setCellIncrementX(this.pixelSizeX);
        this.compressclient.setCellIncrementY(this.pixelSizeY);
        this.compressclient.setOriginX(this.geoCoordOrigenX);
        this.compressclient.setOriginY(this.geoCoordOrigenY);
        this.compressclient.setCellSizeUnits(1);
        int blocksize = RasterLibrary.blockHeight;
        if (this.dataWriter != null) {
            this.readerObj = new Reader(this.dataWriter, this.compressclient, this.sizeWindowX, this.sizeWindowY, blocksize, this.nBands, this, this.dataType);
        }
    }

    private int convertFormatToInt(String format) {
        if (format.compareTo("NONE") == 0) {
            return 0;
        }
        if (format.compareTo("UINT8") == 0) {
            return 1;
        }
        if (format.compareTo("YUV") == 0) {
            return 2;
        }
        if (format.compareTo("MULTI") == 0) {
            return 3;
        }
        if (format.compareTo("RGB") == 0) {
            return 4;
        }
        return -1;
    }

    private void readProperty(String propValue) {
        String value;
        String prop = propValue.substring(0, propValue.indexOf("="));
        if (propValue.startsWith(prop) && (value = propValue.substring(propValue.indexOf("=") + 1, propValue.length())) != null && !value.equals("")) {
            if (prop.equals("BLOCKSIZE")) {
                this.driverParams.changeParamValue("blocksize", (Object)value);
            }
            if (prop.equals("FORMAT")) {
                this.driverParams.changeParamValue("format", (Object)value);
            }
            if (prop.equals("COMPRESSION")) {
                this.driverParams.changeParamValue("compression", (Object)value);
            }
        }
    }

    public void setProps(String[] props) {
        for (int iProps = 0; iProps < props.length; ++iProps) {
            this.readProperty(props[iProps]);
        }
        this.loadParams();
        try {
            if (!this.consulta) {
                this.init();
            }
        }
        catch (EcwException e) {
            e.printStackTrace();
        }
    }

    public void fileWrite() throws IOException {
    }

    public void dataWrite() throws IOException, ProcessInterruptedException {
        if (this.dataWriter == null) {
            throw new IOException("No se ha obtenido un objeto para la lectura valido.");
        }
        try {
            this.compressclient.NCSEcwCompressOpen(false);
            this.compressclient.NCSEcwCompress((ReadCallBack)this.readerObj);
        }
        catch (EcwException e) {
            throw new IOException("Error en la compresi\u00f3n.");
        }
    }

    public void writeClose() {
        try {
            this.compressclient.NCSEcwCompressClose();
        }
        catch (EcwException e) {
            e.printStackTrace();
        }
    }

    public void writeCancel() {
        try {
            if (this.readerObj != null) {
                this.readerObj.setWrite(false);
            }
            this.compressclient.NCSEcwCompressCancel();
        }
        catch (EcwException e) {
            e.printStackTrace();
        }
    }

    public void setWkt(String wkt) {
    }

    public void setCancellableRasterDriver(ExternalCancellable cancellable) {
        super.setCancellableRasterDriver(cancellable);
        if (this.readerObj != null) {
            this.readerObj.setCancellableRasterDriver(cancellable);
        }
    }
}

