/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.newlayer.app.extension;

import javax.swing.JComponent;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.i18n.Messages;
import org.gvsig.newlayer.NewLayerLocator;
import org.gvsig.newlayer.NewLayerManager;
import org.gvsig.newlayer.NewLayerService;
import org.gvsig.newlayer.NewLayerWizard;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class NewLayerExtension
extends Extension {
    public void initialize() {
    }

    public void postInitialize() {
        super.postInitialize();
    }

    public void execute(String actionCommand) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ApplicationManager application = ApplicationLocator.getManager();
        final ViewDocument view = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (view != null) {
            NewLayerManager manager = NewLayerLocator.getManager();
            NewLayerService service = manager.createNewLayerService();
            service.setDefaultProjection(view.getProjection());
            service.addNewLayerServiceListener((NewLayerService.NewLayerServiceListener)new NewLayerService.NewLayerServiceAdapter(){

                public void postCreateTable(NewLayerService service) {
                    if (!service.isAddTableToProject()) {
                        return;
                    }
                    try {
                        if (service.getFeatureType().getDefaultGeometryAttribute() == null) {
                            return;
                        }
                        DataStoreParameters storeParameters = service.getOpenStoreParameters();
                        DataManager dataManager = DALLocator.getDataManager();
                        DataStore store = dataManager.openStore(storeParameters.getProviderName(), storeParameters);
                        String layerName = store.getName();
                        MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
                        FLayer lyr = mapContextManager.createLayer(layerName, store);
                        lyr.setActive(true);
                        lyr.setVisible(true);
                        view.getMapContext().getLayers().addLayer(lyr);
                        lyr.dispose();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            NewLayerWizard wizard = manager.createNewLayerWizard(service);
            wizard.setAddTableToProjectTitle(i18n.getTranslation("_Adding_layer"));
            wizard.setAddTableToProjectLabel(i18n.getTranslation("_Add_layer_to_view"));
            WindowManager windowMgr = ToolsSwingLocator.getWindowManager();
            windowMgr.showWindow((JComponent)wizard, Messages.getText((String)"_New_layer_wizard"), WindowManager.MODE.WINDOW);
        }
    }

    public boolean isEnabled() {
        return this.isVisible();
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument view = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        return view != null;
    }
}

