/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.fife.rsta.ui.GoToDialog;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rsta.ui.search.ReplaceDialog;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.gvsig.installer.lib.api.Version;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.api.SwingInstallerManager;
import org.gvsig.installer.swing.api.packagebuilder.PackageBuildder;
import org.gvsig.scripting.CompileErrorException;
import org.gvsig.scripting.ExecuteErrorException;
import org.gvsig.scripting.ScriptingBaseScript;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.ScriptingNotification;
import org.gvsig.scripting.ScriptingScript;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.swing.api.JCodeEditor;
import org.gvsig.scripting.swing.api.JEditor;
import org.gvsig.scripting.swing.api.JScriptingBrowser;
import org.gvsig.scripting.swing.api.JScriptingComposer;
import org.gvsig.scripting.swing.api.JScriptingConsole;
import org.gvsig.scripting.swing.api.JScriptingLauncher;
import org.gvsig.scripting.swing.api.JTextEditor;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.scripting.swing.api.SyntaxtHighlightTextComponent;
import org.gvsig.scripting.swing.impl.DefaultJScriptingBrowser;
import org.gvsig.scripting.swing.impl.DefaultJScriptingConsole;
import org.gvsig.scripting.swing.impl.DefaultScriptingUIManager;
import org.gvsig.scripting.swing.impl.JDialogContent;
import org.gvsig.scripting.swing.impl.composer.JDefaultDialog;
import org.gvsig.scripting.swing.impl.composer.JMoveScriptModel;
import org.gvsig.scripting.swing.impl.composer.JMoveScriptPanel;
import org.gvsig.scripting.swing.impl.composer.JNewScriptModel;
import org.gvsig.scripting.swing.impl.composer.JNewScriptPanel;
import org.gvsig.scripting.swing.impl.composer.JRenameModel;
import org.gvsig.scripting.swing.impl.composer.JRenamePanel;
import org.gvsig.scripting.swing.impl.composer.MenuBarHelper;
import org.gvsig.scripting.swing.impl.composer.components.DefaultDock;
import org.gvsig.scripting.swing.impl.composer.components.DefaultJTabbedPaneClosable;
import org.gvsig.scripting.swing.impl.composer.components.DefaultProblems;
import org.gvsig.scripting.swing.impl.composer.components.JTabbedPaneClosable;
import org.gvsig.scripting.swing.impl.composer.editors.ScriptUnitEditor;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.packageutils.PackageInfo;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJScriptingComposer
extends JPanel
implements JScriptingComposer,
Observer,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJScriptingComposer.class);
    public static final int CLOSE_ACTION = 1;
    private final ScriptingUIManager uimanager;
    private final ScriptingManager manager;
    private final ClassLoader loader = this.getClass().getClassLoader();
    private JSplitPane mainPanel;
    private JScriptingComposer.Dock dock;
    private Map<String, ToolEntry> menus;
    private JMenuBar menuBar;
    private Map<String, ToolEntry> tools;
    private JToolBar toolBar;
    private JScriptingComposer.StatusBar statusBar;
    private FindDialog findDialog;
    private ReplaceDialog replaceDialog;
    private GoToDialog gotoDialog;
    private ActionListener defaultActionlistener = null;
    private Set<ChangeListener> changeEditorListeners = null;
    private ScriptingScript mainScript;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultJScriptingComposer(ScriptingUIManager uimanager) {
        this.uimanager = uimanager;
        ScriptingManager scriptingManager = this.manager = uimanager.getManager();
        synchronized (scriptingManager) {
            this.initComponents();
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    public WindowManager getWindowManager() {
        return ((DefaultScriptingUIManager)this.uimanager).getWindowManager();
    }

    public void setWindowManager(WindowManager windowsManager) {
        ((DefaultScriptingUIManager)this.uimanager).setWindowManager(windowsManager);
    }

    private void initComponents() {
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                ((DefaultScriptingUIManager)DefaultJScriptingComposer.this.uimanager).setActiveComposer(DefaultJScriptingComposer.this);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                ((DefaultScriptingUIManager)DefaultJScriptingComposer.this.uimanager).setActiveComposer(null);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        FindReplaceSearchListener findReplaceSearchListener = new FindReplaceSearchListener();
        this.findDialog = new FindDialog((java.awt.Dialog)null, (SearchListener)findReplaceSearchListener);
        this.replaceDialog = new ReplaceDialog((java.awt.Dialog)null, (SearchListener)findReplaceSearchListener);
        this.gotoDialog = new GoToDialog((java.awt.Dialog)null);
        SearchContext searchContext = this.findDialog.getSearchContext();
        this.replaceDialog.setSearchContext(searchContext);
        this.menuBar = new JMenuBar();
        this.toolBar = new JToolBar();
        this.menus = new LinkedHashMap<String, ToolEntry>();
        this.tools = new LinkedHashMap<String, ToolEntry>();
        String _File = this.uimanager.getTranslation("File");
        String _Edit = this.uimanager.getTranslation("Edit");
        String _Projects = this.uimanager.getTranslation("Projects");
        String _Tools = this.uimanager.getTranslation("Tools");
        String _Help = this.uimanager.getTranslation("Help");
        String _View = this.uimanager.getTranslation("Show");
        this.addMenu(_File, null);
        this.addMenu(_File, new NewDocumentAction());
        this.addMenu(_File, new NewFolderAction());
        this.addMenuSeparator(_File);
        this.addMenu(_File, new CloseDocumentAction());
        this.addMenu(_File, new CloseAllAction());
        this.addMenuSeparator(_File);
        this.addMenu(_File, new SelectMainScriptAction());
        this.addMenu(_File, new RunMainAction());
        this.addMenu(_File, new RunAction());
        this.addMenu(_File, new SaveAndRunAction());
        this.addMenuSeparator(_File);
        this.addMenu(_File, new SaveAction());
        this.addMenu(_File, new ReloadAction());
        this.addMenuSeparator(_File);
        this.addMenu(_File, new ExitAction());
        this.addMenu(_Edit, null);
        this.addMenu(_Edit, new CutAction());
        this.addMenu(_Edit, new CopyAction());
        this.addMenu(_Edit, new PasteAction());
        this.addMenuSeparator(_Edit);
        this.addMenu(_Edit, new SelectAllAction());
        this.addMenuSeparator(_Edit);
        this.addMenu(_Edit, new ShowFindDialogAction());
        this.addMenu(_Edit, new ShowReplaceDialogAction());
        this.addMenu(_Edit, new GoToLineAction());
        this.addMenu(_View, null);
        this.addMenu(_View, new ShowProjectsAction());
        this.addMenu(_View, new ShowProblemsAction());
        this.addMenu(_View, new ShowConsoleAction());
        this.addMenu(_Projects, null);
        this.addMenu(_Projects, new ProjectEditAction());
        this.addMenu(_Projects, new ProjectRunAction());
        this.addMenuSeparator(_Projects);
        this.addMenu(_Projects, new ProjectRefreshAction());
        this.addMenuSeparator(_Projects);
        this.addMenu(_Projects, new ProjectRenameAction());
        this.addMenu(_Projects, new ProjectMoveAction());
        this.addMenu(_Projects, new ProjectDeleteAction());
        this.addMenu(_Tools, null);
        this.addMenu(_Tools, new LauncherAction());
        this.addMenuSeparator(_Tools);
        this.addMenu(_Tools, new PackageScriptAction());
        this.addMenu(_Help, null);
        this.addMenu(_Help, new AboutAction());
        this.addTool(new NewDocumentAction());
        this.addTool(new SaveAction());
        this.addTool(new CutAction());
        this.addTool(new CopyAction());
        this.addTool(new PasteAction());
        this.addTool(new RunMainAction());
        this.addTool(new RunAction());
        this.addTool(new SaveAndRunAction());
        JTabbedPaneClosable tabbedPanelLeft = DefaultJTabbedPaneClosable.create(this.uimanager);
        JTabbedPaneClosable tabbedPanelBottom = DefaultJTabbedPaneClosable.create(this.uimanager);
        JTabbedPaneClosable tabbedPanelCenter = DefaultJTabbedPaneClosable.create(this.uimanager);
        tabbedPanelLeft.setTabPlacement(3);
        tabbedPanelCenter.setPreferredSize(new Dimension(500, 300));
        tabbedPanelCenter.addChangeListener(e -> {
            this.updateMenusAndTools();
            try {
                ((ScriptUnitEditor)((JTabbedPane)e.getSource()).getSelectedComponent()).getJTextComponent().requestFocusInWindow();
            }
            catch (Throwable th) {
                LOGGER.debug("Can't set focus in the editor", th);
            }
        });
        this.dock = new DefaultDock(tabbedPanelLeft, tabbedPanelBottom, tabbedPanelCenter);
        this.dock.addCloseListener(e -> {
            JScriptingComposer.Dock.DockedPanel panel = (JScriptingComposer.Dock.DockedPanel)e.getSource();
            this.scriptClose(panel);
        });
        this.addProjectsPanel();
        this.addConsolePanel();
        this.addProblemsPanel();
        this.dock.select("Console");
        this.dock.select("Projects");
        JSplitPane centerPanel = new JSplitPane(0, tabbedPanelCenter.asJComponent(), tabbedPanelBottom.asJComponent());
        centerPanel.setResizeWeight(0.8);
        centerPanel.setOneTouchExpandable(true);
        this.mainPanel = new JSplitPane(1, tabbedPanelLeft.asJComponent(), centerPanel);
        this.mainPanel.setOneTouchExpandable(true);
        this.statusBar = new DefaultStatusBar(this.uimanager);
        this.updateMenusAndTools();
        JPanel buttons = new JPanel();
        buttons.setLayout(new BorderLayout());
        buttons.add("North", this.menuBar);
        buttons.add("South", this.toolBar);
        this.setLayout(new BorderLayout());
        this.add("North", buttons);
        this.add("Center", this.mainPanel);
        this.add("South", this.statusBar.asJComponent());
        this.setPreferredSize(new Dimension(800, 600));
    }

    public void addMenu(String text, Action action) {
        String name = action == null ? String.format("Menu%x", new Date().getTime()) : (String)action.getValue("ActionCommandKey");
        this.menus.put(name, new ToolEntry(name, action, text));
    }

    public void addMenuSeparator(String text) {
        String name = String.format("Sep%x", new Date().getTime());
        this.menus.put(name, new ToolEntry(name, null, text + "/-"));
    }

    public void addTool(Action action) {
        String name = (String)action.getValue("ActionCommandKey");
        this.tools.put(name, new ToolEntry(name, action));
    }

    public void updateMenusAndTools() {
        Boolean isVisible;
        Action action;
        this.menuBar.removeAll();
        this.toolBar.removeAll();
        for (ScriptingUIManager.MenuEntry entry : this.uimanager.getComposerMenus()) {
            this.addMenu(entry.getText(), entry.getAction());
        }
        for (Action action2 : this.uimanager.getComposerTools()) {
            this.addTool(action2);
        }
        MenuBarHelper menuBarHelper = new MenuBarHelper(this.menuBar);
        for (ToolEntry entry : this.menus.values()) {
            try {
                action = entry.getAction();
                if (action != null && (isVisible = (Boolean)action.getValue("Visible")) != null && !isVisible.booleanValue()) continue;
                JMenuItem menu = menuBarHelper.add(entry.getText(), action, this);
                entry.setComponent(menu);
            }
            catch (Throwable th) {
                LOGGER.warn("Can't add entry '" + entry.getName() + "' to the toolbar.", th);
            }
        }
        for (ToolEntry entry : this.tools.values()) {
            try {
                action = entry.getAction();
                if (action != null && (isVisible = (Boolean)action.getValue("Visible")) != null && !isVisible.booleanValue()) continue;
                ButtonWithContext button = new ButtonWithContext(action);
                this.toolBar.add(button);
                entry.setComponent(button);
            }
            catch (Throwable th) {
                LOGGER.warn("Can't add entry '" + entry.getName() + "' to the toolbar.", th);
            }
        }
        this.menuBar.repaint();
        this.toolBar.repaint();
    }

    public void addProblemsPanel() {
        JScriptingComposer.Dock.DockedPanel panel = this.dock.get("Problems");
        if (panel != null) {
            panel.select();
            return;
        }
        DefaultProblems problems = new DefaultProblems(this.uimanager);
        problems.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            JScriptingComposer.Problems.Problem row = problems.getSelect();
            if (row != null) {
                JEditor editor;
                int lineno = row.getLineNumber();
                if (row.getResource() == null) {
                    editor = this.getCurrentEditor();
                } else {
                    String id = row.getResource().getAbsolutePath();
                    JScriptingComposer.Dock.DockedPanel panel1 = this.getDock().get(id);
                    if (panel1 == null) {
                        ScriptingBaseScript script = this.manager.getScript(row.getResource());
                        this.scriptEdit((ScriptingUnit)script);
                        panel1 = this.getDock().get(id);
                        if (panel1 == null) {
                            LOGGER.warn("Can't load script '" + id + "'.");
                            return;
                        }
                    }
                    panel1.select();
                    editor = (JEditor)panel1.getComponent();
                }
                if (editor instanceof JCodeEditor) {
                    ((JCodeEditor)editor).gotoline(lineno);
                }
            }
        });
        this.dock.add("Problems", this.uimanager.getTranslation("Problems"), (org.gvsig.tools.swing.api.Component)problems, "South");
        this.dock.select("Problems");
    }

    public void addConsolePanel() {
        JScriptingComposer.Dock.DockedPanel panel = this.dock.get("Console");
        if (panel != null) {
            panel.select();
            return;
        }
        DefaultJScriptingConsole console = new DefaultJScriptingConsole(true);
        this.dock.add("Console", this.uimanager.getTranslation("Console"), (org.gvsig.tools.swing.api.Component)console, "South");
        this.dock.select("Console");
    }

    public void addProjectsPanel() {
        JScriptingComposer.Dock.DockedPanel panel = this.dock.get("Projects");
        if (panel != null) {
            panel.select();
            return;
        }
        JScriptingLauncher launcher = this.uimanager.createLauncher();
        launcher.addDefaultActionListener(e -> {
            JScriptingBrowser.BrowserActionEvent e2 = (JScriptingBrowser.BrowserActionEvent)e;
            switch (e.getID()) {
                case 1: {
                    ScriptingUnit unit = e2.getUnit();
                    if (unit instanceof ScriptingFolder) {
                        return;
                    }
                    if (!this.uimanager.hasEditor(unit)) break;
                    this.scriptEdit(unit);
                    break;
                }
            }
        });
        launcher.asJComponent().setPreferredSize(new Dimension(200, 450));
        this.dock.add("Projects", this.uimanager.getTranslation("Projects"), (org.gvsig.tools.swing.api.Component)launcher, "West");
        this.dock.select("Projects");
    }

    public JScriptingComposer.Problems getProblems() {
        JScriptingComposer.Dock.DockedPanel panel = this.dock.get("Problems");
        if (panel == null) {
            return null;
        }
        return (JScriptingComposer.Problems)panel.getComponent();
    }

    public JScriptingLauncher getProjects() {
        JScriptingComposer.Dock.DockedPanel panel = this.dock.get("Projects");
        if (panel == null) {
            return null;
        }
        return (JScriptingLauncher)panel.getComponent();
    }

    public JScriptingComposer.Dock getDock() {
        return this.dock;
    }

    public JScriptingConsole getConsole() {
        JScriptingComposer.Dock.DockedPanel panel = this.dock.get("Console");
        if (panel == null) {
            return null;
        }
        return (JScriptingConsole)panel.getComponent();
    }

    public void addChangeEditorListener(ChangeListener listener) {
        if (this.changeEditorListeners == null) {
            this.changeEditorListeners = new HashSet<ChangeListener>();
        }
        this.changeEditorListeners.add(listener);
    }

    public void removeChangeEditorListener(ChangeListener listener) {
        if (this.changeEditorListeners == null) {
            return;
        }
        this.changeEditorListeners.remove(listener);
    }

    public void fireChangeEditor(ChangeEvent e) {
        if (this.changeEditorListeners == null) {
            return;
        }
        for (ChangeListener listener : this.changeEditorListeners) {
            try {
                listener.stateChanged(e);
            }
            catch (Throwable throwable) {}
        }
    }

    private void createScriptPackage() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        SwingInstallerManager installerManager = SwingInstallerLocator.getSwingInstallerManager();
        PackageBuildder packager = installerManager.createPackagerPanel("Script", this.manager.getRootUserFolder(), this.manager.getPackagesFolder());
        packager.addBeforePackingListener(builder -> {
            Collection files = FileUtils.listFiles((File)builder.getFolderToPackaging(), (IOFileFilter)FileFilterUtils.suffixFileFilter((String)"$py.class", (IOCase)IOCase.INSENSITIVE), (IOFileFilter)FileFilterUtils.trueFileFilter());
            if (files != null) {
                for (File file : files) {
                    FileUtils.deleteQuietly((File)file);
                }
            }
        });
        PackageInfo packageInfo = packager.getPackageInfo();
        packageInfo.setArchitecture("all");
        packageInfo.setJavaVM("j1_7");
        packageInfo.setOperatingSystem("all");
        packageInfo.setOfficial(false);
        packageInfo.setState("testing");
        packageInfo.setType("Script");
        org.gvsig.tools.packageutils.Version version = ToolsLocator.getPackageManager().createVersion();
        version.parse("1.0.0");
        packageInfo.setVersion((Version)version);
        this.uimanager.showWindow((JComponent)((JPanel)packager.asJComponent()), i18nManager.getTranslation("_Scripting_packager"));
    }

    public void addDefaultActionListener(ActionListener actionlistener) {
        this.defaultActionlistener = actionlistener;
    }

    public ScriptingUnit getLauncherSelectedUnit() {
        JScriptingBrowser browser = this.getCurrentBrowser();
        ScriptingUnit unit = browser.getSelectedNode();
        return unit;
    }

    public void msgbox(String title, String msg) {
        this.msgbox(title, msg, 1);
    }

    public void msgbox(String title, String msg, int type) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(() -> this.msgbox(title, msg, type));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        JOptionPane.showMessageDialog(this, msg, title, type);
    }

    private JScriptingBrowser getCurrentBrowser() {
        JScriptingLauncher launcher = this.getProjects();
        JScriptingBrowser browser = launcher.getSelectedBrowser();
        return browser;
    }

    public void scriptEdit(ScriptingUnit unit) {
        ScriptingUnit xx;
        String id = unit.getFile().getAbsolutePath();
        JScriptingComposer.Dock.DockedPanel x = this.dock.get(id);
        if (x != null) {
            x.select();
            return;
        }
        JEditor editor = this.uimanager.createEditor(unit);
        if (editor == null) {
            JOptionPane.showMessageDialog(null, this.uimanager.getTranslation("Error_opening_in_edition_mode"), this.uimanager.getTranslation("Error_opening_in_edition_mode_title"), 1);
            return;
        }
        JScriptingComposer.Dock.DockedPanel panel = this.dock.add(id, unit.getName(), (org.gvsig.tools.swing.api.Component)editor, "Center");
        panel.select();
        editor.addChangeListener(evt -> {
            panel.setModified(true);
            this.fireChangeEditor(new ChangeEvent(editor));
        });
        if (editor instanceof JTextEditor) {
            ((JTextEditor)editor).addUpdateCaretPositionActionListener(e -> {
                SyntaxtHighlightTextComponent.UpdateCaretPositionActionEvent event = (SyntaxtHighlightTextComponent.UpdateCaretPositionActionEvent)e;
                this.getStatusbar().setPosition(event.getLine(), event.getColumn());
            });
        }
        if ((xx = editor.getUnit()) instanceof ScriptingScript) {
            ((ScriptingScript)xx).addObserver((Observer)this);
        }
    }

    public void scriptNew() throws Exception {
        this.unitNew(false);
    }

    public void FolderNew() throws Exception {
        this.unitNew(true);
    }

    public void unitNew(boolean folder) throws Exception {
        JNewScriptModel model = new JNewScriptModel(this.manager);
        model.setSelectionPath(this.getCurrentBrowser().getSelectionPath());
        JDialogContent dialog = new JDialogContent(this.uimanager, "document-new", this.uimanager.getTranslation("New_Script"), this.uimanager.getTranslation("New_Script_Description"), new JNewScriptPanel(this.uimanager, model, folder));
        dialog.showDialog();
        if (model.getAction() == 1) {
            model.validate();
            ScriptingUnit unit = this.manager.createUnit(model.getType(), this.manager.getFolder(model.getPath()), model.getName(), model.getLanguage());
            if (unit instanceof ScriptingBaseScript) {
                this.scriptEdit((ScriptingUnit)((ScriptingBaseScript)unit));
            }
            this.refreshProjects();
        }
    }

    public void scriptClose(JScriptingComposer.Dock.DockedPanel panel) {
        if (!panel.isModified()) {
            panel.remove();
            return;
        }
        panel.select();
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        int respuesta = JOptionPane.showConfirmDialog(this, i18nManager.getTranslation("_The_script_XscriptnameX_is_modified", new String[]{panel.getTitle()}) + "\n\n" + i18nManager.getTranslation("_Do_you_want_to_save_changes_XquestionX"), i18nManager.getTranslation("_Save_changes_XquestionX"), 1);
        switch (respuesta) {
            case 0: {
                this.currentScriptSave();
                panel.remove();
                break;
            }
            case 1: {
                panel.remove();
                break;
            }
        }
    }

    public void scriptMove(ScriptingUnit theUnit) throws Exception {
        if (theUnit.getParent() == null) {
            JOptionPane.showMessageDialog(null, "Please, select first the file to move on the tree directory", "Error", 0);
        } else {
            JMoveScriptModel model = new JMoveScriptModel(this.manager, theUnit);
            model.setSelectionPath(this.getCurrentBrowser().getSelectionPath());
            JDialogContent dialog = new JDialogContent(this.uimanager, "format-indent-more", this.uimanager.getTranslation("Move") + " '" + theUnit.getName() + "' " + this.uimanager.getTranslation("script_filesystem"), this.uimanager.getTranslation("move_desc"), new JMoveScriptPanel(this.uimanager, model));
            dialog.showDialog();
            if (model.getAction() == 1) {
                model.validate();
                ScriptingFolder folderDest = this.manager.getFolder(model.getMoveTo());
                if (model.getUnit().move(folderDest)) {
                    JOptionPane.showMessageDialog(null, this.uimanager.getTranslation("Moving_succesfully"), this.uimanager.getTranslation("Success"), 1);
                    this.refreshProjects();
                } else {
                    JOptionPane.showMessageDialog(null, this.uimanager.getTranslation("Error_moving"), this.uimanager.getTranslation("Error"), 0);
                }
            }
        }
    }

    public void scriptRename(ScriptingUnit theUnit) throws Exception {
        if (theUnit.getParent() == null) {
            JOptionPane.showMessageDialog(null, this.uimanager.getTranslation("Select_first"), this.uimanager.getTranslation("Error"), 0);
        } else {
            JRenameModel model = new JRenameModel(this.manager, theUnit);
            JDialogContent dialog = new JDialogContent(this.uimanager, "preferences-system", this.uimanager.getTranslation("Rename") + " '" + theUnit.getName() + "' " + this.uimanager.getTranslation("script_filesystem"), this.uimanager.getTranslation("rename_desc"), new JRenamePanel(this.uimanager, model));
            dialog.showDialog();
            if (model.getAction() == 1) {
                model.validate();
                ScriptingUnit unit = model.getUnit();
                if (!model.getNewName().equals(unit.getId())) {
                    if (unit.rename(model.getNewName())) {
                        JOptionPane.showMessageDialog(null, this.uimanager.getTranslation("Rename_succesfully"), this.uimanager.getTranslation("Success"), 1);
                        this.refreshProjects();
                    } else {
                        JOptionPane.showMessageDialog(null, this.uimanager.getTranslation(this.uimanager.getTranslation("Error_renaming")), this.uimanager.getTranslation("Error"), 0);
                    }
                    if (unit instanceof ScriptingScript) {
                        ((ScriptingScript)unit).save();
                    }
                }
            }
        }
    }

    public JPanel getAboutUsDialog() {
        return new JDialogContent(this.uimanager, "system-users", this.uimanager.getTranslation("About_us"), this.uimanager.getTranslation("About_us_title"), new JDefaultDialog(this.uimanager, this, this.uimanager.getAboutManager().getAboutPanel()));
    }

    public void scriptDelete(ScriptingUnit unit, boolean isRecursive) {
        if (unit == null) {
            return;
        }
        int n = 0;
        if (!isRecursive) {
            n = JOptionPane.showConfirmDialog(this.getRootPane(), this.uimanager.getTranslation("Delete_all_message"), this.uimanager.getTranslation("Delete_all_title"), 0);
        }
        if (n == 0) {
            if (unit instanceof ScriptingFolder) {
                List subunits = ((ScriptingFolder)unit).getUnits();
                for (ScriptingUnit subunit : subunits) {
                    this.scriptDelete(subunit, true);
                }
            }
            unit.getParent().remove(unit);
            this.refreshProjects();
        }
    }

    public void currentScriptClose() {
        JScriptingComposer.Dock.DockedPanel panel = this.dock.getSelected("Center");
        if (panel == null) {
            return;
        }
        this.scriptClose(panel);
    }

    public void closeAllScripts() {
        ArrayList<JScriptingComposer.Dock.DockedPanel> modifiedPanels = new ArrayList<JScriptingComposer.Dock.DockedPanel>();
        ArrayList<JScriptingComposer.Dock.DockedPanel> toRemove = new ArrayList<JScriptingComposer.Dock.DockedPanel>();
        for (JScriptingComposer.Dock.DockedPanel panel : this.dock) {
            if (!"Center".equals(panel.getAlign())) continue;
            if (panel.isModified()) {
                modifiedPanels.add(panel);
                continue;
            }
            toRemove.add(panel);
        }
        if (modifiedPanels.isEmpty() && toRemove.isEmpty()) {
            return;
        }
        int action = JOptionPane.showConfirmDialog(this, this.uimanager.getTranslation("projects_modified"), this.uimanager.getTranslation("projects_modified_title"), 1);
        switch (action) {
            case 2: {
                return;
            }
            case 0: {
                JEditor editor;
                for (JScriptingComposer.Dock.DockedPanel panel : modifiedPanels) {
                    editor = (JEditor)panel.getComponent();
                    if (editor.getUnit() != null) {
                        editor.getUnit().setSaved(true);
                    }
                    editor.save();
                    toRemove.add(panel);
                }
                break;
            }
            case 1: {
                JEditor editor;
                for (JScriptingComposer.Dock.DockedPanel panel : modifiedPanels) {
                    editor = (JEditor)panel.getComponent();
                    if (editor.getUnit() != null) {
                        editor.getUnit().setSaved(true);
                    }
                    toRemove.add(panel);
                }
                break;
            }
        }
        if (toRemove.isEmpty()) {
            return;
        }
        for (JScriptingComposer.Dock.DockedPanel panel : toRemove) {
            panel.remove();
        }
    }

    public void currentScriptExecute() {
        ScriptingScript script = this.getCurrentScript();
        this.scriptExecute(script);
    }

    public void scriptExecute(ScriptingScript script) {
        if (script != null) {
            JScriptingConsole console;
            JScriptingComposer.Problems problems = this.getProblems();
            if (problems != null) {
                problems.removeAll();
            }
            if ((console = this.getConsole()) == null) {
                this.addConsolePanel();
            } else {
                console.clear();
            }
            script.addObserver((Observer)this);
            script.addStdoutWriter(this.getConsole().getOutputWriter());
            script.addStderrWriter(this.getConsole().getErrorsWriter());
            try {
                script.compile();
                script.runAsTask(null);
            }
            catch (Throwable e) {
                LOGGER.info("Can't execute script", e);
            }
        }
    }

    public void currentScriptCopy() {
        JScriptingComposer.Dock.DockedPanel panel = this.dock.getSelected("Center");
        if (panel.getComponent().asJComponent() instanceof JTextEditor) {
            JTextEditor editor = (JTextEditor)panel.getComponent().asJComponent();
            editor.getJTextComponent().copy();
        }
    }

    public void currentScriptCut() {
        JScriptingComposer.Dock.DockedPanel panel = this.dock.getSelected("Center");
        if (panel.getComponent().asJComponent() instanceof JTextEditor) {
            JTextEditor editor = (JTextEditor)panel.getComponent().asJComponent();
            editor.getJTextComponent().cut();
            panel.setModified(true);
        }
    }

    public void currentScriptPaste() {
        JScriptingComposer.Dock.DockedPanel panel = this.dock.getSelected("Center");
        if (panel.getComponent().asJComponent() instanceof JTextEditor) {
            JTextEditor editor = (JTextEditor)panel.getComponent().asJComponent();
            editor.getJTextComponent().paste();
            panel.setModified(true);
        }
    }

    public void currentScriptSelectAll() {
        JScriptingComposer.Dock.DockedPanel panel = this.dock.getSelected("Center");
        if (panel.getComponent().asJComponent() instanceof JTextEditor) {
            JTextEditor editor = (JTextEditor)panel.getComponent().asJComponent();
            editor.getJTextComponent().selectAll();
        }
    }

    public void currentScriptSave() {
        JScriptingComposer.Dock.DockedPanel panel = this.dock.getSelected("Center");
        if (panel.getComponent().asJComponent() instanceof JEditor) {
            JEditor editor = (JEditor)panel.getComponent().asJComponent();
            editor.save();
            panel.setModified(false);
        }
    }

    public void currentScriptReload() {
        JScriptingComposer.Dock.DockedPanel panel = this.dock.getSelected("Center");
        if (panel.getComponent().asJComponent() instanceof JTextEditor) {
            int r;
            JTextEditor editor = (JTextEditor)panel.getComponent().asJComponent();
            if (editor.isModified() && (r = JOptionPane.showConfirmDialog(this, this.uimanager.getTranslation("_The_changes_in_current_file_are_not_saved") + "\n" + this.uimanager.getTranslation("_Do_you_want_to_continue_and_discard_the_changes") + "\n\n" + "(" + editor.getUnit().getUserPath() + ")", this.uimanager.getTranslation("_Warning"), 0)) != 0) {
                return;
            }
            editor.reload();
            panel.setModified(false);
        }
    }

    public ScriptingScript getMainScript() {
        return this.mainScript;
    }

    public void mainScriptSelect(ScriptingScript script) {
        this.mainScript = script;
    }

    public void mainScriptSelect() {
        DefaultJScriptingBrowser browser = new DefaultJScriptingBrowser(this.uimanager, this.manager.getUserFolder());
        browser.asJComponent().setPreferredSize(new Dimension(400, 450));
        WindowManager_v2 winmgr = (WindowManager_v2)this.uimanager.getWindowManager();
        Dialog dialog = winmgr.createDialog(browser.asJComponent(), "Select main script", null, 3);
        dialog.addActionListener(e -> {
            if (dialog.getAction() == 1) {
                ScriptingUnit script = browser.getSelectedNode();
                if (script instanceof ScriptingScript) {
                    this.mainScriptSelect((ScriptingScript)script);
                } else {
                    JOptionPane.showMessageDialog(this, this.uimanager.getTranslation("_The_selected_script_is_invalid"), this.uimanager.getTranslation("_Warning"), 1);
                }
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    public void mainScriptExecute() {
        JScriptingConsole console;
        JScriptingComposer.Problems problems;
        ScriptingScript script = this.getMainScript();
        if (script == null) {
            int r = JOptionPane.showConfirmDialog(this, this.uimanager.getTranslation("_Main_script_is_not_selected") + "\n" + this.uimanager.getTranslation("_Do_you_want_to_select_one_and_execute_it"), this.uimanager.getTranslation("_Warning"), 0);
            if (r != 0) {
                return;
            }
            this.mainScriptSelect();
            script = this.getMainScript();
            if (script == null) {
                return;
            }
        }
        if ((problems = this.getProblems()) != null) {
            problems.removeAll();
        }
        if ((console = this.getConsole()) == null) {
            this.addConsolePanel();
        } else {
            console.clear();
        }
        script.addObserver((Observer)this);
        script.addStdoutWriter(this.getConsole().getOutputWriter());
        script.addStderrWriter(this.getConsole().getErrorsWriter());
        try {
            script.setCode(null);
            script.compile();
            script.runAsTask(null);
        }
        catch (Throwable e) {
            LOGGER.info("Can't execute script", e);
        }
    }

    public JEditor getCurrentEditor() {
        JScriptingComposer.Dock.DockedPanel panel = this.dock.getSelected("Center");
        if (panel == null) {
            return null;
        }
        if (panel.getComponent().asJComponent() instanceof JEditor) {
            return (JEditor)panel.getComponent().asJComponent();
        }
        return null;
    }

    public ScriptingScript getCurrentScript() {
        JEditor editor = this.getCurrentEditor();
        if (editor == null) {
            return null;
        }
        ScriptingUnit unit = editor.getUnit();
        if (unit instanceof ScriptingScript) {
            return (ScriptingScript)unit;
        }
        return null;
    }

    private RSyntaxTextArea getCurrentRSyntaxTextArea() {
        JTextComponent textComponent;
        JEditor editor = this.getCurrentEditor();
        if (editor instanceof JCodeEditor && (textComponent = ((JCodeEditor)editor).getJTextComponent()) instanceof RSyntaxTextArea) {
            return (RSyntaxTextArea)textComponent;
        }
        return null;
    }

    public void refreshProjects() {
        try {
            this.getProjects().refresh();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JScriptingComposer.StatusBar getStatusbar() {
        return this.statusBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e instanceof SyntaxtHighlightTextComponent.UpdateCaretPositionActionEvent) {
            SyntaxtHighlightTextComponent.UpdateCaretPositionActionEvent e2 = (SyntaxtHighlightTextComponent.UpdateCaretPositionActionEvent)e;
            if (e2.hasLineAndColumn()) {
                this.getStatusbar().setPosition(e2.getLine(), e2.getColumn());
            } else {
                this.getStatusbar().setPosition(0, 0);
            }
        }
    }

    public void update(Observable observable, Object notification) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.update(observable, notification));
            return;
        }
        if (notification instanceof ScriptingNotification) {
            ScriptingNotification e = (ScriptingNotification)notification;
            if (e.getException() instanceof CompileErrorException) {
                CompileErrorException ce = (CompileErrorException)e.getException();
                JScriptingComposer.Problems problems = this.getProblems();
                if (problems != null) {
                    problems.add("Error", (Exception)ce);
                    this.dock.select("Problems");
                }
            } else if (e.getException() instanceof ExecuteErrorException) {
                JScriptingConsole console;
                ExecuteErrorException ee = (ExecuteErrorException)e.getException();
                JScriptingComposer.Problems problems = this.getProblems();
                if (problems != null) {
                    problems.add("Error", (Exception)ee);
                    this.dock.select("Problems");
                }
                if ((console = this.getConsole()) != null) {
                    console.append(ee.getMessage(), Color.RED.darker());
                    ee.printStackTrace(console.errors());
                }
            } else {
                JScriptingConsole console;
                Exception ex = e.getException();
                JScriptingComposer.Problems problems = this.getProblems();
                if (problems != null) {
                    problems.add("Error", ex);
                    this.dock.select("Problems");
                }
                if ((console = this.getConsole()) != null) {
                    console.append(ex.getMessage(), Color.RED.darker());
                    ex.printStackTrace(console.errors());
                }
            }
        }
    }

    public void closeWindow() {
        this.setVisible(false);
    }

    private class FindReplaceSearchListener
    implements SearchListener {
        private FindReplaceSearchListener() {
        }

        public void searchEvent(SearchEvent e) {
            SearchResult result;
            RSyntaxTextArea textArea = DefaultJScriptingComposer.this.getCurrentRSyntaxTextArea();
            if (textArea == null) {
                return;
            }
            SearchEvent.Type type = e.getType();
            SearchContext context = e.getSearchContext();
            switch (type) {
                default: {
                    result = SearchEngine.markAll((RTextArea)textArea, (SearchContext)context);
                    break;
                }
                case FIND: {
                    result = SearchEngine.find((JTextArea)textArea, (SearchContext)context);
                    if (result.wasFound()) break;
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                    break;
                }
                case REPLACE: {
                    result = SearchEngine.replace((RTextArea)textArea, (SearchContext)context);
                    if (result.wasFound()) break;
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                    break;
                }
                case REPLACE_ALL: {
                    result = SearchEngine.replaceAll((RTextArea)textArea, (SearchContext)context);
                    JOptionPane.showMessageDialog(null, result.getCount() + " occurrences replaced.");
                }
            }
            String text = result.wasFound() ? "Text found; occurrences marked: " + result.getMarkedCount() : (type == SearchEvent.Type.MARK_ALL ? (result.getMarkedCount() > 0 ? "Occurrences marked: " + result.getMarkedCount() : "") : "Text not found");
            DefaultJScriptingComposer.this.getStatusbar().message(text);
        }

        public String getSelectedText() {
            RSyntaxTextArea textArea = DefaultJScriptingComposer.this.getCurrentRSyntaxTextArea();
            if (textArea == null) {
                return "";
            }
            return textArea.getSelectedText();
        }
    }

    public class ButtonWithContext
    extends JButton {
        private static final long serialVersionUID = -7434255417630073101L;

        public ButtonWithContext(Action action) {
            super(action);
            this.setBorderPainted(false);
            this.setText("");
        }

        public Object getContext() {
            return DefaultJScriptingComposer.this;
        }
    }

    private static class ToolEntry {
        private String name;
        private String text;
        private Action action;
        private JComponent component;

        public ToolEntry(String name, Action action, String text) {
            this.name = name;
            this.action = action;
            this.text = text;
        }

        public ToolEntry(String name, Action action) {
            this(name, action, null);
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return this.text;
        }

        public Action getAction() {
            return this.action;
        }

        public JComponent getComponent() {
            return this.component;
        }

        public void setComponent(JComponent component) {
            this.component = component;
        }
    }

    private static class DefaultStatusBar
    extends JPanel
    implements JScriptingComposer.StatusBar {
        private static final long serialVersionUID = -6135634992327170084L;
        private JLabel message;
        private JLabel position;
        private final ScriptingUIManager uimanager;

        public DefaultStatusBar(ScriptingUIManager uimanager) {
            this.uimanager = uimanager;
            this.initComponents();
        }

        private void initComponents() {
            this.message = new JLabel(this.uimanager.getTranslation("Welcome_message"));
            this.position = new JLabel("Line 0:0");
            this.setLayout(new BorderLayout());
            this.add((Component)this.message, "West");
            this.add((Component)this.position, "East");
        }

        public void clear() {
            this.message.setText("");
        }

        public void message(String message) {
            this.message.setText(message);
        }

        public void setPosition(int line) {
            this.setPosition(line, -1);
        }

        public void setPosition(int line, int column) {
            if (line < 0) {
                this.position.setText("");
                return;
            }
            if (column < 0) {
                this.position.setText(this.uimanager.getTranslation("Line") + " " + line + ":0");
            } else {
                this.position.setText(this.uimanager.getTranslation("Line") + " " + line + ":" + column);
            }
        }

        public JComponent asJComponent() {
            return this;
        }
    }

    private class ProjectDeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 9039455504757742743L;

        public ProjectDeleteAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Delete"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-doc-remove"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Delete_selected_script"));
            this.putValue("ActionCommandKey", "Delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DefaultJScriptingComposer.this.scriptDelete(DefaultJScriptingComposer.this.getLauncherSelectedUnit(), false);
            }
            catch (Exception e1) {
                LOGGER.warn("Can't delete document", (Throwable)e1);
            }
        }
    }

    private class ProjectMoveAction
    extends AbstractAction {
        private static final long serialVersionUID = -8857101021126773295L;

        public ProjectMoveAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Move"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-doc-move"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Move_files"));
            this.putValue("ActionCommandKey", "Move");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DefaultJScriptingComposer.this.scriptMove(DefaultJScriptingComposer.this.getLauncherSelectedUnit());
            }
            catch (Exception e1) {
                LOGGER.warn("Can't move document", (Throwable)e1);
            }
        }
    }

    private class ProjectRenameAction
    extends AbstractAction {
        private static final long serialVersionUID = 7469858242486966790L;

        public ProjectRenameAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Rename"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-doc-rename"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Set_file_properties"));
            this.putValue("ActionCommandKey", "Rename");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DefaultJScriptingComposer.this.scriptRename(DefaultJScriptingComposer.this.getLauncherSelectedUnit());
            }
            catch (Exception e1) {
                LOGGER.warn("Can't rename document", (Throwable)e1);
            }
        }
    }

    private class ProjectRefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = 1944121660002532563L;

        public ProjectRefreshAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Refresh"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-refresh"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Refresh_directories"));
            this.putValue("ActionCommandKey", "ProjectsRefresh");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.refreshProjects();
        }
    }

    private class ProjectRunAction
    extends AbstractAction {
        private static final long serialVersionUID = -3393464285985649074L;

        public ProjectRunAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Run"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-run"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Run"));
            this.putValue("ActionCommandKey", "ProjectRun");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ScriptingUnit selectedItem = DefaultJScriptingComposer.this.getLauncherSelectedUnit();
                if (selectedItem instanceof ScriptingScript) {
                    DefaultJScriptingComposer.this.scriptExecute((ScriptingScript)selectedItem);
                }
            }
            catch (Exception e1) {
                LOGGER.warn("Can't execute script", (Throwable)e1);
            }
        }
    }

    private class ProjectEditAction
    extends AbstractAction {
        private static final long serialVersionUID = -3393464285985649074L;

        public ProjectEditAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Edit"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-doc-edit"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Open_edition_mode"));
            this.putValue("ActionCommandKey", "DocumentEdit");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ScriptingUnit selectedItem = DefaultJScriptingComposer.this.getLauncherSelectedUnit();
                if (DefaultJScriptingComposer.this.uimanager.hasEditor(selectedItem)) {
                    DefaultJScriptingComposer.this.scriptEdit(selectedItem);
                }
            }
            catch (Exception e1) {
                LOGGER.warn("Can't edit document", (Throwable)e1);
            }
        }
    }

    private class NewFolderAction
    extends AbstractAction {
        private static final long serialVersionUID = 7889613706183211620L;

        public NewFolderAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("New folder"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-folder-add"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("New folder"));
            this.putValue("ActionCommandKey", "FolderNew");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DefaultJScriptingComposer.this.FolderNew();
            }
            catch (Exception e1) {
                LOGGER.warn("Can't create a new folder", (Throwable)e1);
            }
        }
    }

    private class NewDocumentAction
    extends AbstractAction {
        private static final long serialVersionUID = 7889613706183211620L;

        public NewDocumentAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("New"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-doc-add"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("New"));
            this.putValue("ActionCommandKey", "DocumentNew");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DefaultJScriptingComposer.this.scriptNew();
            }
            catch (Exception e1) {
                LOGGER.warn("Can't create a new document", (Throwable)e1);
            }
        }
    }

    private class ShowProjectsAction
    extends AbstractAction {
        private static final long serialVersionUID = 5873598740133693862L;

        public ShowProjectsAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Projects"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-show-projects"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Show_projects_panel"));
            this.putValue("ActionCommandKey", "ShowProjects");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.addProjectsPanel();
        }
    }

    private class ShowProblemsAction
    extends AbstractAction {
        private static final long serialVersionUID = 5276964996914550830L;

        public ShowProblemsAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Problems"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-show-problems"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Show_problems_panel"));
            this.putValue("ActionCommandKey", "ShowProblems");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.addProblemsPanel();
        }
    }

    private class ShowConsoleAction
    extends AbstractAction {
        private static final long serialVersionUID = -7545333555439711068L;

        public ShowConsoleAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Console"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-show-console"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Show_console_panel"));
            this.putValue("ActionCommandKey", "ShowConsole");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.addConsolePanel();
        }
    }

    private class CloseDocumentAction
    extends AbstractAction {
        private static final long serialVersionUID = 4152188500446249755L;

        public CloseDocumentAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Close_document"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-doc-close"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Close_current_tab"));
            this.putValue("ActionCommandKey", "DocumentClose");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.currentScriptClose();
        }

        @Override
        public boolean isEnabled() {
            JScriptingComposer.Dock.DockedPanel panel = DefaultJScriptingComposer.this.dock.getSelected("Center");
            return panel != null;
        }
    }

    private class CloseAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 3385142920283598457L;

        public CloseAllAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Close_all_documents"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-doc-closeall"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Close_all_documents"));
            this.putValue("ActionCommandKey", "CloseAll");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.closeAllScripts();
        }

        @Override
        public boolean isEnabled() {
            JScriptingComposer.Dock.DockedPanel panel = DefaultJScriptingComposer.this.dock.getSelected("Center");
            return panel != null;
        }
    }

    private class SaveAndRunAction
    extends AbstractAction {
        private static final long serialVersionUID = 4851968883766990149L;

        public SaveAndRunAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Save and run"));
            int c = DefaultJScriptingComposer.this.getToolkit().getMenuShortcutKeyMask();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-save-and-run"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Save and run"));
            this.putValue("ActionCommandKey", "DocumentSaveAndRun");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.currentScriptSave();
            DefaultJScriptingComposer.this.currentScriptExecute();
        }

        @Override
        public boolean isEnabled() {
            JScriptingComposer.Dock.DockedPanel panel = DefaultJScriptingComposer.this.dock.getSelected("Center");
            return panel != null;
        }
    }

    private class SelectMainScriptAction
    extends AbstractAction {
        private static final long serialVersionUID = 4851968883766990149L;

        public SelectMainScriptAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("_Select_main_script"));
            int c = DefaultJScriptingComposer.this.getToolkit().getMenuShortcutKeyMask();
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-select-main"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("_Select_main_script"));
            this.putValue("ActionCommandKey", "SelectMainScript");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.mainScriptSelect();
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    private class RunMainAction
    extends AbstractAction {
        private static final long serialVersionUID = 4851968883766990149L;

        public RunMainAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("_Run_main_script"));
            int c = DefaultJScriptingComposer.this.getToolkit().getMenuShortcutKeyMask();
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-run-main"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("_Run_main_script"));
            this.putValue("ActionCommandKey", "RunMainScript");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.mainScriptExecute();
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    private class RunAction
    extends AbstractAction {
        private static final long serialVersionUID = 4851968883766990149L;

        public RunAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Run"));
            int c = DefaultJScriptingComposer.this.getToolkit().getMenuShortcutKeyMask();
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-run"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Run"));
            this.putValue("ActionCommandKey", "DocumentRun");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.currentScriptExecute();
        }

        @Override
        public boolean isEnabled() {
            JScriptingComposer.Dock.DockedPanel panel = DefaultJScriptingComposer.this.dock.getSelected("Center");
            return panel != null;
        }
    }

    private class ReloadAction
    extends AbstractAction {
        private static final long serialVersionUID = -870379961486387727L;

        public ReloadAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Reload"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Reload"));
            this.putValue("ActionCommandKey", "DocumentReload");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.currentScriptReload();
        }

        @Override
        public boolean isEnabled() {
            JScriptingComposer.Dock.DockedPanel panel = DefaultJScriptingComposer.this.dock.getSelected("Center");
            return panel != null;
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = -870379961486387727L;

        public SaveAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Save"));
            int c = DefaultJScriptingComposer.this.getToolkit().getMenuShortcutKeyMask();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, c));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-doc-save"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Save"));
            this.putValue("ActionCommandKey", "DocumentSave");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.currentScriptSave();
        }

        @Override
        public boolean isEnabled() {
            JScriptingComposer.Dock.DockedPanel panel = DefaultJScriptingComposer.this.dock.getSelected("Center");
            return panel != null;
        }
    }

    private class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 9165363564675325925L;

        public ExitAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Close"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-exit"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Close"));
            this.putValue("ActionCommandKey", "CloseComposer");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.closeAllScripts();
            DefaultJScriptingComposer.this.closeWindow();
            if (DefaultJScriptingComposer.this.defaultActionlistener != null) {
                ActionEvent event = new ActionEvent(this, 1, "close");
                DefaultJScriptingComposer.this.defaultActionlistener.actionPerformed(event);
            }
        }
    }

    private class PasteAction
    extends AbstractAction {
        private static final long serialVersionUID = -5829551248494873061L;

        public PasteAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Paste"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-edit-paste"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Paste"));
            this.putValue("ActionCommandKey", "DocumentPaste");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.currentScriptPaste();
        }

        @Override
        public boolean isEnabled() {
            JScriptingComposer.Dock.DockedPanel panel = DefaultJScriptingComposer.this.dock.getSelected("Center");
            return panel != null && panel.getComponent() instanceof JTextEditor;
        }
    }

    private class CopyAction
    extends AbstractAction {
        private static final long serialVersionUID = -6870773810752024874L;

        public CopyAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Copy"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-edit-copy"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Copy"));
            this.putValue("ActionCommandKey", "DocumentCopy");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.currentScriptCopy();
        }

        @Override
        public boolean isEnabled() {
            JScriptingComposer.Dock.DockedPanel panel = DefaultJScriptingComposer.this.dock.getSelected("Center");
            return panel != null && panel.getComponent() instanceof JTextEditor;
        }
    }

    private class CutAction
    extends AbstractAction {
        private static final long serialVersionUID = -8549655706085425411L;

        public CutAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Cut"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-edit-cut"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Cut"));
            this.putValue("ActionCommandKey", "DocumentCut");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.currentScriptCut();
        }

        @Override
        public boolean isEnabled() {
            JScriptingComposer.Dock.DockedPanel panel = DefaultJScriptingComposer.this.dock.getSelected("Center");
            return panel != null && panel.getComponent() instanceof JTextEditor;
        }
    }

    private class AboutAction
    extends AbstractAction {
        private static final long serialVersionUID = -4928359535828269502L;

        public AboutAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("About_scripts_editor"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-about"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("About_scripts_editor"));
            this.putValue("ActionCommandKey", "About");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.getWindowManager().showWindow((JComponent)DefaultJScriptingComposer.this.getAboutUsDialog(), DefaultJScriptingComposer.this.uimanager.getTranslation("About_scripts_editor"), WindowManager.MODE.WINDOW);
        }
    }

    private class PackageScriptAction
    extends AbstractAction {
        private static final long serialVersionUID = 8020393562984016720L;

        public PackageScriptAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("_Package_script"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-package"));
            this.putValue("ActionCommandKey", "PackageScript");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.createScriptPackage();
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 2725549699989067383L;

        public SelectAllAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Select_all"));
            this.putValue("SmallIcon", DefaultJScriptingComposer.this.uimanager.getIcon("scripting-edit-select-all"));
            this.putValue("ShortDescription", DefaultJScriptingComposer.this.uimanager.getTranslation("Select_all"));
            this.putValue("ActionCommandKey", "DocumentSelectAll");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.currentScriptSelectAll();
        }

        @Override
        public boolean isEnabled() {
            JScriptingComposer.Dock.DockedPanel panel = DefaultJScriptingComposer.this.dock.getSelected("Center");
            return panel != null && panel.getComponent() instanceof JTextEditor;
        }
    }

    private class LauncherAction
    extends AbstractAction {
        private static final long serialVersionUID = 6257776255757689286L;

        public LauncherAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("Launcher"));
            this.putValue("ActionCommandKey", "ShowLauncher");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJScriptingComposer.this.getWindowManager().showWindow(DefaultJScriptingComposer.this.uimanager.createLauncher().asJComponent(), DefaultJScriptingComposer.this.uimanager.getTranslation("Scripting_Launcher"), WindowManager.MODE.TOOL);
        }
    }

    private class ShowReplaceDialogAction
    extends AbstractAction {
        private static final long serialVersionUID = 7209167803487996060L;

        public ShowReplaceDialogAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("replace_Xhorizontal_ellipsisX"));
            int c = DefaultJScriptingComposer.this.getToolkit().getMenuShortcutKeyMask();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(72, c));
            this.putValue("ActionCommandKey", "ShowReplaceDialog");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DefaultJScriptingComposer.this.findDialog.isVisible()) {
                DefaultJScriptingComposer.this.findDialog.setVisible(false);
            }
            DefaultJScriptingComposer.this.replaceDialog.setVisible(true);
        }

        @Override
        public boolean isEnabled() {
            JScriptingComposer.Dock.DockedPanel panel = DefaultJScriptingComposer.this.dock.getSelected("Center");
            return panel != null && panel.getComponent() instanceof JTextEditor;
        }
    }

    private class ShowFindDialogAction
    extends AbstractAction {
        private static final long serialVersionUID = -7840632153011361661L;

        public ShowFindDialogAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("find_Xhorizontal_ellipsisX"));
            int c = DefaultJScriptingComposer.this.getToolkit().getMenuShortcutKeyMask();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, c));
            this.putValue("ActionCommandKey", "ShowFindDialog");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DefaultJScriptingComposer.this.replaceDialog.isVisible()) {
                DefaultJScriptingComposer.this.replaceDialog.setVisible(false);
            }
            DefaultJScriptingComposer.this.findDialog.setVisible(true);
        }

        @Override
        public boolean isEnabled() {
            JScriptingComposer.Dock.DockedPanel panel = DefaultJScriptingComposer.this.dock.getSelected("Center");
            return panel != null && panel.getComponent() instanceof JTextEditor;
        }
    }

    private class GoToLineAction
    extends AbstractAction {
        private static final long serialVersionUID = -7353913671104893812L;

        public GoToLineAction() {
            super(DefaultJScriptingComposer.this.uimanager.getTranslation("go_to_line_Xhorizontal_ellipsisX"));
            int c = DefaultJScriptingComposer.this.getToolkit().getMenuShortcutKeyMask();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, c));
            this.putValue("ActionCommandKey", "GotoLine");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JEditor editor = DefaultJScriptingComposer.this.getCurrentEditor();
            if (!(editor instanceof JTextEditor)) {
                return;
            }
            JTextEditor textEditor = (JTextEditor)editor;
            if (DefaultJScriptingComposer.this.findDialog.isVisible()) {
                DefaultJScriptingComposer.this.findDialog.setVisible(false);
            }
            if (DefaultJScriptingComposer.this.replaceDialog.isVisible()) {
                DefaultJScriptingComposer.this.replaceDialog.setVisible(false);
            }
            DefaultJScriptingComposer.this.gotoDialog.setMaxLineNumberAllowed(textEditor.getLineCount());
            DefaultJScriptingComposer.this.gotoDialog.setVisible(true);
            int line = DefaultJScriptingComposer.this.gotoDialog.getLineNumber();
            if (line > 0) {
                textEditor.selectLine(line);
            }
        }

        @Override
        public boolean isEnabled() {
            JScriptingComposer.Dock.DockedPanel panel = DefaultJScriptingComposer.this.dock.getSelected("Center");
            return panel != null && panel.getComponent() instanceof JTextEditor;
        }
    }
}

